/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.pcollections.PStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsPStack<E>
extends AbstractSequentialList<E>
implements PStack<E> {
    private static final ConsPStack<Object> EMPTY = new ConsPStack();
    private final E first;
    private final ConsPStack<E> rest;
    private final int size;

    public static <E> ConsPStack<E> empty() {
        return EMPTY;
    }

    public static <E> ConsPStack<E> singleton(E e) {
        return ConsPStack.empty().plus((Object)e);
    }

    public static <E> ConsPStack<E> from(Collection<? extends E> list) {
        if (list instanceof ConsPStack) {
            return (ConsPStack)list;
        }
        return ConsPStack.from(list.iterator());
    }

    private static <E> ConsPStack<E> from(Iterator<? extends E> i) {
        if (!i.hasNext()) {
            return ConsPStack.empty();
        }
        E e = i.next();
        return ConsPStack.from(i).plus((Object)e);
    }

    private ConsPStack() {
        if (EMPTY != null) {
            throw new RuntimeException("empty constructor should only be used once");
        }
        this.size = 0;
        this.first = null;
        this.rest = null;
    }

    private ConsPStack(E first, ConsPStack<E> rest) {
        this.first = first;
        this.rest = rest;
        this.size = 1 + rest.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new ListIterator<E>(){
            int i;
            ConsPStack<E> next;
            {
                this.i = index;
                this.next = ConsPStack.this.subList(index);
            }

            @Override
            public boolean hasNext() {
                return this.next.size > 0;
            }

            @Override
            public boolean hasPrevious() {
                return this.i > 0;
            }

            @Override
            public int nextIndex() {
                return index;
            }

            @Override
            public int previousIndex() {
                return index - 1;
            }

            @Override
            public E next() {
                Object e = this.next.first;
                this.next = this.next.rest;
                return e;
            }

            @Override
            public E previous() {
                System.err.println("ConsPStack.listIterator().previous() is inefficient, don't use it!");
                this.next = ConsPStack.this.subList(index - 1);
                return this.next.first;
            }

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ConsPStack<E> subList(int start, int end) {
        if (start < 0 || end > this.size || start > end) {
            throw new IndexOutOfBoundsException();
        }
        if (end == this.size) {
            return this.subList(start);
        }
        if (start == end) {
            return ConsPStack.empty();
        }
        if (start == 0) {
            return new ConsPStack<E>(this.first, this.rest.subList(0, end - 1));
        }
        return this.rest.subList(start - 1, end - 1);
    }

    @Override
    public ConsPStack<E> plus(E e) {
        return new ConsPStack<E>(e, this);
    }

    @Override
    public ConsPStack<E> plusAll(Collection<? extends E> list) {
        PStack<E> result = this;
        for (E e : list) {
            result = result.plus((Object)e);
        }
        return result;
    }

    @Override
    public ConsPStack<E> plus(int i, E e) {
        if (i < 0 || i > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (i == 0) {
            return this.plus((Object)e);
        }
        return new ConsPStack<E>(this.first, this.rest.plus(i - 1, (Object)e));
    }

    @Override
    public ConsPStack<E> plusAll(int i, Collection<? extends E> list) {
        if (i < 0 || i > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (i == 0) {
            return this.plusAll((Collection)list);
        }
        return new ConsPStack<E>(this.first, this.rest.plusAll(i - 1, (Collection)list));
    }

    @Override
    public ConsPStack<E> minus(Object e) {
        if (this.size == 0) {
            return this;
        }
        if (this.first.equals(e)) {
            return this.rest;
        }
        PStack newRest = this.rest.minus(e);
        if (newRest == this.rest) {
            return this;
        }
        return new ConsPStack<E>(this.first, newRest);
    }

    @Override
    public ConsPStack<E> minus(int i) {
        return this.minus(this.get(i));
    }

    @Override
    public ConsPStack<E> minusAll(Collection<?> list) {
        if (this.size == 0) {
            return this;
        }
        if (list.contains(this.first)) {
            return this.rest.minusAll((Collection)list);
        }
        PStack newRest = this.rest.minusAll((Collection)list);
        if (newRest == this.rest) {
            return this;
        }
        return new ConsPStack<E>(this.first, newRest);
    }

    @Override
    public ConsPStack<E> with(int i, E e) {
        if (i < 0 || i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (i == 0) {
            if (this.first.equals(e)) {
                return this;
            }
            return new ConsPStack<E>(e, this.rest);
        }
        PStack newRest = this.rest.with(i - 1, (Object)e);
        if (newRest == this.rest) {
            return this;
        }
        return new ConsPStack<E>(this.first, newRest);
    }

    @Override
    public ConsPStack<E> subList(int start) {
        if (start < 0 || start > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (start == 0) {
            return this;
        }
        return this.rest.subList(start - 1);
    }
}

