/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(name="PreconditionsCheckNotNull", summary="Literal passed as first argument to Preconditions.checkNotNull() can never be null", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class PreconditionsCheckNotNull
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> matcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), Matchers.argument((int)0, (Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.STRING_LITERAL))});

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!matcher.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        ExpressionTree stringLiteralValue = arguments.get(0);
        SuggestedFix fix = arguments.size() == 2 ? SuggestedFix.swap((Tree)arguments.get(0), (Tree)arguments.get(1)) : SuggestedFix.delete((Tree)state.getPath().getParentPath().getLeaf());
        return this.describeMatch(stringLiteralValue, (Fix)fix);
    }
}

