/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.serialver;

import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import sun.tools.serialver.Res;

public class SerialVer {
    static URLClassLoader loader = null;

    static void initializeLoader(String cp) throws IOException {
        String[] paths = cp.split(File.pathSeparator);
        int count = paths.length;
        URL[] urls = new URL[count];
        for (int i = 0; i < count; ++i) {
            urls[i] = Paths.get(paths[i], new String[0]).toUri().toURL();
        }
        loader = new URLClassLoader(urls);
    }

    static String serialSyntax(String classname) throws ClassNotFoundException {
        String ret = null;
        boolean classFound = false;
        if (classname.indexOf(36) != -1) {
            ret = SerialVer.resolveClass(classname);
        } else {
            try {
                ret = SerialVer.resolveClass(classname);
                classFound = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!classFound) {
                int i;
                StringBuilder workBuffer = new StringBuilder(classname);
                String workName = workBuffer.toString();
                while ((i = workName.lastIndexOf(46)) != -1 && !classFound) {
                    workBuffer.setCharAt(i, '$');
                    try {
                        workName = workBuffer.toString();
                        ret = SerialVer.resolveClass(workName);
                        classFound = true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
            if (!classFound) {
                throw new ClassNotFoundException();
            }
        }
        return ret;
    }

    static String resolveClass(String classname) throws ClassNotFoundException {
        Class<?> cl = Class.forName(classname, false, loader);
        ObjectStreamClass desc = ObjectStreamClass.lookup(cl);
        if (desc != null) {
            return "    private static final long serialVersionUID = " + desc.getSerialVersionUID() + "L;";
        }
        return null;
    }

    public static void main(String[] args) {
        String envcp = null;
        int i = 0;
        if (args.length == 0) {
            SerialVer.usage();
            System.exit(1);
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-classpath")) {
                if (i + 1 == args.length || args[i + 1].startsWith("-")) {
                    System.err.println(Res.getText("error.missing.classpath"));
                    SerialVer.usage();
                    System.exit(1);
                }
                envcp = new String(args[i + 1]);
                ++i;
                continue;
            }
            if (!args[i].startsWith("-")) break;
            System.err.println(Res.getText("invalid.flag", args[i]));
            SerialVer.usage();
            System.exit(1);
        }
        if (envcp == null && (envcp = System.getProperty("env.class.path")) == null) {
            envcp = ".";
        }
        try {
            SerialVer.initializeLoader(envcp);
        }
        catch (MalformedURLException mue) {
            System.err.println(Res.getText("error.parsing.classpath", envcp));
            System.exit(2);
        }
        catch (IOException ioe) {
            System.err.println(Res.getText("error.parsing.classpath", envcp));
            System.exit(3);
        }
        if (i == args.length) {
            SerialVer.usage();
            System.exit(1);
        }
        boolean exitFlag = false;
        while (i < args.length) {
            try {
                String syntax = SerialVer.serialSyntax(args[i]);
                if (syntax != null) {
                    System.out.println(args[i] + ":" + syntax);
                } else {
                    System.err.println(Res.getText("NotSerializable", args[i]));
                    exitFlag = true;
                }
            }
            catch (ClassNotFoundException cnf) {
                System.err.println(Res.getText("ClassNotFound", args[i]));
                exitFlag = true;
            }
            ++i;
        }
        if (exitFlag) {
            System.exit(1);
        }
    }

    public static void usage() {
        System.err.println(Res.getText("usage"));
    }
}

