/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessFixes;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.TrustingNullnessAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;

@BugPattern(name="ReturnMissingNullable", summary="Methods that can return null should be annotated @Nullable", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ReturnMissingNullable
extends BugChecker
implements BugChecker.ReturnTreeMatcher {
    public Description matchReturn(ReturnTree tree, VisitorState state) {
        ExpressionTree returnExpression = tree.getExpression();
        if (returnExpression == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.constValue((Tree)returnExpression) != null) {
            return Description.NO_MATCH;
        }
        JCTree.JCMethodDecl method = ReturnMissingNullable.findSurroundingMethod(state.getPath());
        if (method == null || this.isIgnoredReturnType(method, state)) {
            return Description.NO_MATCH;
        }
        if (TrustingNullnessAnalysis.hasNullableAnnotation((Element)method.sym)) {
            return Description.NO_MATCH;
        }
        if (returnExpression.getKind() == Tree.Kind.NULL_LITERAL) {
            return this.makeFix(state, method, tree, "Returning null literal");
        }
        Nullness nullness = TrustingNullnessAnalysis.instance((Context)state.context).getNullness(new TreePath(state.getPath(), returnExpression), state.context);
        switch (nullness) {
            case BOTTOM: 
            case NONNULL: {
                return Description.NO_MATCH;
            }
            case NULL: {
                return this.makeFix(state, method, tree, "Definitely returning null");
            }
            case NULLABLE: {
                return this.makeFix(state, method, tree, "May return null");
            }
        }
        throw new AssertionError((Object)("Impossible: " + nullness));
    }

    private boolean isIgnoredReturnType(JCTree.JCMethodDecl method, VisitorState state) {
        Type returnType = method.sym.getReturnType();
        return returnType.isPrimitiveOrVoid() || state.getTypes().isSameType(returnType, state.getTypeFromString("java.lang.Void"));
    }

    private Description makeFix(VisitorState state, Tree declaration, Tree matchedTree, String message) {
        return this.buildDescription(matchedTree).setMessage(message).addFix((Fix)NullnessFixes.makeFix(state, declaration)).build();
    }

    @Nullable
    private static JCTree.JCMethodDecl findSurroundingMethod(TreePath path) {
        while (path.getLeaf().getKind() != Tree.Kind.METHOD) {
            if (path.getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                return null;
            }
            path = path.getParentPath();
        }
        return (JCTree.JCMethodDecl)path.getLeaf();
    }
}

