/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordStatistics;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class LocalMapStatsProvider {
    protected static final int WAIT_PARTITION_TABLE_UPDATE_MILLIS = 100;
    protected static final int RETRY_COUNT = 3;
    protected final ConcurrentMap<String, LocalMapStatsImpl> statsMap = new ConcurrentHashMap<String, LocalMapStatsImpl>(1000);
    protected final ConstructorFunction<String, LocalMapStatsImpl> constructorFunction = new ConstructorFunction<String, LocalMapStatsImpl>(){

        @Override
        public LocalMapStatsImpl createNew(String key) {
            return new LocalMapStatsImpl();
        }
    };
    protected final MapServiceContext mapServiceContext;
    protected final NearCacheProvider nearCacheProvider;
    protected final ClusterService clusterService;
    protected final InternalPartitionService partitionService;
    protected final ILogger logger;
    protected final boolean iterateStats;

    public LocalMapStatsProvider(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.logger = nodeEngine.getLogger(this.getClass());
        this.nearCacheProvider = mapServiceContext.getNearCacheProvider();
        this.clusterService = nodeEngine.getClusterService();
        this.partitionService = nodeEngine.getPartitionService();
        this.iterateStats = nodeEngine.getGroupProperties().getBoolean(GroupProperty.ITERATING_MAP_STATS_ENABLED);
    }

    public LocalMapStatsImpl getLocalMapStatsImpl(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.constructorFunction);
    }

    public void destroyLocalMapStatsImpl(String name) {
        this.statsMap.remove(name);
    }

    public LocalMapStatsImpl createLocalMapStats(String mapName) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        LocalMapStatsImpl stats = this.getLocalMapStatsImpl(mapName);
        if (!mapContainer.getMapConfig().isStatisticsEnabled()) {
            return stats;
        }
        int backupCount = mapContainer.getTotalBackupCount();
        Address thisAddress = this.clusterService.getThisAddress();
        LocalMapOnDemandCalculatedStats onDemandStats = new LocalMapOnDemandCalculatedStats();
        onDemandStats.setBackupCount(backupCount);
        this.addNearCacheStats(stats, onDemandStats, mapContainer);
        for (int partitionId = 0; partitionId < this.partitionService.getPartitionCount(); ++partitionId) {
            InternalPartition partition = this.partitionService.getPartition(partitionId);
            Address owner = partition.getOwnerOrNull();
            if (owner == null) continue;
            if (owner.equals(thisAddress)) {
                this.addOwnerPartitionStats(stats, onDemandStats, mapName, partitionId);
                continue;
            }
            this.addReplicaPartitionStats(onDemandStats, mapName, partitionId, partition, this.partitionService, backupCount, thisAddress);
        }
        onDemandStats.copyValuesTo(stats);
        return stats;
    }

    protected void addOwnerPartitionStats(LocalMapStatsImpl stats, LocalMapOnDemandCalculatedStats onDemandStats, String mapName, int partitionId) {
        RecordStore recordStore = this.getRecordStoreOrNull(mapName, partitionId);
        if (!this.hasRecords(recordStore)) {
            return;
        }
        int lockedEntryCount = 0;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        long hits = 0L;
        if (this.iterateStats) {
            Iterator<Record> iterator = recordStore.iterator();
            while (iterator.hasNext()) {
                Record record = iterator.next();
                Data key = record.getKey();
                hits += this.getHits(record);
                lockedEntryCount += this.isLocked(key, recordStore);
                lastAccessTime = Math.max(lastAccessTime, record.getLastAccessTime());
                lastUpdateTime = Math.max(lastUpdateTime, record.getLastUpdateTime());
            }
        }
        onDemandStats.incrementLockedEntryCount(lockedEntryCount);
        onDemandStats.incrementHits(hits);
        onDemandStats.incrementDirtyEntryCount(recordStore.getMapDataStore().notFinishedOperationsCount());
        onDemandStats.incrementOwnedEntryMemoryCost(recordStore.getHeapCost());
        onDemandStats.incrementHeapCost(recordStore.getHeapCost());
        onDemandStats.incrementOwnedEntryCount(recordStore.size());
        stats.setLastAccessTime(lastAccessTime);
        stats.setLastUpdateTime(lastUpdateTime);
    }

    protected long getHits(Record record) {
        RecordStatistics stats = record.getStatistics();
        return stats.getHits();
    }

    protected int isLocked(Data key, RecordStore recordStore) {
        if (recordStore.isLocked(key)) {
            return 1;
        }
        return 0;
    }

    protected void addReplicaPartitionStats(LocalMapOnDemandCalculatedStats onDemandStats, String mapName, int partitionId, InternalPartition partition, InternalPartitionService partitionService, int backupCount, Address thisAddress) {
        long backupEntryCount = 0L;
        long backupEntryMemoryCost = 0L;
        for (int replica = 1; replica <= backupCount; ++replica) {
            RecordStore recordStore;
            Address replicaAddress = this.getReplicaAddress(replica, partition, partitionService, backupCount);
            if (!this.isReplicaAvailable(replicaAddress, partitionService, backupCount)) {
                this.printWarning(partition, replica);
                continue;
            }
            if (!this.isReplicaOnThisNode(replicaAddress, thisAddress) || !this.hasRecords(recordStore = this.getRecordStoreOrNull(mapName, partitionId))) continue;
            backupEntryMemoryCost += recordStore.getHeapCost();
            backupEntryCount += (long)recordStore.size();
        }
        onDemandStats.incrementHeapCost(backupEntryMemoryCost);
        onDemandStats.incrementBackupEntryMemoryCost(backupEntryMemoryCost);
        onDemandStats.incrementBackupEntryCount(backupEntryCount);
    }

    protected boolean hasRecords(RecordStore recordStore) {
        return recordStore != null && recordStore.size() > 0;
    }

    protected boolean isReplicaAvailable(Address replicaAddress, InternalPartitionService partitionService, int backupCount) {
        return replicaAddress != null || partitionService.getMemberGroupsSize() <= backupCount;
    }

    protected boolean isReplicaOnThisNode(Address replicaAddress, Address thisAddress) {
        return replicaAddress != null && replicaAddress.equals(thisAddress);
    }

    protected void printWarning(InternalPartition partition, int replica) {
        this.logger.warning("Partition: " + partition + ", replica: " + replica + " has no owner!");
    }

    protected RecordStore getRecordStoreOrNull(String mapName, int partitionId) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        return partitionContainer.getExistingRecordStore(mapName);
    }

    protected Address getReplicaAddress(int replica, InternalPartition partition, InternalPartitionService partitionService, int backupCount) {
        Address replicaAddress = partition.getReplicaAddress(replica);
        if (replicaAddress == null) {
            replicaAddress = this.waitForReplicaAddress(replica, partition, partitionService, backupCount);
        }
        return replicaAddress;
    }

    protected Address waitForReplicaAddress(int replica, InternalPartition partition, InternalPartitionService partitionService, int backupCount) {
        int tryCount = 3;
        Address replicaAddress = null;
        while (replicaAddress == null && partitionService.getMemberGroupsSize() > backupCount && tryCount-- > 0) {
            this.sleep();
            replicaAddress = partition.getReplicaAddress(replica);
        }
        return replicaAddress;
    }

    protected void sleep() {
        try {
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected void addNearCacheStats(LocalMapStatsImpl stats, LocalMapOnDemandCalculatedStats onDemandStats, MapContainer mapContainer) {
        if (!mapContainer.getMapConfig().isNearCacheEnabled()) {
            return;
        }
        NearCache nearCache = this.nearCacheProvider.getOrCreateNearCache(mapContainer.getName());
        NearCacheStats nearCacheStats = nearCache.getNearCacheStats();
        long nearCacheHeapCost = mapContainer.getNearCacheSizeEstimator().getSize();
        stats.setNearCacheStats(nearCacheStats);
        onDemandStats.incrementHeapCost(nearCacheHeapCost);
    }

    protected static class LocalMapOnDemandCalculatedStats {
        protected long hits;
        protected long ownedEntryCount;
        protected long backupEntryCount;
        protected long ownedEntryMemoryCost;
        protected long backupEntryMemoryCost;
        protected long heapCost;
        protected long lockedEntryCount;
        protected long dirtyEntryCount;
        protected int backupCount;

        protected LocalMapOnDemandCalculatedStats() {
        }

        public void setBackupCount(int backupCount) {
            this.backupCount = backupCount;
        }

        public void incrementHits(long hits) {
            this.hits += hits;
        }

        public void incrementOwnedEntryCount(long ownedEntryCount) {
            this.ownedEntryCount += ownedEntryCount;
        }

        public void incrementBackupEntryCount(long backupEntryCount) {
            this.backupEntryCount += backupEntryCount;
        }

        public void incrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
            this.ownedEntryMemoryCost += ownedEntryMemoryCost;
        }

        public void incrementBackupEntryMemoryCost(long backupEntryMemoryCost) {
            this.backupEntryMemoryCost += backupEntryMemoryCost;
        }

        public void incrementLockedEntryCount(long lockedEntryCount) {
            this.lockedEntryCount += lockedEntryCount;
        }

        public void incrementDirtyEntryCount(long dirtyEntryCount) {
            this.dirtyEntryCount += dirtyEntryCount;
        }

        public void incrementHeapCost(long heapCost) {
            this.heapCost += heapCost;
        }

        public void copyValuesTo(LocalMapStatsImpl stats) {
            stats.setBackupCount(this.backupCount);
            stats.setHits(this.hits);
            stats.setOwnedEntryCount(this.ownedEntryCount);
            stats.setBackupEntryCount(this.backupEntryCount);
            stats.setOwnedEntryMemoryCost(this.ownedEntryMemoryCost);
            stats.setBackupEntryMemoryCost(this.backupEntryMemoryCost);
            stats.setHeapCost(this.heapCost);
            stats.setLockedEntryCount(this.lockedEntryCount);
            stats.setDirtyEntryCount(this.dirtyEntryCount);
        }
    }
}

