/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.ListenerWrapperEventFilter;
import com.hazelcast.spi.NotifiableEventListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.util.Set;
import java.util.concurrent.Callable;

public class CacheAddEntryListenerRequest
extends BaseClientAddListenerRequest {
    private String name;

    public CacheAddEntryListenerRequest() {
    }

    public CacheAddEntryListenerRequest(String name) {
        this.name = name;
    }

    public Object call() {
        ClientEndpointImpl endpoint = (ClientEndpointImpl)this.getEndpoint();
        final ICacheService service = (ICacheService)this.getService();
        CacheEntryListener cacheEntryListener = new CacheEntryListener(this.getCallId(), endpoint);
        final String registrationId = service.registerListener(this.name, cacheEntryListener, cacheEntryListener, this.localOnly);
        endpoint.addDestroyAction(registrationId, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return service.deregisterListener(CacheAddEntryListenerRequest.this.name, registrationId);
            }
        });
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 22;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(this.name, "listen");
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "registerCacheEntryListener";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Class is Serializable, but doesn't define serialVersionUID")
    private static final class CacheEntryListener
    implements CacheEventListener,
    NotifiableEventListener<ICacheService>,
    ListenerWrapperEventFilter,
    Serializable {
        private final long callId;
        private final transient ClientEndpoint endpoint;

        private CacheEntryListener(long callId, ClientEndpoint endpoint) {
            this.callId = callId;
            this.endpoint = endpoint;
        }

        private Data getPartitionKey(Object eventObject) {
            Data partitionKey = null;
            if (eventObject instanceof CacheEventSet) {
                Set<CacheEventData> events = ((CacheEventSet)eventObject).getEvents();
                if (events.size() > 1) {
                    partitionKey = new HeapData();
                } else if (events.size() == 1) {
                    partitionKey = events.iterator().next().getDataKey();
                }
            } else if (eventObject instanceof CacheEventData) {
                partitionKey = ((CacheEventData)eventObject).getDataKey();
            }
            return partitionKey;
        }

        @Override
        public void handleEvent(Object eventObject) {
            if (this.endpoint.isAlive()) {
                Data partitionKey = this.getPartitionKey(eventObject);
                this.endpoint.sendEvent(partitionKey, eventObject, this.callId);
            }
        }

        @Override
        public void onRegister(ICacheService service, String serviceName, String topic, EventRegistration registration) {
            CacheContext cacheContext = service.getOrCreateCacheContext(topic);
            cacheContext.increaseCacheEntryListenerCount();
        }

        @Override
        public void onDeregister(ICacheService service, String serviceName, String topic, EventRegistration registration) {
            CacheContext cacheContext = service.getOrCreateCacheContext(topic);
            cacheContext.decreaseCacheEntryListenerCount();
        }

        @Override
        public Object getListener() {
            return this;
        }

        @Override
        public boolean eval(Object event) {
            return true;
        }
    }
}

