/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.pool;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.pool.KryoCallback;
import com.esotericsoftware.kryo.pool.KryoFactory;
import java.lang.ref.SoftReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KryoPool2 {
    private final ThreadLocal<SoftReference<Kryo>> queue;
    private final KryoFactory factory;

    public KryoPool2(KryoFactory factory) {
        this(factory, new ThreadLocal<SoftReference<Kryo>>());
    }

    public KryoPool2(KryoFactory factory, ThreadLocal<SoftReference<Kryo>> queue) {
        this.factory = factory;
        this.queue = queue;
    }

    public Kryo borrow() {
        Kryo res;
        SoftReference<Kryo> ref = this.queue.get();
        if (ref != null && (res = ref.get()) != null) {
            return res;
        }
        return this.factory.create();
    }

    public void release(Kryo kryo) {
        Kryo res;
        SoftReference<Kryo> ref = this.queue.get();
        if (ref == null || (res = ref.get()) == null) {
            this.queue.set(new SoftReference<Kryo>(kryo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T run(KryoCallback<T> callback) {
        Kryo kryo = this.borrow();
        try {
            T t = callback.execute(kryo);
            return t;
        }
        finally {
            this.release(kryo);
        }
    }
}

