/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.common.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IntervalAggregationDescriptor {
    private final int numSubIntervals;
    private final List<Duration> intervalSizes;

    public static IntervalAggregationDescriptor create(int numSubIntervals, List<Duration> intervalSizes) {
        if (numSubIntervals < 2 || numSubIntervals > 20) {
            throw new IllegalArgumentException("The number of subintervals must be in the range [2, 20].");
        }
        if (intervalSizes.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one interval size.");
        }
        return new IntervalAggregationDescriptor(numSubIntervals, Collections.unmodifiableList(new ArrayList<Duration>(intervalSizes)));
    }

    public static IntervalAggregationDescriptor create(List<Duration> intervalSizes) {
        return IntervalAggregationDescriptor.create(5, intervalSizes);
    }

    public int getNumSubIntervals() {
        return this.numSubIntervals;
    }

    public List<Duration> getIntervalSizes() {
        return this.intervalSizes;
    }

    private IntervalAggregationDescriptor(int numSubIntervals, List<Duration> intervalSizes) {
        this.numSubIntervals = numSubIntervals;
        this.intervalSizes = intervalSizes;
    }
}

