/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.autocodec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.devtools.build.lib.skyframe.serialization.InjectingObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.autocodec.SerializationCodeGenerator;
import com.google.devtools.build.lib.skyframe.serialization.strings.StringCodecs;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.ProtocolMessageEnum;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

class Marshallers {
    private final ProcessingEnvironment env;
    private final SerializationCodeGenerator arrayCodeGenerator = new SerializationCodeGenerator(){

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            String length = context.makeName("length");
            context.builder.addStatement("int $L = $L.length", new Object[]{length, context.name});
            context.builder.addStatement("codedOut.writeInt32NoTag($L)", new Object[]{length});
            SerializationCodeGenerator.Context repeated = context.with(((ArrayType)context.type).getComponentType(), context.makeName("repeated"));
            String indexName = context.makeName("i");
            context.builder.beginControlFlow("for(int $L = 0; $L < $L; ++$L)", new Object[]{indexName, indexName, length, indexName});
            context.builder.addStatement("$T $L = $L[$L]", new Object[]{repeated.getTypeName(), repeated.name, context.name, indexName});
            Marshallers.this.writeSerializationCode(repeated);
            context.builder.endControlFlow();
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            SerializationCodeGenerator.Context repeated = context.with(((ArrayType)context.type).getComponentType(), context.makeName("repeated"));
            String lengthName = context.makeName("length");
            context.builder.addStatement("int $L = codedIn.readInt32()", new Object[]{lengthName});
            String resultName = context.makeName("result");
            context.builder.addStatement("$T[] $L = new $T[$L]", new Object[]{repeated.getTypeName(), resultName, repeated.getTypeName(), lengthName});
            String indexName = context.makeName("i");
            context.builder.beginControlFlow("for (int $L = 0; $L < $L; ++$L)", new Object[]{indexName, indexName, lengthName, indexName});
            Marshallers.this.writeDeserializationCode(repeated);
            context.builder.addStatement("$L[$L] = $L", new Object[]{resultName, indexName, repeated.name});
            context.builder.endControlFlow();
            context.builder.addStatement("$L = $L", new Object[]{context.name, resultName});
        }
    };
    private final SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator intCodeGenerator = new SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator(){

        @Override
        public boolean matches(PrimitiveType type) {
            return type.getKind() == TypeKind.INT;
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeInt32NoTag($L)", new Object[]{context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = codedIn.readInt32()", new Object[]{context.name});
        }
    };
    private final SerializationCodeGenerator.Marshaller enumMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.env.getTypeUtils().asElement(type).getKind() == ElementKind.ENUM;
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            if (this.isProtoEnum(context.getDeclaredType())) {
                context.builder.addStatement("codedOut.writeInt32NoTag($L.getNumber())", new Object[]{context.name});
            } else {
                context.builder.addStatement("codedOut.writeInt32NoTag($L.ordinal())", new Object[]{context.name});
            }
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            if (this.isProtoEnum(context.getDeclaredType())) {
                context.builder.addStatement("$L = $T.forNumber(codedIn.readInt32())", new Object[]{context.name, context.getTypeName()});
            } else {
                context.builder.addStatement("$L = $T.values()[codedIn.readInt32()]", new Object[]{context.name, context.getTypeName()});
            }
        }

        private boolean isProtoEnum(DeclaredType type) {
            return Marshallers.this.env.getTypeUtils().isSubtype(type, Marshallers.this.env.getElementUtils().getTypeElement(ProtocolMessageEnum.class.getCanonicalName()).asType());
        }
    };
    private final SerializationCodeGenerator.Marshaller stringMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesType(type, String.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$T.asciiOptimized().serialize($L, codedOut)", new Object[]{StringCodecs.class, context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = $T.asciiOptimized().deserialize(codedIn)", new Object[]{context.name, StringCodecs.class});
        }
    };
    private final SerializationCodeGenerator.Marshaller optionalMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, com.google.common.base.Optional.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            DeclaredType optionalType = (DeclaredType)context.getDeclaredType().getTypeArguments().get(0);
            Marshallers.this.writeSerializationCode(context.with(optionalType, context.name + ".orNull()"));
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            DeclaredType optionalType = (DeclaredType)context.getDeclaredType().getTypeArguments().get(0);
            String optionalName = context.makeName("optional");
            Marshallers.this.writeDeserializationCode(context.with(optionalType, optionalName));
            context.builder.addStatement("$L = $T.fromNullable($L)", new Object[]{context.name, com.google.common.base.Optional.class, optionalName});
        }
    };
    private final SerializationCodeGenerator.Marshaller mapEntryMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, Map.Entry.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            DeclaredType keyType = (DeclaredType)context.getDeclaredType().getTypeArguments().get(0);
            Marshallers.this.writeSerializationCode(context.with(keyType, context.name + ".getKey()"));
            DeclaredType valueType = (DeclaredType)context.getDeclaredType().getTypeArguments().get(1);
            Marshallers.this.writeSerializationCode(context.with(valueType, context.name + ".getValue()"));
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            DeclaredType keyType = (DeclaredType)context.getDeclaredType().getTypeArguments().get(0);
            String keyName = context.makeName("key");
            Marshallers.this.writeDeserializationCode(context.with(keyType, keyName));
            DeclaredType valueType = (DeclaredType)context.getDeclaredType().getTypeArguments().get(1);
            String valueName = context.makeName("value");
            Marshallers.this.writeDeserializationCode(context.with(valueType, valueName));
            context.builder.addStatement("$L = $T.immutableEntry($L, $L)", new Object[]{context.name, Maps.class, keyName, valueName});
        }
    };
    private final SerializationCodeGenerator.Marshaller listMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, Iterable.class) || Marshallers.this.matchesErased(type, Collection.class) || Marshallers.this.matchesErased(type, List.class) || Marshallers.this.matchesErased(type, ImmutableList.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeInt32NoTag($L.size())", new Object[]{context.name});
            SerializationCodeGenerator.Context repeated = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(0), context.makeName("repeated"));
            context.builder.beginControlFlow("for ($T $L : $L)", new Object[]{repeated.getTypeName(), repeated.name, context.name});
            Marshallers.this.writeSerializationCode(repeated);
            context.builder.endControlFlow();
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            SerializationCodeGenerator.Context repeated = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(0), context.makeName("repeated"));
            String builderName = context.makeName("builder");
            context.builder.addStatement("$T<$T> $L = new $T<>()", new Object[]{ImmutableList.Builder.class, repeated.getTypeName(), builderName, ImmutableList.Builder.class});
            Marshallers.this.writeListDeserializationLoopAndBuild(context, repeated, builderName);
        }
    };
    private final SerializationCodeGenerator.Marshaller immutableSetMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, ImmutableSet.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            Marshallers.this.listMarshaller.addSerializationCode(context);
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            SerializationCodeGenerator.Context repeated = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(0), context.makeName("repeated"));
            String builderName = context.makeName("builder");
            context.builder.addStatement("$T<$T> $L = new $T<>()", new Object[]{ImmutableSet.Builder.class, repeated.getTypeName(), builderName, ImmutableSet.Builder.class});
            Marshallers.this.writeListDeserializationLoopAndBuild(context, repeated, builderName);
        }
    };
    private final SerializationCodeGenerator.Marshaller immutableSortedSetMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, ImmutableSortedSet.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            Marshallers.this.listMarshaller.addSerializationCode(context);
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            SerializationCodeGenerator.Context repeated = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(0), context.makeName("repeated"));
            String builderName = context.makeName("builder");
            context.builder.addStatement("$T<$T> $L = new $T<>($T.naturalOrder())", new Object[]{ImmutableSortedSet.Builder.class, repeated.getTypeName(), builderName, ImmutableSortedSet.Builder.class, Comparator.class});
            Marshallers.this.writeListDeserializationLoopAndBuild(context, repeated, builderName);
        }
    };
    private final SerializationCodeGenerator.Marshaller mapMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, Map.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeInt32NoTag($L.size())", new Object[]{context.name});
            String entryName = context.makeName("entry");
            SerializationCodeGenerator.Context key = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(0), entryName + ".getKey()");
            SerializationCodeGenerator.Context value = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(1), entryName + ".getValue()");
            context.builder.beginControlFlow("for ($T<$T, $T> $L : $L.entrySet())", new Object[]{Map.Entry.class, key.getTypeName(), value.getTypeName(), entryName, context.name});
            Marshallers.this.writeSerializationCode(key);
            Marshallers.this.writeSerializationCode(value);
            context.builder.endControlFlow();
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            Marshallers.this.addMapDeserializationCode(context, (builderName, key, value) -> context.builder.addStatement("$T<$T, $T> $L = new $T<>()", new Object[]{LinkedHashMap.class, key.getTypeName(), value.getTypeName(), builderName, LinkedHashMap.class}), builderName -> context.builder.addStatement("$L = $L", new Object[]{context.name, builderName}));
        }
    };
    private final SerializationCodeGenerator.Marshaller immutableMapMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, ImmutableMap.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            Marshallers.this.mapMarshaller.addSerializationCode(context);
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            Marshallers.this.addMapDeserializationCode(context, (builderName, key, value) -> context.builder.addStatement("$T<$T, $T> $L = new $T<>()", new Object[]{ImmutableMap.Builder.class, key.getTypeName(), value.getTypeName(), builderName, ImmutableMap.Builder.class}), builderName -> context.builder.addStatement("$L = $L.build()", new Object[]{context.name, builderName}));
        }
    };
    private final SerializationCodeGenerator.Marshaller immutableSortedMapMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, ImmutableSortedMap.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            Marshallers.this.mapMarshaller.addSerializationCode(context);
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            Marshallers.this.addMapDeserializationCode(context, (builderName, key, value) -> context.builder.addStatement("$T<$T, $T> $L = new $T<>($T.naturalOrder())", new Object[]{ImmutableSortedMap.Builder.class, key.getTypeName(), value.getTypeName(), builderName, ImmutableSortedMap.Builder.class, Comparator.class}), builderName -> context.builder.addStatement("$L = $L.build()", new Object[]{context.name, builderName}));
        }
    };
    private final SerializationCodeGenerator.Marshaller multimapMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesErased(type, ImmutableMultimap.class) || Marshallers.this.matchesErased(type, ImmutableListMultimap.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeInt32NoTag($L.size())", new Object[]{context.name});
            String entryName = context.makeName("entry");
            SerializationCodeGenerator.Context key = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(0), entryName + ".getKey()");
            SerializationCodeGenerator.Context value = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(1), entryName + ".getValue()");
            context.builder.beginControlFlow("for ($T<$T, $T> $L : $L.entries())", new Object[]{Map.Entry.class, key.getTypeName(), value.getTypeName(), entryName, context.name});
            Marshallers.this.writeSerializationCode(key);
            Marshallers.this.writeSerializationCode(value);
            context.builder.endControlFlow();
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            SerializationCodeGenerator.Context key = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(0), context.makeName("key"));
            SerializationCodeGenerator.Context value = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(1), context.makeName("value"));
            String builderName = context.makeName("builder");
            context.builder.addStatement("$T<$T, $T> $L = new $T<>()", new Object[]{ImmutableListMultimap.Builder.class, key.getTypeName(), value.getTypeName(), builderName, ImmutableListMultimap.Builder.class});
            String lengthName = context.makeName("length");
            context.builder.addStatement("int $L = codedIn.readInt32()", new Object[]{lengthName});
            String indexName = context.makeName("i");
            context.builder.beginControlFlow("for (int $L = 0; $L < $L; ++$L)", new Object[]{indexName, indexName, lengthName, indexName});
            Marshallers.this.writeDeserializationCode(key);
            Marshallers.this.writeDeserializationCode(value);
            context.builder.addStatement("$L.put($L, $L)", new Object[]{builderName, key.name, value.name});
            context.builder.endControlFlow();
            context.builder.addStatement("$L = $L.build()", new Object[]{context.name, builderName});
        }
    };
    private final SerializationCodeGenerator.Marshaller patternMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesType(type, Pattern.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$T.asciiOptimized().serialize($L.pattern(), codedOut)", new Object[]{StringCodecs.class, context.name});
            context.builder.addStatement("codedOut.writeInt32NoTag($L.flags())", new Object[]{context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = $T.compile($T.asciiOptimized().deserialize(codedIn), codedIn.readInt32())", new Object[]{context.name, Pattern.class, StringCodecs.class});
        }
    };
    private final SerializationCodeGenerator.Marshaller hashCodeMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.matchesType(type, HashCode.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeByteArrayNoTag($L.asBytes())", new Object[]{context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("$L = $T.fromBytes(codedIn.readByteArray())", new Object[]{context.name, HashCode.class});
        }
    };
    private final SerializationCodeGenerator.Marshaller protoMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.this.isSubtype(type, AbstractMessage.class);
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            context.builder.addStatement("codedOut.writeMessageNoTag($L)", new Object[]{context.name});
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            String builderName = context.makeName("builder");
            context.builder.addStatement("$T.Builder $L = $T.newBuilder()", new Object[]{context.getTypeName(), builderName, context.getTypeName()});
            context.builder.addStatement("codedIn.readMessage($L, $T.getEmptyRegistry())", new Object[]{builderName, ExtensionRegistryLite.class});
            context.builder.addStatement("$L = $L.build()", new Object[]{context.name, builderName});
        }
    };
    private final SerializationCodeGenerator.Marshaller codecMarshaller = new SerializationCodeGenerator.Marshaller(){

        @Override
        public boolean matches(DeclaredType type) {
            return Marshallers.getCodec(type).isPresent();
        }

        @Override
        public void addSerializationCode(SerializationCodeGenerator.Context context) {
            TypeMirror codecType = ((Element)Marshallers.getCodec(context.getDeclaredType()).get()).asType();
            if (Marshallers.this.isSubtypeErased(codecType, ObjectCodec.class)) {
                context.builder.addStatement("$T.CODEC.serialize($L, codedOut)", new Object[]{context.getTypeName(), context.name});
            } else if (Marshallers.this.isSubtypeErased(codecType, InjectingObjectCodec.class)) {
                context.builder.addStatement("$T.CODEC.serialize(dependency, $L, codedOut)", new Object[]{context.getTypeName(), context.name});
            } else {
                throw new IllegalArgumentException("CODEC field of " + ((TypeElement)context.getDeclaredType().asElement()).getQualifiedName() + " is neither ObjectCodec nor InjectingCodec");
            }
        }

        @Override
        public void addDeserializationCode(SerializationCodeGenerator.Context context) {
            TypeMirror codecType = ((Element)Marshallers.getCodec(context.getDeclaredType()).get()).asType();
            if (Marshallers.this.isSubtypeErased(codecType, ObjectCodec.class)) {
                context.builder.addStatement("$L = $T.CODEC.deserialize(codedIn)", new Object[]{context.name, context.getTypeName()});
            } else if (Marshallers.this.isSubtypeErased(codecType, InjectingObjectCodec.class)) {
                context.builder.addStatement("$L = $T.CODEC.deserialize(dependency, codedIn)", new Object[]{context.name, context.getTypeName()});
            } else {
                throw new IllegalArgumentException("CODEC field of " + ((TypeElement)context.getDeclaredType().asElement()).getQualifiedName() + " is neither ObjectCodec nor InjectingCodec");
            }
        }
    };
    private final ImmutableList<SerializationCodeGenerator.PrimitiveValueSerializationCodeGenerator> primitiveGenerators = ImmutableList.of((Object)this.intCodeGenerator);
    private final ImmutableList<SerializationCodeGenerator.Marshaller> marshallers = ImmutableList.of((Object)this.enumMarshaller, (Object)this.stringMarshaller, (Object)this.optionalMarshaller, (Object)this.mapEntryMarshaller, (Object)this.listMarshaller, (Object)this.immutableSetMarshaller, (Object)this.immutableSortedSetMarshaller, (Object)this.mapMarshaller, (Object)this.immutableMapMarshaller, (Object)this.immutableSortedMapMarshaller, (Object)this.multimapMarshaller, (Object)this.patternMarshaller, (Object[])new SerializationCodeGenerator.Marshaller[]{this.hashCodeMarshaller, this.protoMarshaller, this.codecMarshaller});

    Marshallers(ProcessingEnvironment env) {
        this.env = env;
    }

    void writeSerializationCode(SerializationCodeGenerator.Context context) {
        if (context.canBeNull()) {
            context.builder.beginControlFlow("if ($L != null)", new Object[]{context.name});
            context.builder.addStatement("codedOut.writeBoolNoTag(true)", new Object[0]);
        }
        this.getMatchingCodeGenerator(context.type).addSerializationCode(context);
        if (context.canBeNull()) {
            context.builder.nextControlFlow("else", new Object[0]);
            context.builder.addStatement("codedOut.writeBoolNoTag(false)", new Object[0]);
            context.builder.endControlFlow();
        }
    }

    void writeDeserializationCode(SerializationCodeGenerator.Context context) {
        if (context.canBeNull()) {
            context.builder.addStatement("$T $L = null", new Object[]{context.getTypeName(), context.name});
            context.builder.beginControlFlow("if (codedIn.readBool())", new Object[0]);
        } else {
            context.builder.addStatement("$T $L", new Object[]{context.getTypeName(), context.name});
        }
        this.getMatchingCodeGenerator(context.type).addDeserializationCode(context);
        if (Marshallers.requiresNullityCheck(context)) {
            context.builder.endControlFlow();
        }
    }

    void writeListDeserializationLoopAndBuild(SerializationCodeGenerator.Context context, SerializationCodeGenerator.Context repeated, String builderName) {
        String lengthName = context.makeName("length");
        context.builder.addStatement("int $L = codedIn.readInt32()", new Object[]{lengthName});
        String indexName = context.makeName("i");
        context.builder.beginControlFlow("for (int $L = 0; $L < $L; ++$L)", new Object[]{indexName, indexName, lengthName, indexName});
        this.writeDeserializationCode(repeated);
        context.builder.addStatement("$L.add($L)", new Object[]{builderName, repeated.name});
        context.builder.endControlFlow();
        context.builder.addStatement("$L = $L.build()", new Object[]{context.name, builderName});
    }

    private static boolean requiresNullityCheck(SerializationCodeGenerator.Context context) {
        return !(context.type instanceof PrimitiveType);
    }

    private SerializationCodeGenerator getMatchingCodeGenerator(TypeMirror type) {
        if (type.getKind() == TypeKind.ARRAY) {
            return this.arrayCodeGenerator;
        }
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            return this.primitiveGenerators.stream().filter(generator -> generator.matches((PrimitiveType)type)).findFirst().orElseThrow(() -> new IllegalArgumentException("No generator for: " + primitiveType));
        }
        if (!(type instanceof DeclaredType)) {
            throw new IllegalArgumentException("Can only serialize primitive, array or declared fields, found " + type);
        }
        DeclaredType declaredType = (DeclaredType)type;
        return this.marshallers.stream().filter(marshaller -> marshaller.matches(declaredType)).findFirst().orElseThrow(() -> new IllegalArgumentException("No marshaller for: " + ((TypeElement)declaredType.asElement()).getQualifiedName()));
    }

    private void addMapDeserializationCode(SerializationCodeGenerator.Context context, MapBuilderInitializer mapBuilderInitializer, Consumer<String> finisher) {
        String builderName = context.makeName("builder");
        SerializationCodeGenerator.Context key = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(0), context.makeName("key"));
        SerializationCodeGenerator.Context value = context.with((DeclaredType)context.getDeclaredType().getTypeArguments().get(1), context.makeName("value"));
        mapBuilderInitializer.initialize(builderName, key, value);
        String lengthName = context.makeName("length");
        context.builder.addStatement("int $L = codedIn.readInt32()", new Object[]{lengthName});
        String indexName = context.makeName("i");
        context.builder.beginControlFlow("for (int $L = 0; $L < $L; ++$L)", new Object[]{indexName, indexName, lengthName, indexName});
        this.writeDeserializationCode(key);
        this.writeDeserializationCode(value);
        context.builder.addStatement("$L.put($L, $L)", new Object[]{builderName, key.name, value.name});
        context.builder.endControlFlow();
        finisher.accept(builderName);
    }

    private boolean matchesType(TypeMirror type, Class<?> clazz) {
        return this.env.getTypeUtils().isSameType(type, this.getType(clazz));
    }

    private boolean isSubtype(TypeMirror type, Class<?> clazz) {
        return this.env.getTypeUtils().isSubtype(type, this.getType(clazz));
    }

    private boolean matchesErased(TypeMirror type, Class<?> clazz) {
        return this.env.getTypeUtils().isSameType(this.env.getTypeUtils().erasure(type), this.env.getTypeUtils().erasure(this.getType(clazz)));
    }

    private boolean isSubtypeErased(TypeMirror type, Class<?> clazz) {
        return this.env.getTypeUtils().isSubtype(this.env.getTypeUtils().erasure(type), this.env.getTypeUtils().erasure(this.getType(clazz)));
    }

    private TypeMirror getType(Class<?> clazz) {
        return this.env.getElementUtils().getTypeElement(clazz.getCanonicalName()).asType();
    }

    private static Optional<? extends Element> getCodec(DeclaredType type) {
        return type.asElement().getEnclosedElements().stream().filter(t -> t.getModifiers().contains((Object)Modifier.STATIC)).filter(t -> t.getSimpleName().contentEquals("CODEC")).filter(t -> t.getKind() == ElementKind.FIELD).findAny();
    }

    @FunctionalInterface
    private static interface MapBuilderInitializer {
        public void initialize(String var1, SerializationCodeGenerator.Context var2, SerializationCodeGenerator.Context var3);
    }
}

