/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.client.impl.client.MultiTargetClientRequest;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.SerializableList;
import com.hazelcast.transaction.client.ClientTxnPortableHook;
import com.hazelcast.transaction.impl.xa.operations.CollectRemoteTransactionsOperationFactory;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CollectXATransactionsRequest
extends MultiTargetClientRequest {
    @Override
    protected OperationFactory createOperationFactory() {
        return new CollectRemoteTransactionsOperationFactory();
    }

    @Override
    protected Object reduce(Map<Address, Object> map) {
        ArrayList<Data> set = new ArrayList<Data>();
        for (Object o : map.values()) {
            SerializableList xidSet = (SerializableList)o;
            set.addAll(xidSet.getCollection());
        }
        return new SerializableList(set);
    }

    @Override
    public Collection<Address> getTargets() {
        Set<Member> memberList = this.getClientEngine().getClusterService().getMembers();
        HashSet<Address> addresses = new HashSet<Address>();
        for (Member member : memberList) {
            addresses.add(member.getAddress());
        }
        return addresses;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:xaService";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }
}

