/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import de.bottlecaps.markup.blitz.grammar.Alt;
import de.bottlecaps.markup.blitz.grammar.Alts;
import de.bottlecaps.markup.blitz.grammar.Charset;
import de.bottlecaps.markup.blitz.grammar.Control;
import de.bottlecaps.markup.blitz.grammar.Grammar;
import de.bottlecaps.markup.blitz.grammar.Insertion;
import de.bottlecaps.markup.blitz.grammar.Literal;
import de.bottlecaps.markup.blitz.grammar.Nonterminal;
import de.bottlecaps.markup.blitz.grammar.Rule;
import de.bottlecaps.markup.blitz.grammar.Term;
import de.bottlecaps.markup.blitz.transform.PostProcess;
import de.bottlecaps.markup.blitz.transform.Visitor;
import java.util.Stack;

public class Copy
extends Visitor {
    protected final Stack<Alts> alts = new Stack();
    protected final Grammar copy;

    protected Copy(Grammar g) {
        this.copy = g;
    }

    public static Grammar process(Grammar g) {
        Copy c = new Copy(new Grammar(g));
        c.visit(g);
        PostProcess.process(c.copy);
        return c.copy;
    }

    @Override
    public void visit(Rule r) {
        super.visit(r);
        this.copy.addRule(new Rule(r.getMark(), r.getAlias(), r.getName(), this.alts.pop()));
    }

    @Override
    public void visit(Alts a) {
        boolean topLevel = this.alts.isEmpty();
        this.alts.push(new Alts());
        super.visit(a);
        if (!topLevel) {
            Alts nested = this.alts.pop();
            this.alts.peek().last().addAlts(nested);
        }
    }

    @Override
    public void visit(Alt a) {
        this.alts.peek().addAlt(new Alt());
        super.visit(a);
    }

    @Override
    public void visit(Nonterminal n) {
        this.alts.peek().last().getTerms().add((Term)n.copy());
    }

    @Override
    public void visit(Literal l) {
        this.alts.peek().last().getTerms().add((Term)l.copy());
    }

    @Override
    public void visit(Insertion i) {
        this.alts.peek().last().getTerms().add((Term)i.copy());
    }

    @Override
    public void visit(Control c) {
        super.visit(c);
        Term separator = c.getSeparator() == null ? null : this.alts.peek().last().removeLast();
        Term term = this.alts.peek().last().removeLast();
        this.alts.peek().last().getTerms().add(new Control(c.getOccurrence(), term, separator));
    }

    @Override
    public void visit(Charset c) {
        this.alts.peek().last().getTerms().add(c);
    }
}

