/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.file.FileReadTextLines;
import org.basex.query.func.fn.FnItemsAt;
import org.basex.query.func.fn.SeqRange;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.Checks;

public class FnSubsequence
extends StandardFunc {
    private static final SeqRange ALL = new SeqRange(0L, Long.MAX_VALUE);
    private static final SeqRange EMPTY = new SeqRange(0L, 0L);

    @Override
    public final Iter iter(final QueryContext qc) throws QueryException {
        final SeqRange sr = this.range(qc);
        if (sr == EMPTY) {
            return Empty.ITER;
        }
        final Iter input = this.arg(0).iter(qc);
        if (sr == ALL) {
            return input;
        }
        long size = sr.adjust(input.size());
        if (sr.length == 0L) {
            return Empty.ITER;
        }
        if (input.valueIter()) {
            return input.value(qc, null).subsequence(sr.start, sr.length, qc).iter();
        }
        if (size != -1L) {
            if (sr.length == size) {
                return input;
            }
            return new Iter(){
                long c;
                {
                    this.c = sr.start;
                }

                @Override
                public Item next() throws QueryException {
                    return this.c < sr.end ? input.get(this.c++) : null;
                }

                @Override
                public Item get(long i) throws QueryException {
                    return input.get(sr.start + i);
                }

                @Override
                public long size() {
                    return sr.length;
                }
            };
        }
        return new Iter(){
            long c;

            @Override
            public Item next() throws QueryException {
                Item item;
                while (this.c < sr.end && (item = qc.next(input)) != null) {
                    if (++this.c <= sr.start) continue;
                    return item;
                }
                return null;
            }
        };
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        Item item;
        SeqRange sr = this.range(qc);
        if (sr == EMPTY) {
            return Empty.VALUE;
        }
        Expr input = this.arg(0);
        if (sr == ALL) {
            return input.value(qc);
        }
        Iter iter = input.iter(qc);
        long size = sr.adjust(iter.size());
        if (sr.length == 0L) {
            return Empty.VALUE;
        }
        if (iter.valueIter()) {
            return iter.value(qc, null).subsequence(sr.start, sr.length, qc);
        }
        if (size != -1L) {
            if (sr.length == size) {
                return iter.value(qc, this);
            }
            ValueBuilder vb = new ValueBuilder(qc, size);
            for (long i = sr.start; i < sr.end; ++i) {
                vb.add(iter.get(i));
            }
            return vb.value(this);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (long c = 0L; c < sr.end && (item = qc.next(iter)) != null; ++c) {
            if (c < sr.start) continue;
            vb.add(item);
        }
        return vb.value(this);
    }

    final SeqRange range(CompileContext cc) throws QueryException {
        return this.arg(1) instanceof Value && (!this.defined(2) || this.arg(2) instanceof Value) ? this.range(cc.qc) : null;
    }

    private SeqRange range(QueryContext qc) throws QueryException {
        double start = this.toDouble(this.arg(1), qc);
        Item end = this.arg(2).atomItem(qc, this.info);
        if (Double.isNaN(start)) {
            return EMPTY;
        }
        long s = this.start(start);
        long e = Long.MAX_VALUE;
        if (!end.isEmpty()) {
            start = this.toDouble(end);
            if (Double.isNaN(start) || s == Long.MIN_VALUE && start == Double.POSITIVE_INFINITY) {
                return EMPTY;
            }
            e = this.end(s, start);
        }
        if (e == Long.MAX_VALUE && s <= 1L) {
            return ALL;
        }
        if (s == Long.MIN_VALUE) {
            return EMPTY;
        }
        SeqRange sr = new SeqRange(Math.max(0L, s - 1L), e);
        return sr.length == 0L ? EMPTY : sr;
    }

    public long start(double value) {
        return StrictMath.round(value);
    }

    public long end(long first, double second) {
        long l = StrictMath.round(second);
        return l == Long.MAX_VALUE ? l : l + first - 1L;
    }

    protected boolean range() {
        return false;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        Expr first = this.arg(1);
        Expr second = this.arg(2);
        SeqType st = input.seqType();
        if (st.zero()) {
            return input;
        }
        long sz = -1L;
        SeqRange sr = this.range(cc);
        if (sr != null) {
            Expr[] args;
            if (sr == EMPTY) {
                return Empty.VALUE;
            }
            if (sr == ALL) {
                return input;
            }
            if (input instanceof Value) {
                return this.value(cc.qc);
            }
            long size = sr.adjust(input.size());
            if (size != -1L) {
                if (sr.length == size) {
                    return input;
                }
                if (sr.start == size - 1L) {
                    return cc.function(Function.FOOT, this.info, input);
                }
                if (sr.start == 1L && sr.end == size) {
                    return cc.function(Function.TAIL, this.info, input);
                }
                if (sr.start == 0L && sr.end == size - 1L) {
                    return cc.function(Function.TRUNK, this.info, input);
                }
                sz = sr.length;
            } else if (st.zeroOrOne()) {
                return sr.start == 0L ? input : Empty.VALUE;
            }
            if (sr.length == 1L) {
                return sr.start == 0L ? cc.function(Function.HEAD, this.info, input) : cc.function(Function.ITEMS_AT, this.info, input, Itr.get(sr.start + 1L));
            }
            if (sr.length == Long.MAX_VALUE && sr.start == 1L) {
                return cc.function(Function.TAIL, this.info, input);
            }
            if (Function._FILE_READ_TEXT_LINES.is(input)) {
                return FileReadTextLines.opt(this, sr.start, sr.length, cc);
            }
            if (Function.REPLICATE.is(input) && (args = (Expr[])input.args().clone())[0].size() == 1L && args[1] instanceof Itr) {
                args[1] = Itr.get(sr.length);
                return cc.function(Function.REPLICATE, this.info, args);
            }
            if (input instanceof List && sr.start > 0L) {
                args = input.args();
                if (((Checks<Expr>)ex -> ex.seqType().one()).all((Expr[])args)) {
                    return List.get(cc, this.info, Arrays.copyOfRange(args, (int)sr.start, (int)sr.end));
                }
                int al = args.length;
                for (int a = 0; a < al; ++a) {
                    boolean exact = (long)a == sr.start;
                    boolean one = args[a].seqType().one();
                    if (a > 0 && (exact || !one)) {
                        Expr list = List.get(cc, this.info, Arrays.copyOfRange(args, a, al));
                        long start = sr.start - (long)a + 1L;
                        long end = sr.end - start;
                        return cc.function(Function.SUBSEQUENCE, this.info, list, Itr.get(start), Itr.get(end));
                    }
                    if (one) {
                        continue;
                    }
                    break;
                }
            }
        } else if (first instanceof Itr) {
            Itr itr = (Itr)first;
            long start = itr.itr();
            long diff = FnItemsAt.countInputDiff(input, second) + start;
            if (diff == (long)((int)diff)) {
                if (start <= 1L) {
                    if (diff == 0L) {
                        return cc.function(Function.TRUNK, this.info, input);
                    }
                    if (diff >= 1L) {
                        return input;
                    }
                } else if (start <= diff) {
                    return cc.function(Function.SUBSEQUENCE, this.info, input, first);
                }
            }
        } else if (second instanceof Itr) {
            Itr itr = (Itr)second;
            if (!this.range() && first.seqType().instanceOf(SeqType.INTEGER_O)) {
                long length = itr.itr();
                if (length == 1L) {
                    return cc.function(Function.ITEMS_AT, this.info, input, first);
                }
                if (length <= 0L) {
                    return cc.voidAndReturn(input, Empty.VALUE, this.info);
                }
            }
        }
        this.exprType.assign(st.union(Occ.ZERO), sz).data(input);
        return this.embed(cc, false);
    }

    @Override
    public final boolean ddo() {
        return this.arg(0).ddo();
    }
}

