#!/bin/sh

# As a shell script (running on Unix...) it expects to find the local
# copy of your standard Unix shell, the 'tail' utility and a working 'awk'
# interpreter.

# I use the default location for ASSP's maillog file, and the 'maillog.log'
# name (in assp.cfg) to keep ASSP from changing it on me.

# This script attempts to go back at least 300 lines in your maillog.log
# file to give you a nice screenful of goodies to review when it
# first starts.  If your maillog.log is nearly empty, then just
# be patient. As things happen - the logger will reveal it in COLOR!
# ------------------------------------ KRL -------------------------

# Version: 0.04  Nov. 21, 2003
# Fixed "-adds-" substring boo-boo
# Version: 0.03
# Fixed/improved the display of Whitelist additions..(aka: hamlist & normal)

# Simple (sort of...) AWK script to display ASSP 'maillog.txt"
#  data in a useful format.
#
# Uses 'tail' to follow the output, format each line in
#  a nice way - and use COLOR + a 2 Char. Flag to identify
#  each entry as they scroll by. It goes back 100 lines in
#  order to give you a full screen on startup. Also, it assumes
#  ANSI Color mode for your screen to display the lines in color.
#
# BS (in Red) lines are those caught by the Bayesian filter !!
# LW (in White .. mostly) are those Local or Whitelisted eMails
# Ok (in Green) are eMail that fully pass alltests without exceptions.
# RB (in Cyan) .. Blocked Relay attempt
# WL+  Whitelist ADDITION by an authorized local user
# BA (in Cyan) .. Bad ATTACHEMENT rejected
# SR (in Cyan) .. spam@ report submission
# NS (in Cyan) .. notspam@ report submission
#
# I got the idea for this script from Mark Constable. He submitted
#  a similar script to follow the Courier-MTA /var/log/maillog
#  Thanks,
#  Randy Lewis, RTMX.NET
#  Nov., 2003
#
# NOTES:
# Some fields are truncated (with a hard-coded length value, usually 40)
#   to keep each line more or less intact on your screen as things scroll by
# Colors are coded with ANSI Color coding, your mileage may vary ...
# I assume the naming convention of 'maillog.log' so ASSP won't munge
#  each current log into some difficult-to-grok name.  You should try
#  to use this feature - and perhaps roll the log periodically with
#  your system's 'newsyslog' functionality. You can send a SIGHUP to
#  ASSP when you roll the log so it starts afresh..KRL

tail -300 -f /usr/local/assp/maillog.log | \
 awk  ' \
  /whitelisted/ { \
  printf("%s %s \033[1;32m%-15s L\033[0mW  %s \033[1;32m->\033[0m %s\n", \
        substr($1,1,length($1)), \
        substr($2,1,length($2)), \
        substr($3,1,length($3)), \
        substr($4,1,40), \
        substr($6,1,length($6)) )\
        } \
  /email/ && /whitelist addition/ { \
  printf("%s %s \033[1;32m%-15s W\033[0mA+ %s \033[1;32m->\033[0m %s\n", \
        substr($1,1,length($1)), \
        substr($2,1,length($2)), \
        "+email address+", \
        substr($4,1,40), \
        substr($6,1,length($6)) )\
        } \
  /whitelist addition/ && !/email/ { \
  printf("%s %s \033[1;32m%-15s W\033[0mL+ %s \033[1;32m %s %s\033[0m\n", \
        substr($1,1,length($1)), \
        substr($2,1,length($2)), \
        substr($3,1,length($3)), \
        substr($4,1,40), \
        "-adds-", \
        substr($9,1,length($9)) )\
        } \
  /Bayesian spam/ { \
  printf("%s %s \033[1;31m%-15s BS  %s -> %s\033[0m\n", \
          substr($1,1,length($1)), \
          substr($2,1,length($2)), \
          substr($3,1,length($3)), \
          substr($4,1,40), \
        substr($6,1,length($6)) )\
        } \
  /message ok/ { \
  printf("%s %s \033[1;32m%-15s Ok  %s -> %s\033[0m\n", \
        substr($1,1,length($1)), \
        substr($2,1,length($2)), \
        substr($3,1,length($3)), \
        substr($4,1,40), \
        substr($6,1,length($6)) )\
        } \
  /bad attachment/ { \
        printf("%s %s \033[1;35m%-15s BA  %s -> %s\033[0m\n", \
        substr($1,1,length($1)), \
        substr($2,1,length($2)), \
        substr($3,1,length($3)), \
        substr($4,1,40), \
        substr($6,1,length($6)) )\
        } \
  /relay attempt blocked/ { \
        printf("%s %s \033[1;35m%-15s RB  %s -> %s %s %s %s %s\033[0m\n", \
        substr($1,1,length($1)), \
        substr($2,1,length($2)), \
        substr($3,1,length($3)), \
        substr($4,1,length($4)), \
        substr($5,1,length($5)), \
        substr($6,1,length($6)), \
        substr($7,1,length($7)), \
        substr($8,1,length($8)), \
        substr($9,1,length($9)) )\
        } \
  /Admin update:/ { \
  printf("\033[1;33m%s %s %s %s %s %s \033[0m\n", $1, $2, $3, $4, $5, $6) \
        } \
  /Email spamreport/ { \
  printf("%s %s\033[0;36m %-15s SR  %s Email SPAM Submission\033[0m\n", \
        substr($1,1,length($1)), \
        substr($2,1,length($2)), \
        substr($3,1,length($3)), \
        substr($4,1,length($4)) ) \
        } \
  /Email hamreport/ { \
  printf("%s %s\033[0;36m %-15s NS  %s Email NOTSPAM Submission\033[0m\n", \
        substr($1,1,length($1)), \
        substr($2,1,length($2)), \
        substr($3,1,length($3)), \
        substr($4,1,length($4)) ) \
 }'
# end of script

