/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRandom;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Random;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Random::Base"}, parent="Object")
public class RubyRandomBase
extends RubyObject {
    protected RubyRandom.RandomType random = null;

    public RubyRandomBase(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    static int getIntBigIntegerBuffer(byte[] src, int loc) {
        int v = 0;
        int idx = src.length - loc * 4 - 1;
        if (idx >= 0) {
            v |= src[idx--] & 0xFF;
            if (idx >= 0) {
                v |= (src[idx--] & 0xFF) << 8;
                if (idx >= 0) {
                    v |= (src[idx--] & 0xFF) << 16;
                    if (idx >= 0) {
                        v |= (src[idx--] & 0xFF) << 24;
                    }
                }
            }
        }
        return v;
    }

    static void setIntBigIntegerBuffer(byte[] dest, int loc, int value2) {
        int idx = dest.length - loc * 4 - 1;
        if (idx >= 0) {
            dest[idx--] = (byte)(value2 & 0xFF);
            if (idx >= 0) {
                dest[idx--] = (byte)(value2 >> 8 & 0xFF);
                if (idx >= 0) {
                    dest[idx--] = (byte)(value2 >> 16 & 0xFF);
                    if (idx >= 0) {
                        dest[idx--] = (byte)(value2 >> 24 & 0xFF);
                    }
                }
            }
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, optional=1, checkArity=false)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        this.checkFrozen();
        this.random = new RubyRandom.RandomType(argc == 0 ? RubyRandom.randomSeed(context.runtime) : args2[0]);
        return this;
    }

    @JRubyMethod
    public IRubyObject seed(ThreadContext context) {
        return this.random.getSeed();
    }

    @JRubyMethod(name={"rand"}, meta=true)
    public static IRubyObject randDefault(ThreadContext context, IRubyObject recv2) {
        RubyRandom.RandomType random = RubyRandom.getDefaultRand(context);
        return RubyRandom.randFloat(context, random);
    }

    @JRubyMethod(name={"rand"}, meta=true)
    public static IRubyObject randDefault(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        IRubyObject v = RubyRandom.randRandom(context, recv2, RubyRandom.getDefaultRand(context), arg2);
        RubyRandom.checkRandomNumber(context, v, arg2);
        return v;
    }

    @JRubyMethod(name={"rand"})
    public IRubyObject rand(ThreadContext context) {
        return RubyRandomBase.randFloat(context, this.random);
    }

    @JRubyMethod(name={"rand"})
    public IRubyObject rand(ThreadContext context, IRubyObject arg2) {
        IRubyObject v1;
        IRubyObject v = v1 = RubyRandomBase.randRandom(context, this, this.random, arg2);
        RubyRandom.checkRandomNumber(context, v, arg2);
        return v;
    }

    static IRubyObject randInt(ThreadContext context, IRubyObject self2, RubyRandom.RandomType random, RubyInteger vmax, boolean restrictive) {
        if (vmax instanceof RubyFixnum) {
            long max2 = RubyNumeric.fix2long(vmax);
            if (max2 == 0L) {
                return context.nil;
            }
            if (max2 < 0L) {
                if (restrictive) {
                    return context.nil;
                }
                max2 = -max2;
            }
            return RubyRandomBase.randomUlongLimited(context, self2, random, max2 - 1L);
        }
        BigInteger big = vmax.getBigIntegerValue();
        if (big.equals(BigInteger.ZERO)) {
            return context.nil;
        }
        if (big.signum() < 0) {
            if (restrictive) {
                return context.nil;
            }
            big = big.abs();
        }
        big = big.subtract(BigInteger.ONE);
        return RubyRandomBase.randomUlongLimitedBig(context, self2, random, big);
    }

    public static RubyFloat randFloat(ThreadContext context) {
        return RubyRandomBase.randFloat(context, RubyRandomBase.getDefaultRand(context));
    }

    public static RubyFloat randFloat(ThreadContext context, RubyRandom.RandomType random) {
        return context.runtime.newFloat(random.genrandReal());
    }

    public static RubyInteger randLimited(ThreadContext context, long limit2) {
        return RubyRandomBase.randLimitedFixnum(context, RubyRandomBase.getDefaultRand(context), limit2);
    }

    private static RubyInteger randLimitedFixnum(ThreadContext context, RubyRandom.RandomType random, long limit2) {
        Ruby runtime2 = context.runtime;
        if (limit2 == 0L) {
            return RubyFixnum.zero(runtime2);
        }
        Random impl2 = random == null ? new Random(runtime2.getDefaultRandom().random.genrandInt32()) : random.impl;
        return RubyFixnum.newFixnum(runtime2, RubyRandomBase.randLimitedFixnumInner(impl2, limit2));
    }

    public static long randLimitedFixnumInner(Random random, long limit2) {
        long val;
        if (limit2 == 0L) {
            val = 0L;
        } else {
            long mask = RubyRandomBase.makeMask(limit2);
            block0: while (true) {
                val = 0L;
                for (int i2 = 1; 0 <= i2; --i2) {
                    if ((mask >>> i2 * 32 & 0xFFFFFFFFL) != 0L) {
                        val |= ((long)random.genrandInt32() & 0xFFFFFFFFL) << i2 * 32;
                        val &= mask;
                    }
                    if (limit2 < val) continue block0;
                }
                break;
            }
        }
        return val;
    }

    public static RubyInteger randLimited(ThreadContext context, BigInteger limit2) {
        return RubyRandomBase.limitedBigRand(context, RubyRandomBase.getDefaultRand(context), limit2);
    }

    private static IRubyObject randomUlongLimited(ThreadContext context, IRubyObject self2, RubyRandom.RandomType random, long limit2) {
        if (limit2 == 0L) {
            return RubyFixnum.zero(context.runtime);
        }
        if (random == null) {
            int octets = limit2 <= Integer.MAX_VALUE ? 4 : 8;
            byte[] octetBytes = RubyRandomBase.objRandomBytes(context, self2, octets);
            long randLong = 0L;
            for (byte b2 : octetBytes) {
                randLong = (randLong << 8) + Byte.toUnsignedLong(b2);
            }
            if (randLong < 0L) {
                randLong = -randLong;
            }
            if (randLong > limit2) {
                randLong %= limit2;
            }
            return RubyFixnum.newFixnum(context.runtime, randLong);
        }
        return RubyRandomBase.randLimitedFixnum(context, random, limit2);
    }

    private static RubyInteger randomUlongLimitedBig(ThreadContext context, IRubyObject self2, RubyRandom.RandomType random, BigInteger limit2) {
        if (random == null) {
            int octets = (int)((long)limit2.bitLength() + 7L) / 8;
            byte[] octetBytes = RubyRandomBase.objRandomBytes(context, self2, octets);
            BigInteger randBig = new BigInteger(octetBytes);
            if (randBig.compareTo(BigInteger.ZERO) < 0) {
                randBig = randBig.abs();
            }
            if (randBig.compareTo(limit2) > 0) {
                randBig = randBig.mod(limit2);
            }
            return RubyBignum.bignorm(context.runtime, randBig);
        }
        return RubyRandomBase.limitedBigRand(context, random, limit2);
    }

    private static byte[] objRandomBytes(ThreadContext context, IRubyObject obj, long n) {
        RubyFixnum len = RubyFixnum.newFixnum(context.runtime, n);
        IRubyObject v = obj.callMethod(context, "bytes", len);
        TypeConverter.checkStringType(context.runtime, v);
        long l = ((RubyString)v).length();
        if (l < n) {
            throw context.runtime.newRangeError("random data too short " + l);
        }
        if (l > n) {
            throw context.runtime.newRangeError("random data too long " + l);
        }
        return ((RubyString)v).getBytes();
    }

    private static RubyInteger limitedBigRand(ThreadContext context, RubyRandom.RandomType random, BigInteger limit2) {
        byte[] buf = limit2.toByteArray();
        byte[] bytes2 = new byte[buf.length];
        int len = (buf.length + 3) / 4;
        block0: while (true) {
            long mask = 0L;
            boolean boundary = true;
            for (int idx = len - 1; 0 <= idx; --idx) {
                long rnd;
                long lim = (long)RubyRandomBase.getIntBigIntegerBuffer(buf, idx) & 0xFFFFFFFFL;
                long l = mask = mask != 0L ? 0xFFFFFFFFL : RubyRandomBase.makeMask(lim);
                if (mask != 0L) {
                    rnd = (long)random.genrandInt32() & 0xFFFFFFFFL & mask;
                    if (boundary) {
                        if (lim < rnd) continue block0;
                        if (rnd < lim) {
                            boundary = false;
                        }
                    }
                } else {
                    rnd = 0L;
                }
                RubyRandomBase.setIntBigIntegerBuffer(bytes2, idx, (int)rnd);
            }
            break;
        }
        return RubyBignum.newBignum(context.runtime, new BigInteger(bytes2));
    }

    private static long makeMask(long x) {
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        x |= x >>> 32;
        return x;
    }

    static RubyRandom.RandomType getDefaultRand(ThreadContext context) {
        return context.runtime.getDefaultRandom().random;
    }

    static RubyRandom getDefaultRandom(Ruby runtime2) {
        return runtime2.getDefaultRandom();
    }

    static void checkRandomNumber(ThreadContext context, IRubyObject v, IRubyObject arg0) {
        if (v == context.fals) {
            arg0.convertToInteger();
        } else if (v == context.nil) {
            RubyRandomBase.invalidArgument(context, arg0);
        }
    }

    static void invalidArgument(ThreadContext context, IRubyObject arg0) {
        throw context.runtime.newArgumentError("invalid argument - " + arg0);
    }

    static IRubyObject randRandom(ThreadContext context, IRubyObject obj, RubyRandom.RandomType rnd) {
        return RubyFloat.newFloat(context.runtime, RubyRandomBase.randomReal(context, obj, rnd, true));
    }

    static IRubyObject randRandom(ThreadContext context, IRubyObject obj, RubyRandom.RandomType rnd, IRubyObject vmax) {
        IRubyObject v;
        if (vmax.isNil()) {
            return vmax;
        }
        if (!(vmax instanceof RubyFloat) && !(v = TypeConverter.checkToInteger(context, vmax)).isNil()) {
            return RubyRandomBase.randInt(context, obj, rnd, (RubyInteger)v, true);
        }
        Ruby runtime2 = context.runtime;
        v = TypeConverter.checkFloatType(runtime2, vmax);
        if (!v.isNil()) {
            double max2 = RubyRandomBase.floatValue(context, v);
            if (max2 < 0.0) {
                return context.nil;
            }
            double r = RubyRandomBase.randomReal(context, obj, rnd, true);
            if (max2 > 0.0) {
                r *= max2;
            }
            return RubyFloat.newFloat(runtime2, r);
        }
        return RubyRandomBase.randRange(context, obj, vmax, rnd);
    }

    private static double floatValue(ThreadContext context, IRubyObject v) {
        double value2 = v.convertToFloat().getDoubleValue();
        if (!Double.isFinite(value2)) {
            RubyRandomBase.domainError(context);
        }
        return value2;
    }

    private static void domainError(ThreadContext context) {
        throw context.runtime.newErrnoEDOMError();
    }

    private static IRubyObject randRange(ThreadContext context, IRubyObject obj, IRubyObject vmax, RubyRandom.RandomType random) {
        IRubyObject f;
        IRubyObject nil = context.nil;
        RubyBoolean fals = context.fals;
        RubyRange.RangeLike rangeLike = RubyRandomBase.rangeValues(context, vmax);
        if (rangeLike == null) {
            return fals;
        }
        vmax = rangeLike.getRange(context);
        IRubyObject v = vmax;
        if (v.isNil()) {
            RubyRandomBase.domainError(context);
        }
        Ruby runtime2 = context.runtime;
        IRubyObject beg = rangeLike.begin;
        IRubyObject end2 = rangeLike.end;
        boolean excl = rangeLike.excl;
        v = RubyRandomBase.checkMaxInt(context, vmax);
        if (v != null) {
            if (v instanceof RubyFixnum) {
                long max2 = ((RubyFixnum)v).value;
                if (excl) {
                    --max2;
                }
                v = max2 >= 0L ? RubyRandomBase.randLimitedFixnum(context, random, max2) : nil;
            } else if (v instanceof RubyBignum) {
                BigInteger big = ((RubyBignum)v).value;
                if (big.signum() > 0) {
                    if (excl) {
                        big = big.subtract(BigInteger.ONE);
                    }
                    v = RubyRandomBase.limitedBigRand(context, random, big);
                } else {
                    v = nil;
                }
            } else {
                v = nil;
            }
        } else {
            v = TypeConverter.checkFloatType(runtime2, vmax);
            if (v != nil) {
                int scale2 = 1;
                double max3 = ((RubyFloat)v).value;
                double mid = 0.5;
                if (Double.isInfinite(max3)) {
                    double min2 = RubyRandomBase.floatValue(context, TypeConverter.toFloat(runtime2, beg)) / 2.0;
                    max3 = RubyRandomBase.floatValue(context, TypeConverter.toFloat(runtime2, end2)) / 2.0;
                    scale2 = 2;
                    mid = max3 + min2;
                    max3 -= min2;
                } else {
                    RubyRandomBase.checkFloatValue(context, max3);
                }
                v = nil;
                if (max3 > 0.0) {
                    double r;
                    if (random == null) {
                        byte[] bytes2 = RubyRandomBase.objRandomBytes(context, obj, 8L);
                        ByteBuffer buffer = ByteBuffer.wrap(bytes2);
                        int a = buffer.getInt();
                        int b2 = buffer.getInt();
                        r = excl ? Random.intPairToRealExclusive(a, b2) : Random.intPairToRealInclusive(a, b2);
                    } else {
                        r = random.genrandReal(excl);
                    }
                    if (scale2 > 1) {
                        return runtime2.newFloat((r - 0.5) * max3 * (double)scale2 + mid);
                    }
                    v = runtime2.newFloat(r * max3);
                } else if (max3 == 0.0 && !excl) {
                    v = runtime2.newFloat(0.0);
                }
            }
        }
        if (beg instanceof RubyFixnum && v instanceof RubyFixnum) {
            long x = RubyNumeric.fix2long(beg) + RubyNumeric.fix2long(v);
            return RubyFixnum.newFixnum(runtime2, x);
        }
        if (v == nil) {
            return v;
        }
        if (v instanceof RubyBignum) {
            return ((RubyBignum)v).op_plus(context, beg);
        }
        if (v instanceof RubyFloat && !(f = TypeConverter.checkFloatType(runtime2, beg)).isNil()) {
            return RubyFloat.newFloat(runtime2, ((RubyFloat)v).getValue() + ((RubyFloat)f).getValue());
        }
        return Helpers.invoke(context, beg, "+", v);
    }

    private static double floatValue(ThreadContext context, RubyFloat v) {
        double x = v.value;
        RubyRandomBase.checkFloatValue(context, x);
        return x;
    }

    private static void checkFloatValue(ThreadContext context, double x) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            RubyRandomBase.domainError(context);
        }
    }

    private static IRubyObject checkMaxInt(ThreadContext context, IRubyObject vmax) {
        IRubyObject v;
        if (!(vmax instanceof RubyFloat) && (v = TypeConverter.checkToInteger(context, vmax)) != context.nil) {
            return v;
        }
        return null;
    }

    static RubyRange.RangeLike rangeValues(ThreadContext context, IRubyObject range) {
        RubyRange.RangeLike like = RubyRange.rangeValues(context, range);
        if (like == null) {
            return null;
        }
        if (like.begin.isNil() || like.end.isNil()) {
            RubyRandomBase.domainError(context);
        }
        return like;
    }

    @JRubyMethod(name={"bytes"})
    public IRubyObject bytes(ThreadContext context, IRubyObject arg2) {
        return RubyRandomBase.bytesCommon(context, this.random, arg2);
    }

    protected static IRubyObject bytesCommon(ThreadContext context, RubyRandom.RandomType random, IRubyObject arg2) {
        int n = RubyNumeric.num2int(arg2);
        byte[] bytes2 = RubyRandomBase.getBytes(random, n);
        return context.runtime.newString(new ByteList(bytes2));
    }

    static byte[] getBytes(RubyRandom.RandomType random, int n) {
        int i2;
        int r;
        byte[] bytes2 = new byte[n];
        int idx = 0;
        while (n >= 4) {
            r = random.genrandInt32();
            for (i2 = 0; i2 < 4; ++i2) {
                bytes2[idx++] = (byte)(r & 0xFF);
                r >>>= 8;
            }
            n -= 4;
        }
        if (n > 0) {
            r = random.genrandInt32();
            for (i2 = 0; i2 < n; ++i2) {
                bytes2[idx++] = (byte)(r & 0xFF);
                r >>>= 8;
            }
        }
        return bytes2;
    }

    static RubyRandom.RandomType tryGetRandomType(ThreadContext context, IRubyObject obj) {
        if (obj.equals(context.runtime.getRandomClass())) {
            return RubyRandomBase.getDefaultRand(context);
        }
        if (obj instanceof RubyRandom) {
            return ((RubyRandom)obj).random;
        }
        return null;
    }

    public static long randomLongLimited(ThreadContext context, IRubyObject obj, long limit2) {
        RubyRandom.RandomType rnd = RubyRandomBase.tryGetRandomType(context, obj);
        if (rnd == null) {
            RubyInteger v = Helpers.invokePublic(context, obj, "rand", context.runtime.newFixnum(limit2 + 1L)).convertToInteger();
            long r = RubyNumeric.num2long(v);
            if (r < 0L) {
                throw context.runtime.newRangeError("random number too small " + r);
            }
            if (r > limit2) {
                throw context.runtime.newRangeError("random number too big " + r);
            }
            return r;
        }
        return RubyRandomBase.randLimitedFixnumInner(rnd.impl, limit2);
    }

    public static double randomReal(ThreadContext context, IRubyObject obj, boolean excl) {
        RubyRandom.RandomType random = RubyRandomBase.tryGetRandomType(context, obj);
        return RubyRandomBase.randomReal(context, obj, random, excl);
    }

    private static double randomReal(ThreadContext context, IRubyObject obj, RubyRandom.RandomType random, boolean excl) {
        if (random == null) {
            random = RubyRandomBase.getDefaultRand(context);
        }
        return random.genrandReal(excl);
    }
}

