// Copyright 2012 Google Inc. All Rights Reserved.

package com.google.appengine.spi;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specifies the precedence that {@link ServiceFactoryFactory} gives to the annotated {@link
 * FactoryProvider}.
 *
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface ServiceProvider {

  public static final int DEFAULT_PRECEDENCE = 0;

  /**
   * Returns the interface implemented by this ServiceProvider. This is present for compatibility
   * reasons but should always be {@link FactoryProvider}, which is the default.
   */
  Class<?> value() default FactoryProvider.class;

  /** Higher precedence will take priority over lower precedences for a given interface. */
  int precedence() default DEFAULT_PRECEDENCE;
}
