/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_WriteStream;
import com.google.cloud.datastore.core.rep.WriteResult;
import com.google.cloud.datastore.core.rep.WriteStreamRef;
import java.util.Map;
import java.util.Set;

@AutoValue
public abstract class WriteStream {
    public abstract WriteStreamRef ref();

    public abstract long createdVersion();

    public abstract ImmutableMap<Long, WriteResult> writeResults();

    public abstract ImmutableSet<Long> resumeVersions();

    public static WriteStream create(WriteStreamRef ref, long createdVersion, Map<Long, WriteResult> resultMap, Set<Long> resumeVersions) {
        return new AutoValue_WriteStream(ref, createdVersion, (ImmutableMap<Long, WriteResult>)ImmutableMap.copyOf(resultMap), (ImmutableSet<Long>)ImmutableSet.copyOf(resumeVersions));
    }

    public boolean hasVersion(long version) {
        return this.ref().version() == version || this.writeResults().containsKey((Object)version) || this.resumeVersions().contains((Object)version);
    }

    public WriteStream acknowledge(long ackVersion) {
        ImmutableMap.Builder unackResults = ImmutableMap.builder();
        for (Map.Entry result : this.writeResults().entrySet()) {
            if ((Long)result.getKey() < ackVersion) continue;
            unackResults.put(result);
        }
        ImmutableSet.Builder unackResumeVersions = ImmutableSet.builder();
        for (Long resumeVersion : this.resumeVersions()) {
            if (resumeVersion < ackVersion) continue;
            unackResumeVersions.add((Object)resumeVersion);
        }
        return WriteStream.create(this.ref(), this.createdVersion(), (Map<Long, WriteResult>)unackResults.build(), (Set<Long>)unackResumeVersions.build());
    }

    public WriteStream add(WriteResult writeResult) {
        ImmutableMap.Builder writeResultsBuilder = ImmutableMap.builder();
        writeResultsBuilder.putAll(this.writeResults());
        writeResultsBuilder.put((Object)this.ref().version(), (Object)writeResult);
        return WriteStream.create(this.ref(), this.createdVersion(), (Map<Long, WriteResult>)writeResultsBuilder.build(), this.resumeVersions());
    }

    public WriteStream markResume() {
        ImmutableSet.Builder resumeVersionsBuilder = ImmutableSet.builder();
        resumeVersionsBuilder.addAll(this.resumeVersions());
        resumeVersionsBuilder.add((Object)this.ref().version());
        return WriteStream.create(this.ref(), this.createdVersion(), this.writeResults(), (Set<Long>)resumeVersionsBuilder.build());
    }

    public WriteStream atVersion(long version) {
        return WriteStream.create(this.ref().atVersion(version), this.createdVersion(), this.writeResults(), this.resumeVersions());
    }
}

