/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.apphosting.api.DatastorePb;
import com.google.auto.value.AutoOneOf;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.AutoOneOf_NeedIndexException_MissingIndex;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.SingleFieldIndex;
import java.util.Collection;

public class NeedIndexException
extends DatastoreException {
    private final ImmutableSet<MissingIndex> missingIndexes;

    public NeedIndexException(String message, Collection<MissingIndex> missingIndexes) {
        super(message, DatastorePb.Error.ErrorCode.NEED_INDEX, null);
        this.missingIndexes = ImmutableSet.copyOf(missingIndexes);
    }

    public ImmutableSet<MissingIndex> missingIndexes() {
        return this.missingIndexes;
    }

    public static NeedIndexException unknown(String message) {
        return new NeedIndexException(message, (Collection<MissingIndex>)ImmutableSet.of());
    }

    public static NeedIndexException recommend(String message, IndexDef indexDef) {
        return new NeedIndexException(message, (Collection<MissingIndex>)ImmutableSet.of((Object)MissingIndex.of(indexDef)));
    }

    public static NeedIndexException nonServing(String message, Index index) {
        return new NeedIndexException(message, (Collection<MissingIndex>)ImmutableSet.of((Object)MissingIndex.of(index)));
    }

    public boolean sameMissingIndexes(NeedIndexException other) {
        return this.missingIndexes.equals(other.missingIndexes);
    }

    @AutoOneOf(value=Reason.class)
    public static abstract class MissingIndex {
        public abstract Reason reason();

        public boolean compositeIndex() {
            return this.reason() == Reason.NON_SERVING_COMPOSITE || this.reason() == Reason.NON_EXISTENT_COMPOSITE;
        }

        public abstract IndexDef nonExistentComposite();

        public abstract SingleFieldIndex.Def nonExistentSfi();

        public abstract Index nonServingComposite();

        public abstract SingleFieldIndex nonServingSfi();

        public static MissingIndex of(IndexDef indexDef) {
            return AutoOneOf_NeedIndexException_MissingIndex.nonExistentComposite(indexDef);
        }

        public static MissingIndex of(SingleFieldIndex.Def indexDef) {
            return AutoOneOf_NeedIndexException_MissingIndex.nonExistentSfi(indexDef);
        }

        public static MissingIndex of(Index index) {
            return AutoOneOf_NeedIndexException_MissingIndex.nonServingComposite(index);
        }

        public static MissingIndex of(SingleFieldIndex index) {
            return AutoOneOf_NeedIndexException_MissingIndex.nonServingSfi(index);
        }

        public static enum Reason {
            NON_EXISTENT_COMPOSITE,
            NON_EXISTENT_SFI,
            NON_SERVING_COMPOSITE,
            NON_SERVING_SFI;


            public boolean nonExistent() {
                return this == NON_EXISTENT_COMPOSITE || this == NON_EXISTENT_SFI;
            }

            public boolean nonServing() {
                return this == NON_SERVING_COMPOSITE || this == NON_SERVING_SFI;
            }
        }
    }
}

