/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.IndexRef;
import com.google.cloud.datastore.core.rep.IndexState;
import com.google.cloud.datastore.core.rep.IndexUpdate;
import javax.annotation.Nullable;

final class AutoValue_IndexUpdate
extends IndexUpdate {
    private final IndexRef indexRef;
    private final IndexState newState;
    private final IndexState expectedState;

    private AutoValue_IndexUpdate(IndexRef indexRef, IndexState newState, @Nullable IndexState expectedState) {
        this.indexRef = indexRef;
        this.newState = newState;
        this.expectedState = expectedState;
    }

    @Override
    public IndexRef indexRef() {
        return this.indexRef;
    }

    @Override
    public IndexState newState() {
        return this.newState;
    }

    @Override
    @Nullable
    public IndexState expectedState() {
        return this.expectedState;
    }

    public String toString() {
        String string = String.valueOf(this.indexRef);
        String string2 = String.valueOf(this.newState);
        String string3 = String.valueOf(this.expectedState);
        return new StringBuilder(49 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("IndexUpdate{indexRef=").append(string).append(", newState=").append(string2).append(", expectedState=").append(string3).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexUpdate) {
            IndexUpdate that = (IndexUpdate)o;
            return this.indexRef.equals(that.indexRef()) && this.newState.equals(that.newState()) && (this.expectedState == null ? that.expectedState() == null : this.expectedState.equals(that.expectedState()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.indexRef.hashCode();
        h$ *= 1000003;
        h$ ^= this.newState.hashCode();
        h$ *= 1000003;
        return h$ ^= this.expectedState == null ? 0 : this.expectedState.hashCode();
    }

    static final class Builder
    extends IndexUpdate.Builder {
        private IndexRef indexRef;
        private IndexState newState;
        private IndexState expectedState;

        Builder() {
        }

        @Override
        public IndexUpdate.Builder indexRef(IndexRef indexRef) {
            if (indexRef == null) {
                throw new NullPointerException("Null indexRef");
            }
            this.indexRef = indexRef;
            return this;
        }

        @Override
        public IndexUpdate.Builder newState(IndexState newState) {
            if (newState == null) {
                throw new NullPointerException("Null newState");
            }
            this.newState = newState;
            return this;
        }

        @Override
        public IndexUpdate.Builder expectedState(@Nullable IndexState expectedState) {
            this.expectedState = expectedState;
            return this;
        }

        @Override
        public IndexUpdate build() {
            String missing = "";
            if (this.indexRef == null) {
                missing = String.valueOf(missing).concat(" indexRef");
            }
            if (this.newState == null) {
                missing = String.valueOf(missing).concat(" newState");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_IndexUpdate(this.indexRef, this.newState, this.expectedState);
        }
    }
}

