/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.api.DatastorePb;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3IndexValueFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public class AppEngV3QueryFromRepConverter {
    public static final AppEngV3QueryFromRepConverter INSTANCE = new AppEngV3QueryFromRepConverter();

    private AppEngV3QueryFromRepConverter() {
    }

    public DatastorePb.CompiledCursor convertCursor(Cursor cursor, @Nullable Direction firstSortOrder) throws InvalidConversionException {
        if (cursor.equals(Cursor.EMPTY)) {
            return DatastorePb.CompiledCursor.getDefaultInstance();
        }
        if (cursor.isRawIndex()) {
            DatastorePb.CompiledCursor apiCursor = new DatastorePb.CompiledCursor();
            OnestoreEntity.IndexPosition apiRawIndexCursor = apiCursor.getMutableAbsolutePosition();
            byte[] rawIndexKey = cursor.rawIndexKey();
            if (rawIndexKey != null) {
                apiRawIndexCursor.setKeyAsBytes(rawIndexKey);
            }
            apiRawIndexCursor.setBefore(cursor.before());
            apiRawIndexCursor.setBeforeAscending(AppEngV3QueryFromRepConverter.convertBeforeAndFirstOrderByDirectionToBeforeAscending(cursor.before(), firstSortOrder));
            return apiCursor;
        }
        if (cursor.isRegular()) {
            DatastorePb.CompiledCursor apiCursor = new DatastorePb.CompiledCursor();
            OnestoreEntity.IndexPostfix apiPostfixCursor = apiCursor.getMutablePostfixPosition();
            EntityRef key = cursor.key();
            if (key != null) {
                apiPostfixCursor.setKey(AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRef(key));
            }
            ImmutableList<PropertyPath> propertyPaths = cursor.propertyPaths();
            ImmutableList<IndexValue> indexValues = cursor.indexValues();
            for (int index = 0; index < indexValues.size(); ++index) {
                PropertyPath propertyPath = (PropertyPath)propertyPaths.get(index);
                IndexValue indexValue = (IndexValue)indexValues.get(index);
                String apiPropertyName = propertyPath.asPropertyNameWithDelimiterAmbiguity().string();
                OnestoreEntity.PropertyValue apiIndexValue = AppEngV3IndexValueFromRepConverter.INSTANCE.convertIndexValue(indexValue);
                OnestoreEntity.IndexPostfix_IndexValue apiPair = new OnestoreEntity.IndexPostfix_IndexValue().setPropertyName(apiPropertyName).setValue(apiIndexValue);
                apiPostfixCursor.addIndexValue(apiPair);
            }
            apiPostfixCursor.setBefore(cursor.before());
            apiPostfixCursor.setBeforeAscending(AppEngV3QueryFromRepConverter.convertBeforeAndFirstOrderByDirectionToBeforeAscending(cursor.before(), firstSortOrder));
            return apiCursor;
        }
        throw new AssertionError();
    }

    private static boolean convertBeforeAndFirstOrderByDirectionToBeforeAscending(boolean before, @Nullable Direction firstOrderByDirection) {
        return before ^ firstOrderByDirection == Direction.DESCENDING;
    }
}

