/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus.scostore;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.datanucleus.DatastoreManager;
import com.google.appengine.datanucleus.DatastoreServiceFactoryInternal;
import com.google.appengine.datanucleus.EntityUtils;
import com.google.appengine.datanucleus.KeyRegistry;
import com.google.appengine.datanucleus.MetaDataUtils;
import com.google.appengine.datanucleus.StorageVersion;
import com.google.appengine.datanucleus.Utils;
import com.google.appengine.datanucleus.mapping.DatastoreTable;
import com.google.appengine.datanucleus.query.LazyResult;
import com.google.appengine.datanucleus.scostore.AbstractFKStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.FetchPlan;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusFatalUserException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.scostore.ListStore;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FKListStore
extends AbstractFKStore
implements ListStore {
    protected JavaTypeMapping orderMapping;
    protected boolean indexedList = true;
    private final ThreadLocal<Boolean> removing = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public FKListStore(AbstractMemberMetaData ownerMmd, DatastoreManager storeMgr, ClassLoaderResolver clr) {
        super(ownerMmd, storeMgr, clr);
        this.orderMapping = this.elementTable.getExternalMapping(this.ownerMemberMetaData, 4);
        if (this.ownerMemberMetaData.getOrderMetaData() != null && !this.ownerMemberMetaData.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (!storeMgr.storageVersionAtLeast(StorageVersion.READ_OWNED_CHILD_KEYS_FROM_PARENTS) && this.orderMapping == null && this.indexedList) {
            throw new NucleusUserException(LOCALISER.msg("056041", (Object)this.ownerMemberMetaData.getAbstractClassMetaData().getFullClassName(), (Object)this.ownerMemberMetaData.getName(), (Object)this.elementType));
        }
    }

    public boolean hasOrderMapping() {
        return this.orderMapping != null;
    }

    public boolean add(ObjectProvider ownerOP, Object element, int currentSize) {
        return this.internalAdd(ownerOP, 0, true, Collections.singleton(element), currentSize);
    }

    public boolean addAll(ObjectProvider ownerOP, Collection elements, int currentSize) {
        return this.internalAdd(ownerOP, 0, true, elements, currentSize);
    }

    public void add(ObjectProvider ownerOP, Object element, int index, int currentSize) {
        this.internalAdd(ownerOP, index, false, Collections.singleton(element), currentSize);
    }

    public boolean addAll(ObjectProvider ownerOP, Collection elements, int index, int currentSize) {
        return this.internalAdd(ownerOP, index, false, elements, currentSize);
    }

    protected boolean internalAdd(ObjectProvider ownerOP, int startAt, boolean atEnd, Collection elements, int currentSize) {
        boolean success = false;
        if (elements == null || elements.size() == 0) {
            success = true;
        } else {
            if (!this.storeMgr.storageVersionAtLeast(StorageVersion.WRITE_OWNED_CHILD_KEYS_TO_PARENTS)) {
                int currentListSize = 0;
                currentListSize = currentSize < 0 ? this.size(ownerOP) : currentSize;
                boolean shiftingElements = true;
                if (atEnd || startAt == currentListSize) {
                    shiftingElements = false;
                    startAt = currentListSize;
                }
                if (shiftingElements) {
                    try {
                        int shift = elements.size();
                        for (int i = currentListSize - 1; i >= startAt; --i) {
                            this.internalShift(ownerOP, false, i, shift);
                        }
                    }
                    catch (MappedDatastoreException e) {
                        throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)e.getMessage()), e.getCause());
                    }
                }
            }
            boolean elementsNeedPositioning = false;
            int position = startAt;
            for (Object element : elements) {
                boolean inserted;
                if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
                    Key parentKey = EntityUtils.getKeyForObject(ownerOP.getObject(), ownerOP.getExecutionContext());
                    KeyRegistry.getKeyRegistry(ownerOP.getExecutionContext()).registerParentKeyForOwnedObject(element, parentKey);
                }
                if (!(inserted = this.validateElementForWriting(ownerOP, element, position)) && !this.storeMgr.storageVersionAtLeast(StorageVersion.WRITE_OWNED_CHILD_KEYS_TO_PARENTS)) {
                    elementsNeedPositioning = true;
                }
                ++position;
            }
            if (elementsNeedPositioning) {
                for (Object element : elements) {
                    this.updateElementFk(ownerOP, element, ownerOP.getObject(), startAt);
                    ++startAt;
                }
            }
            success = true;
        }
        return success;
    }

    protected int[] internalShift(ObjectProvider op, boolean batched, int oldIndex, int amount) throws MappedDatastoreException {
        if (this.orderMapping == null) {
            return null;
        }
        DatastoreServiceConfig config = this.storeMgr.getDefaultDatastoreServiceConfigForReads();
        DatastoreService service = DatastoreServiceFactoryInternal.getDatastoreService(config);
        AbstractClassMetaData acmd = this.elementCmd;
        String kind = this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
        Query q = new Query(kind);
        ExecutionContext ec = op.getExecutionContext();
        Object id = ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(op.getInternalObjectId());
        Key key = id instanceof Key ? (Key)id : KeyFactory.stringToKey((String)((String)id));
        q.setAncestor(key);
        Entity entity = new Entity(kind);
        this.orderMapping.setObject(ec, (Object)entity, new int[]{1}, (Object)oldIndex);
        String indexProp = (String)entity.getProperties().keySet().iterator().next();
        q.addFilter(indexProp, Query.FilterOperator.GREATER_THAN_OR_EQUAL, (Object)oldIndex);
        for (Entity shiftMe : service.prepare(service.getCurrentTransaction(null), q).asIterable()) {
            Long pos = (Long)shiftMe.getProperty(indexProp);
            shiftMe.setProperty(indexProp, (Object)(pos + (long)amount));
            EntityUtils.putEntityIntoDatastore(ec, shiftMe);
        }
        return null;
    }

    protected boolean updateElementFk(ObjectProvider op, Object element, Object owner, int index) {
        if (element == null) {
            return false;
        }
        if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
            EntityUtils.checkParentage(element, op);
        }
        return this.orderMapping != null;
    }

    protected boolean deleteElementsOnRemoveOrClear() {
        boolean deleteElements = false;
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056034"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping == null || this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056036"));
            deleteElements = false;
        } else if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056035"));
            deleteElements = true;
        }
        return deleteElements;
    }

    public void clear(ObjectProvider op) {
        boolean deleteElements = this.deleteElementsOnRemoveOrClear();
        ExecutionContext ec = op.getExecutionContext();
        Iterator elementsIter = this.iterator(op);
        if (elementsIter != null) {
            while (elementsIter.hasNext()) {
                Object element = elementsIter.next();
                if (ec.getApiAdapter().isPersistable(element) && ec.getApiAdapter().isDeleted(element)) {
                    ObjectProvider objSM = ec.findObjectProvider(element);
                    objSM.flush();
                    continue;
                }
                if (!deleteElements) continue;
                ec.deleteObjectInternal(element);
            }
        }
    }

    public Iterator iterator(ObjectProvider op) {
        return this.listIterator(op);
    }

    public ListIterator listIterator(ObjectProvider op) {
        return this.listIterator(op, -1, -1);
    }

    protected ListIterator listIterator(ObjectProvider op, int startIdx, int endIdx) {
        ExecutionContext ec = op.getExecutionContext();
        if (MetaDataUtils.readRelatedKeysFromParent(this.storeMgr, this.ownerMemberMetaData)) {
            String propName;
            Entity datastoreEntity = this.getOwnerEntity(op);
            if (datastoreEntity.hasProperty(propName = EntityUtils.getPropertyName(this.storeMgr.getIdentifierFactory(), this.ownerMemberMetaData))) {
                if (this.indexedList) {
                    return this.getChildrenFromParentField(op, ec, startIdx, endIdx).listIterator();
                }
                if (!MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
                    Object value = datastoreEntity.getProperty(propName);
                    if (value == null || value instanceof Collection && ((Collection)value).isEmpty()) {
                        return Utils.newArrayList(new Object[0]).listIterator();
                    }
                    return this.getChildrenByKeys((List)value, ec);
                }
            } else if (op.getLifecycleState().isDeleted()) {
                return Utils.newArrayList(new Object[0]).listIterator();
            }
        }
        if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
            Key parentKey = EntityUtils.getPrimaryKeyAsKey(ec.getApiAdapter(), op);
            return this.getChildrenUsingParentQuery(parentKey, this.getFilterPredicates(startIdx, endIdx), this.getSortPredicates(), ec).listIterator();
        }
        return Utils.newArrayList(new Object[0]).listIterator();
    }

    ListIterator<?> getChildrenByKeys(List<Key> childKeys, final ExecutionContext ec) {
        String kindName = this.elementTable.getIdentifier().getIdentifierName();
        Query q = new Query(kindName);
        NucleusLogger.PERSISTENCE.debug((Object)("Preparing to query for " + childKeys));
        q.addFilter("__key__", Query.FilterOperator.IN, childKeys);
        for (Query.SortPredicate sp : this.getSortPredicates()) {
            q.addSort(sp.getPropertyName(), sp.getDirection());
        }
        DatastoreServiceConfig config = this.storeMgr.getDefaultDatastoreServiceConfigForReads();
        DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
        Utils.Function<Entity, Object> func = new Utils.Function<Entity, Object>(){

            @Override
            public Object apply(Entity from) {
                return EntityUtils.entityToPojo(from, FKListStore.this.elementCmd, FKListStore.this.clr, ec, false, ec.getFetchPlan());
            }
        };
        return new LazyResult<Object>(ds.prepare(q).asIterable(), func, true).listIterator();
    }

    @Override
    public int size(ObjectProvider op) {
        if (this.storeMgr.storageVersionAtLeast(StorageVersion.READ_OWNED_CHILD_KEYS_FROM_PARENTS) && !this.indexedList) {
            if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
                return this.getSizeUsingParentKeyInChildren(op);
            }
            throw new NucleusFatalUserException("Dont currently support ordered lists that are unowned");
        }
        return super.size(op);
    }

    public boolean remove(ObjectProvider op, Object element, int currentSize, boolean allowCascadeDelete) {
        ExecutionContext ec = op.getExecutionContext();
        if (!this.validateElementForReading(ec, element)) {
            return false;
        }
        Object elementToRemove = element;
        if (ec.getApiAdapter().isDetached(element)) {
            elementToRemove = ec.findObject(ec.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        return this.internalRemove(op, elementToRemove, currentSize);
    }

    public boolean removeAll(ObjectProvider ownerOP, Collection elements, int currentSize) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        if (this.indexedList) {
            int[] indices = this.getIndicesOf(ownerOP, elements);
            for (int i = 0; i < indices.length; ++i) {
                this.removeAt(ownerOP, indices[i], -1);
                modified = true;
            }
        } else {
            for (Object element : elements) {
                boolean mod = this.internalRemove(ownerOP, element, -1);
                if (!mod) continue;
                modified = true;
            }
        }
        return modified;
    }

    public Object remove(ObjectProvider ownerOP, int index, int currentSize) {
        Object element = this.get(ownerOP, index);
        if (this.indexedList) {
            this.removeAt(ownerOP, index, currentSize);
        } else {
            this.internalRemove(ownerOP, element, currentSize);
        }
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent && !this.ownerMemberMetaData.getCollection().isEmbeddedElement() && !this.contains(ownerOP, element)) {
            ownerOP.getExecutionContext().deleteObjectInternal(element);
        }
        return element;
    }

    protected boolean internalRemove(ObjectProvider ownerOP, Object element, int size) {
        if (this.indexedList) {
            int index = this.indexOf(ownerOP, element);
            if (index == -1) {
                return false;
            }
            this.removeAt(ownerOP, index, size);
        } else {
            ExecutionContext ec = ownerOP.getExecutionContext();
            if (this.ownerMapping.isNullable()) {
                ObjectProvider elementSM = ec.findObjectProvider(element);
                if (this.relationType == 4) {
                    elementSM.replaceFieldMakeDirty(this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr)[0].getAbsoluteFieldNumber(), null);
                    if (ec.isFlushing()) {
                        elementSM.flush();
                    }
                } else {
                    this.updateElementFk(ownerOP, element, null, -1);
                }
            } else {
                ec.deleteObjectInternal(element);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAt(ObjectProvider ownerOP, int index, int size) {
        if (!this.indexedList) {
            throw new NucleusUserException("Cannot remove an element from a particular position with an ordered list since no indexes exist");
        }
        if (this.removing.get().booleanValue()) {
            return;
        }
        boolean deleteElement = this.deleteElementsOnRemoveOrClear();
        ExecutionContext ec = ownerOP.getExecutionContext();
        Object element = this.get(ownerOP, index);
        try {
            this.removing.set(true);
            if (!deleteElement) {
                ObjectProvider elementOP = ec.findObjectProvider(element);
                if (elementOP != null && !ec.getApiAdapter().isDeleted(element)) {
                    Entity elementEntity = this.getOwnerEntity(elementOP);
                    if (!this.storeMgr.storageVersionAtLeast(StorageVersion.READ_OWNED_CHILD_KEYS_FROM_PARENTS)) {
                        elementEntity.removeProperty(this.getIndexPropertyName());
                    }
                    EntityUtils.putEntityIntoDatastore(ec, elementEntity);
                }
            } else {
                ec.deleteObjectInternal(element);
            }
        }
        finally {
            this.removing.set(false);
        }
        if (this.orderMapping != null) {
            DatastoreServiceConfig config = this.storeMgr.getDefaultDatastoreServiceConfigForReads();
            DatastoreService service = DatastoreServiceFactoryInternal.getDatastoreService(config);
            AbstractClassMetaData acmd = this.elementCmd;
            String kind = this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(acmd).getIdentifierName();
            Query q = new Query(kind);
            Key key = EntityUtils.getPrimaryKeyAsKey(ec.getApiAdapter(), ownerOP);
            q.setAncestor(key);
            Entity entity = new Entity(kind);
            this.orderMapping.setObject(ec, (Object)entity, new int[]{1}, (Object)index);
            String indexProp = (String)entity.getProperties().keySet().iterator().next();
            q.addFilter(indexProp, Query.FilterOperator.GREATER_THAN, (Object)index);
            for (Entity shiftMe : service.prepare(service.getCurrentTransaction(null), q).asIterable()) {
                Long pos = (Long)shiftMe.getProperty(indexProp);
                shiftMe.setProperty(indexProp, (Object)(pos - 1L));
                EntityUtils.putEntityIntoDatastore(ec, shiftMe);
            }
        }
    }

    public void update(ObjectProvider ownerOP, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(ownerOP);
            return;
        }
        ArrayList existing = new ArrayList();
        Iterator elemIter = this.iterator(ownerOP);
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(ownerOP, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.equals(coll)) {
            return;
        }
        this.clear(ownerOP);
        this.addAll(ownerOP, coll, 0);
    }

    public Object get(ObjectProvider op, int index) {
        if (MetaDataUtils.readRelatedKeysFromParent(this.storeMgr, this.ownerMemberMetaData)) {
            String propName;
            ExecutionContext ec = op.getExecutionContext();
            Entity datastoreEntity = this.getOwnerEntity(op);
            if (datastoreEntity.hasProperty(propName = EntityUtils.getPropertyName(this.storeMgr.getIdentifierFactory(), this.ownerMemberMetaData))) {
                Object value = datastoreEntity.getProperty(propName);
                if (value == null) {
                    return null;
                }
                List keys = (List)value;
                Key indexKey = (Key)keys.get(index);
                DatastoreServiceConfig config = this.storeMgr.getDefaultDatastoreServiceConfigForReads();
                DatastoreService ds = DatastoreServiceFactoryInternal.getDatastoreService(config);
                try {
                    return EntityUtils.entityToPojo(ds.get(indexKey), this.elementCmd, this.clr, ec, false, ec.getFetchPlan());
                }
                catch (EntityNotFoundException enfe) {
                    throw new NucleusDataStoreException("Could not determine entity for index=" + index + " with key=" + indexKey, (Throwable)enfe);
                }
            }
        } else {
            ListIterator iter = this.listIterator(op, index, index);
            if (iter == null || !iter.hasNext()) {
                return null;
            }
            if (!this.indexedList) {
                Object obj = null;
                int position = 0;
                while (iter.hasNext()) {
                    obj = iter.next();
                    if (position == index) {
                        return obj;
                    }
                    ++position;
                }
            }
            return iter.next();
        }
        return null;
    }

    protected int[] getIndicesOf(ObjectProvider op, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        ExecutionContext ec = op.getExecutionContext();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            this.validateElementForReading(ec, iter.next());
        }
        if (elements.isEmpty()) {
            return new int[0];
        }
        if (MetaDataUtils.readRelatedKeysFromParent(this.storeMgr, this.ownerMemberMetaData)) {
            String propName = EntityUtils.getPropertyName(this.storeMgr.getIdentifierFactory(), this.ownerMemberMetaData);
            Entity ownerEntity = this.getOwnerEntity(op);
            if (ownerEntity.hasProperty(propName)) {
                Object value = ownerEntity.getProperty(propName);
                if (value == null) {
                    return new int[0];
                }
                List keys = (List)value;
                HashSet<Object> elementKeys = Utils.newHashSet(new Object[0]);
                for (Object element : elements) {
                    Key key = EntityUtils.getKeyForObject(element, ec);
                    if (key == null) continue;
                    elementKeys.add(key);
                }
                int i = 0;
                ArrayList<Integer> indicesList = new ArrayList<Integer>();
                for (Key key : keys) {
                    if (elementKeys.contains(key)) {
                        indicesList.add(i);
                    }
                    ++i;
                }
                int[] indices = new int[indicesList.size()];
                i = 0;
                for (Integer index : indicesList) {
                    indices[i++] = index;
                }
                return indices;
            }
        } else {
            ArrayList<Object> keys = Utils.newArrayList(new Object[0]);
            HashSet<Object> keySet = Utils.newHashSet(new Object[0]);
            for (Object ele : elements) {
                Key key;
                ApiAdapter apiAdapter = ec.getApiAdapter();
                Object keyOrString = apiAdapter.getTargetKeyForSingleFieldIdentity(apiAdapter.getIdForObject(ele));
                Key key2 = key = keyOrString instanceof Key ? (Key)keyOrString : KeyFactory.stringToKey((String)((String)keyOrString));
                if (key == null) {
                    throw new NucleusUserException("Collection element does not have a primary key.");
                }
                if (key.getParent() == null) {
                    throw new NucleusUserException("Collection element primary key does not have a parent.");
                }
                keys.add(key);
                keySet.add(key);
            }
            Collections.sort(keys);
            AbstractClassMetaData emd = this.elementCmd;
            String kind = this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(emd).getIdentifierName();
            Query q = new Query(kind);
            q.setAncestor(((Key)keys.get(0)).getParent());
            q.addFilter("__key__", Query.FilterOperator.GREATER_THAN_OR_EQUAL, keys.get(0));
            q.addFilter("__key__", Query.FilterOperator.LESS_THAN_OR_EQUAL, keys.get(keys.size() - 1));
            q.addSort("__key__", Query.SortDirection.DESCENDING);
            DatastoreServiceConfig config = this.storeMgr.getDefaultDatastoreServiceConfigForReads();
            DatastoreService service = DatastoreServiceFactoryInternal.getDatastoreService(config);
            int[] indices = new int[keys.size()];
            int index = 0;
            for (Entity e : service.prepare(service.getCurrentTransaction(null), q).asIterable()) {
                if (!keySet.contains(e.getKey())) continue;
                Long indexVal = (Long)this.orderMapping.getObject(ec, (Object)e, new int[1]);
                if (indexVal == null) {
                    throw new NucleusDataStoreException("Null index value");
                }
                indices[index++] = indexVal.intValue();
            }
            if (index != indices.length) {
                throw new NucleusDataStoreException("Too few keys returned.");
            }
            return indices;
        }
        return new int[0];
    }

    public int indexOf(ObjectProvider op, Object element) {
        ExecutionContext ec = op.getExecutionContext();
        this.validateElementForReading(ec, element);
        ObjectProvider elementOP = ec.findObjectProvider(element);
        Key elementKey = EntityUtils.getPrimaryKeyAsKey(ec.getApiAdapter(), elementOP);
        if (elementKey == null) {
            return -1;
        }
        if (MetaDataUtils.readRelatedKeysFromParent(this.storeMgr, this.ownerMemberMetaData)) {
            String propName = EntityUtils.getPropertyName(this.storeMgr.getIdentifierFactory(), this.ownerMemberMetaData);
            Entity ownerEntity = this.getOwnerEntity(op);
            if (ownerEntity.hasProperty(propName)) {
                Object value = ownerEntity.getProperty(propName);
                if (value == null) {
                    return -1;
                }
                List keys = (List)value;
                return keys.indexOf(elementKey);
            }
        } else {
            if (elementKey.getParent() == null) {
                throw new NucleusUserException("Element primary-key does not have a parent.");
            }
            DatastoreServiceConfig config = this.storeMgr.getDefaultDatastoreServiceConfigForReads();
            DatastoreService service = DatastoreServiceFactoryInternal.getDatastoreService(config);
            try {
                Entity e = service.get(elementKey);
                Long indexVal = (Long)this.orderMapping.getObject(ec, (Object)e, new int[1]);
                if (indexVal == null) {
                    throw new NucleusDataStoreException("Null index value");
                }
                return indexVal.intValue();
            }
            catch (EntityNotFoundException enfe) {
                throw new NucleusDataStoreException("Could not determine index of entity.", (Throwable)enfe);
            }
        }
        return -1;
    }

    public int lastIndexOf(ObjectProvider op, Object element) {
        ExecutionContext ec = op.getExecutionContext();
        this.validateElementForReading(ec, element);
        ObjectProvider elementOP = ec.findObjectProvider(element);
        Key elementKey = EntityUtils.getPrimaryKeyAsKey(ec.getApiAdapter(), elementOP);
        if (elementKey == null) {
            return -1;
        }
        if (MetaDataUtils.readRelatedKeysFromParent(this.storeMgr, this.ownerMemberMetaData)) {
            String propName = EntityUtils.getPropertyName(this.storeMgr.getIdentifierFactory(), this.ownerMemberMetaData);
            Entity ownerEntity = this.getOwnerEntity(op);
            if (ownerEntity.hasProperty(propName)) {
                Object value = ownerEntity.getProperty(propName);
                if (value == null) {
                    return -1;
                }
                List keys = (List)value;
                return keys.lastIndexOf(elementKey);
            }
        }
        return this.indexOf(op, element);
    }

    public Object set(ObjectProvider op, int index, Object element, boolean allowCascadeDelete) {
        Object obj = this.get(op, index);
        if (MetaDataUtils.isOwnedRelation(this.ownerMemberMetaData, this.storeMgr)) {
            Key parentKey = EntityUtils.getKeyForObject(op.getObject(), op.getExecutionContext());
            KeyRegistry.getKeyRegistry(op.getExecutionContext()).registerParentKeyForOwnedObject(element, parentKey);
        }
        this.validateElementForWriting(op, element, index);
        if (this.ownerMemberMetaData.getCollection().isDependentElement() && allowCascadeDelete && obj != null) {
            op.getExecutionContext().deleteObjectInternal(obj);
        }
        return obj;
    }

    public List subList(ObjectProvider op, int startIdx, int endIdx) {
        ListIterator iter = this.listIterator(op, startIdx, endIdx);
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        if (!this.indexedList && list.size() > endIdx - startIdx) {
            return list.subList(startIdx, endIdx);
        }
        return list;
    }

    private List<Query.FilterPredicate> getFilterPredicates(int startIdx, int endIdx) {
        ArrayList<Object> filterPredicates = Utils.newArrayList(new Object[0]);
        if (this.indexedList) {
            String indexProperty = this.getIndexPropertyName();
            if (startIdx >= 0 && endIdx == startIdx) {
                Query.FilterPredicate filterPred = new Query.FilterPredicate(indexProperty, Query.FilterOperator.EQUAL, (Object)startIdx);
                filterPredicates.add(filterPred);
            } else if (startIdx != -1 || endIdx != -1) {
                Query.FilterPredicate filterPred;
                if (startIdx >= 0) {
                    filterPred = new Query.FilterPredicate(indexProperty, Query.FilterOperator.GREATER_THAN_OR_EQUAL, (Object)startIdx);
                    filterPredicates.add(filterPred);
                }
                if (endIdx >= 0) {
                    filterPred = new Query.FilterPredicate(indexProperty, Query.FilterOperator.LESS_THAN, (Object)endIdx);
                    filterPredicates.add(filterPred);
                }
            }
        }
        return filterPredicates;
    }

    private String getIndexPropertyName() {
        String propertyName;
        if (this.orderMapping.getMemberMetaData() == null) {
            propertyName = this.orderMapping.getDatastoreMappings()[0].getDatastoreField().getIdentifier().getIdentifierName();
        } else {
            propertyName = this.orderMapping.getMemberMetaData().getName();
            AbstractMemberMetaData ammd = this.orderMapping.getMemberMetaData();
            if (ammd.getColumn() != null) {
                propertyName = ammd.getColumn();
            } else if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length == 1) {
                propertyName = ammd.getColumnMetaData()[0].getName();
            }
        }
        return propertyName;
    }

    private List<Query.SortPredicate> getSortPredicates() {
        ArrayList<Object> sortPredicates = Utils.newArrayList(new Object[0]);
        if (this.indexedList) {
            String propertyName = this.getIndexPropertyName();
            Query.SortPredicate sortPredicate = new Query.SortPredicate(propertyName, Query.SortDirection.ASCENDING);
            sortPredicates.add(sortPredicate);
        } else {
            for (OrderMetaData.FieldOrder fieldOrder : this.ownerMemberMetaData.getOrderMetaData().getFieldOrders()) {
                AbstractMemberMetaData orderMmd = this.elementCmd.getMetaDataForMember(fieldOrder.getFieldName());
                String orderPropName = EntityUtils.getPropertyName(this.storeMgr.getIdentifierFactory(), orderMmd);
                boolean isPrimaryKey = orderMmd.isPrimaryKey();
                if (isPrimaryKey) {
                    if (fieldOrder.isForward() && sortPredicates.isEmpty()) break;
                    orderPropName = "__key__";
                }
                Query.SortPredicate sortPredicate = new Query.SortPredicate(orderPropName, fieldOrder.isForward() ? Query.SortDirection.ASCENDING : Query.SortDirection.DESCENDING);
                sortPredicates.add(sortPredicate);
                if (isPrimaryKey) break;
            }
        }
        return sortPredicates;
    }

    boolean isPrimaryKey(String propertyName) {
        return this.elementCmd.getMetaDataForMember(propertyName).isPrimaryKey();
    }

    protected boolean validateElementForWriting(final ObjectProvider op, Object element, final int index) {
        final Object newOwner = op.getObject();
        boolean inserted = super.validateElementForWriting(op.getExecutionContext(), element, new FieldValues(){

            public void fetchFields(ObjectProvider elementOP) {
                AbstractClassMetaData[] managingCmds;
                boolean isPersistentInterface = FKListStore.this.storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(FKListStore.this.elementType);
                DatastoreTable elementTable = null;
                elementTable = isPersistentInterface ? FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.storeMgr.getNucleusContext().getMetaDataManager().getImplementationNameForPersistentInterface(FKListStore.this.elementType), FKListStore.this.clr) : FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.elementType, FKListStore.this.clr);
                if (elementTable == null && (managingCmds = FKListStore.this.storeMgr.getClassesManagingTableForClass(FKListStore.this.elementCmd, FKListStore.this.clr)) != null && managingCmds.length > 0) {
                    for (int i = 0; i < managingCmds.length; ++i) {
                        Class tblCls = FKListStore.this.clr.classForName(managingCmds[i].getFullClassName());
                        if (!tblCls.isAssignableFrom(elementOP.getObject().getClass())) continue;
                        elementTable = FKListStore.this.storeMgr.getDatastoreClass(managingCmds[i].getFullClassName(), FKListStore.this.clr);
                        break;
                    }
                }
                if (elementTable != null) {
                    JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(FKListStore.this.ownerMemberMetaData, 5);
                    if (externalFKMapping != null) {
                        elementOP.setAssociatedValue((Object)externalFKMapping, op.getObject());
                    }
                    if (FKListStore.this.orderMapping != null && index >= 0) {
                        if (FKListStore.this.ownerMemberMetaData.getOrderMetaData() != null && FKListStore.this.ownerMemberMetaData.getOrderMetaData().getMappedBy() != null) {
                            Number indexValue = null;
                            indexValue = FKListStore.this.orderMapping.getMemberMetaData().getTypeName().equals(ClassNameConstants.JAVA_LANG_LONG) || FKListStore.this.orderMapping.getMemberMetaData().getTypeName().equals(ClassNameConstants.LONG) ? (Number)Long.valueOf(index) : (Number)index;
                            elementOP.replaceFieldMakeDirty(FKListStore.this.orderMapping.getMemberMetaData().getAbsoluteFieldNumber(), (Object)indexValue);
                        } else {
                            elementOP.setAssociatedValue((Object)FKListStore.this.orderMapping, (Object)index);
                        }
                    }
                }
                if (FKListStore.this.relationType == 4) {
                    Object currentOwner = elementOP.provideField(FKListStore.this.elementMemberMetaData.getAbsoluteFieldNumber());
                    if (currentOwner == null) {
                        NucleusLogger.PERSISTENCE.info((Object)AbstractFKStore.LOCALISER.msg("056037", (Object)op.toPrintableID(), (Object)FKListStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementOP.getObject())));
                        elementOP.replaceFieldMakeDirty(FKListStore.this.elementMemberMetaData.getAbsoluteFieldNumber(), newOwner);
                    } else if (currentOwner != newOwner && op.getReferencedPC() == null) {
                        throw new NucleusUserException(AbstractFKStore.LOCALISER.msg("056038", (Object)op.toPrintableID(), (Object)FKListStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementOP.getObject()), (Object)StringUtils.toJVMIDString((Object)currentOwner)));
                    }
                }
            }

            public void fetchNonLoadedFields(ObjectProvider elementOP) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        });
        return inserted;
    }
}

