/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags.ext;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;

public final class FlagConstraints {
    public static <T> Predicate<? extends Iterable<? extends T>> all(final Predicate<? super T> constraint) {
        if (Preconditions.checkNotNull(constraint) == Predicates.alwaysTrue()) {
            return Predicates.alwaysTrue();
        }
        if (constraint == Predicates.alwaysFalse()) {
            Predicate narrowedPredicate = IterablePredicate.IS_EMPTY.withNarrowedType();
            return narrowedPredicate;
        }
        return new Predicate<Iterable<? extends T>>(){

            @Override
            public boolean apply(Iterable<? extends T> iterable) {
                return Iterables.all(iterable, constraint);
            }
        };
    }

    public static <T> Predicate<? extends Iterable<? extends T>> any(final Predicate<? super T> constraint) {
        if (Preconditions.checkNotNull(constraint) == Predicates.alwaysFalse()) {
            return Predicates.alwaysFalse();
        }
        if (constraint == Predicates.alwaysTrue()) {
            Predicate narrowedPredicate = IterablePredicate.IS_NOT_EMPTY.withNarrowedType();
            return narrowedPredicate;
        }
        return new Predicate<Iterable<? extends T>>(){

            @Override
            public boolean apply(Iterable<? extends T> iterable) {
                return Iterables.any(iterable, constraint);
            }
        };
    }

    private FlagConstraints() {
    }

    static enum IterablePredicate implements Predicate<Iterable<?>>
    {
        IS_EMPTY{

            @Override
            public boolean apply(Iterable<?> iterable) {
                return Iterables.isEmpty(iterable);
            }
        }
        ,
        IS_NOT_EMPTY{

            @Override
            public boolean apply(Iterable<?> iterable) {
                return !Iterables.isEmpty(iterable);
            }
        };


        <T> Predicate<Iterable<T>> withNarrowedType() {
            return this;
        }
    }
}

