/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.BaseDatastoreService;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.labs.datastore.overlay.DelegatedBaseDatastoreService;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class SyncDatastoreServiceAdapter
extends DelegatedBaseDatastoreService
implements DatastoreService {
    final AsyncDatastoreService datastore;

    public SyncDatastoreServiceAdapter(AsyncDatastoreService datastore) {
        super((BaseDatastoreService)datastore);
        this.datastore = Preconditions.checkNotNull(datastore);
    }

    public Entity get(Key key) throws EntityNotFoundException {
        return (Entity)this.getAndConvertExceptionsExceptEntityNotFound(this.datastore.get(key));
    }

    public Entity get(Transaction txn, Key key) throws EntityNotFoundException {
        return (Entity)this.getAndConvertExceptionsExceptEntityNotFound(this.datastore.get(txn, key));
    }

    public Map<Key, Entity> get(Iterable<Key> keys) {
        return (Map)this.getAndConvertExceptions(this.datastore.get(keys));
    }

    public Map<Key, Entity> get(Transaction txn, Iterable<Key> keys) {
        return (Map)this.getAndConvertExceptions(this.datastore.get(txn, keys));
    }

    public Key put(Entity entity) {
        return (Key)this.getAndConvertExceptions(this.datastore.put(entity));
    }

    public Key put(Transaction txn, Entity entity) {
        return (Key)this.getAndConvertExceptions(this.datastore.put(txn, entity));
    }

    public List<Key> put(Iterable<Entity> entities) {
        return (List)this.getAndConvertExceptions(this.datastore.put(entities));
    }

    public List<Key> put(Transaction txn, Iterable<Entity> entities) {
        return (List)this.getAndConvertExceptions(this.datastore.put(txn, entities));
    }

    public void delete(Key ... keys) {
        this.getAndConvertExceptions(this.datastore.delete(keys));
    }

    public void delete(Transaction txn, Key ... keys) {
        this.getAndConvertExceptions(this.datastore.delete(txn, keys));
    }

    public void delete(Iterable<Key> keys) {
        this.getAndConvertExceptions(this.datastore.delete(keys));
    }

    public void delete(Transaction txn, Iterable<Key> keys) {
        this.getAndConvertExceptions(this.datastore.delete(txn, keys));
    }

    public Transaction beginTransaction() {
        return (Transaction)this.getAndConvertExceptions(this.datastore.beginTransaction());
    }

    public Transaction beginTransaction(TransactionOptions options) {
        return (Transaction)this.getAndConvertExceptions(this.datastore.beginTransaction(options));
    }

    public KeyRange allocateIds(String kind, long num) {
        return (KeyRange)this.getAndConvertExceptions(this.datastore.allocateIds(kind, num));
    }

    public KeyRange allocateIds(Key parent, String kind, long num) {
        return (KeyRange)this.getAndConvertExceptions(this.datastore.allocateIds(parent, kind, num));
    }

    public DatastoreService.KeyRangeState allocateIdRange(KeyRange range) {
        throw new UnsupportedOperationException("allocateIdRange not supported on async Datastores");
    }

    public DatastoreAttributes getDatastoreAttributes() {
        return (DatastoreAttributes)this.getAndConvertExceptions(this.datastore.getDatastoreAttributes());
    }

    public Map<Index, Index.IndexState> getIndexes() {
        return (Map)this.getAndConvertExceptions(this.datastore.getIndexes());
    }

    private <T> T getAndConvertExceptions(Future<T> future) {
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new DatastoreFailureException("Datastore failure", (Throwable)e);
        }
    }

    private <T> T getAndConvertExceptionsExceptEntityNotFound(Future<T> future) throws EntityNotFoundException {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw (EntityNotFoundException)e.getCause();
            }
            throw new DatastoreFailureException("Datastore failure", (Throwable)e);
        }
        catch (Exception e) {
            throw new DatastoreFailureException("Datastore failure", (Throwable)e);
        }
    }
}

