/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.util.Properties;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractGenerator
implements ValueGenerator {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected String name;
    protected Properties properties;
    protected int allocationSize = 5;
    protected int initialValue = 0;
    protected ValueGenerationBlock block;
    protected boolean repositoryExists = false;

    public AbstractGenerator(String name, Properties props) {
        this.name = name;
        this.properties = props;
    }

    public static Class getStorageClass() {
        return Long.class;
    }

    public String getName() {
        return this.name;
    }

    public synchronized Object next() {
        if (this.block == null || !this.block.hasNext()) {
            this.block = this.obtainGenerationBlock();
        }
        return this.block.next().getValue();
    }

    public synchronized Object current() {
        if (this.block == null) {
            return null;
        }
        return this.block.current().getValue();
    }

    public long nextValue() {
        return this.getLongValueForObject(this.next());
    }

    public long currentValue() {
        return this.getLongValueForObject(this.current());
    }

    private long getLongValueForObject(Object oid) {
        if (oid instanceof Long) {
            return (Long)oid;
        }
        if (oid instanceof Integer) {
            return ((Integer)oid).longValue();
        }
        if (oid instanceof Short) {
            return ((Short)oid).longValue();
        }
        throw new NucleusDataStoreException(LOCALISER.msg("040009", (Object)this.name));
    }

    public synchronized void allocate(int additional) {
        if (this.block == null) {
            this.block = this.obtainGenerationBlock(additional);
        } else {
            this.block.addBlock(this.obtainGenerationBlock(additional));
        }
    }

    protected ValueGenerationBlock obtainGenerationBlock() {
        return this.obtainGenerationBlock(-1);
    }

    protected ValueGenerationBlock obtainGenerationBlock(int number) {
        ValueGenerationBlock block = null;
        boolean repository_exists = true;
        if (this.requiresRepository() && !this.repositoryExists) {
            this.repositoryExists = this.repositoryExists();
            if (!this.repositoryExists) {
                this.createRepository();
                this.repositoryExists = true;
            }
        }
        try {
            block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
        }
        catch (ValueGenerationException vex) {
            NucleusLogger.VALUEGENERATION.info(LOCALISER.msg("040003", (Object)vex.getMessage()));
            if (this.requiresRepository()) {
                repository_exists = false;
            }
            throw vex;
        }
        catch (RuntimeException ex) {
            NucleusLogger.VALUEGENERATION.info(LOCALISER.msg("040003", (Object)ex.getMessage()));
            if (this.requiresRepository()) {
                repository_exists = false;
            }
            throw ex;
        }
        if (!repository_exists) {
            NucleusLogger.VALUEGENERATION.info(LOCALISER.msg("040005"));
            if (!this.createRepository()) {
                throw new ValueGenerationException(LOCALISER.msg("040002"));
            }
            block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
        }
        return block;
    }

    protected ValueGenerationBlock reserveBlock() {
        return this.reserveBlock(this.allocationSize);
    }

    protected abstract ValueGenerationBlock reserveBlock(long var1);

    protected boolean requiresRepository() {
        return false;
    }

    protected boolean repositoryExists() {
        return true;
    }

    protected boolean createRepository() {
        return true;
    }
}

