/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlException;
import com.google.appengine.repackaged.com.esotericsoftware.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.CronXml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class CronYamlReader {
    private static final String FILENAME = "cron.yaml";
    private String appDir;

    public CronYamlReader(String appDir) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            String string = String.valueOf(appDir);
            char c = File.separatorChar;
            appDir = new StringBuilder(1 + String.valueOf(string).length()).append(string).append(c).toString();
        }
        this.appDir = appDir;
    }

    public String getFilename() {
        String string = String.valueOf(this.appDir);
        String string2 = String.valueOf(FILENAME);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    public CronXml parse() {
        if (new File(this.getFilename()).exists()) {
            try {
                return CronYamlReader.parse(new FileReader(this.getFilename()));
            }
            catch (FileNotFoundException ex) {
                String string = String.valueOf(this.getFilename());
                throw new AppEngineConfigException(string.length() != 0 ? "Cannot find file ".concat(string) : new String("Cannot find file "), ex);
            }
        }
        return null;
    }

    public static CronXml parse(Reader yaml) {
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setPropertyElementType(CronYaml.class, "cron", CronXml.Entry.class);
        try {
            CronYaml cronYaml = reader.read(CronYaml.class);
            if (cronYaml == null) {
                throw new AppEngineConfigException("Empty cron configuration.");
            }
            return cronYaml.toXml();
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    public static CronXml parse(String yaml) {
        return CronYamlReader.parse(new StringReader(yaml));
    }

    public static class CronYaml {
        private List<CronXml.Entry> entries;

        public List<CronXml.Entry> getCron() {
            return this.entries;
        }

        public void setCron(List<CronXml.Entry> entries) {
            this.entries = entries;
        }

        public CronXml toXml() {
            CronXml xml = new CronXml();
            if (this.entries != null) {
                for (CronXml.Entry entry : this.entries) {
                    xml.addEntry(entry);
                }
            }
            return xml;
        }
    }
}

