/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.jetty9;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.jetty9.AppEngineAuthentication;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserDataConstraint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

public class AppEngineWebAppContext
extends WebAppContext {
    private static final int MAX_RESPONSE_SIZE = 0x2000000;
    private final String serverInfo;

    public AppEngineWebAppContext(File appDir, String serverInfo) {
        super(appDir.getPath(), "/");
        Resource webApp = null;
        try {
            webApp = Resource.newResource((String)appDir.getAbsolutePath());
            if (appDir.isDirectory()) {
                this.setWar(appDir.getPath());
                this.setBaseResource(webApp);
            } else {
                File extractedWebAppDir = AppEngineWebAppContext.createTempDir();
                extractedWebAppDir.mkdir();
                extractedWebAppDir.deleteOnExit();
                Resource jarWebWpp = JarResource.newJarResource((Resource)webApp);
                jarWebWpp.copyTo(extractedWebAppDir);
                this.setBaseResource(Resource.newResource((String)extractedWebAppDir.getAbsolutePath()));
                this.setWar(extractedWebAppDir.getPath());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot create AppEngineWebAppContext:", e);
        }
        this.serverInfo = serverInfo;
        this._scontext = new AppEngineServletContext();
        AppEngineAuthentication.configureSecurityHandler((ConstraintSecurityHandler)this.getSecurityHandler());
        this.setMaxFormContentSize(0x2000000);
    }

    private static File createTempDir() {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        long l = System.currentTimeMillis();
        String baseName = new StringBuilder(21).append(l).append("-").toString();
        int counter = 0;
        while (counter < 10) {
            int n = counter++;
            File tempDir = new File(baseDir, new StringBuilder(11 + String.valueOf(baseName).length()).append(baseName).append(n).toString());
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Failed to create directory ");
    }

    protected SecurityHandler newSecurityHandler() {
        return new AppEngineContraintSecurityHandler();
    }

    public class AppEngineServletContext
    extends WebAppContext.Context {
        public AppEngineServletContext() {
            super((WebAppContext)AppEngineWebAppContext.this);
        }

        public ClassLoader getClassLoader() {
            return AppEngineWebAppContext.this.getClassLoader();
        }

        public String getServerInfo() {
            return AppEngineWebAppContext.this.serverInfo;
        }

        public void log(String message) {
            this.log(message, null);
        }

        public void log(String message, Throwable throwable) {
            StringWriter writer = new StringWriter();
            writer.append("javax.servlet.ServletContext log: ");
            writer.append(message);
            if (throwable != null) {
                writer.append("\n");
                throwable.printStackTrace(new PrintWriter(writer));
            }
            ApiProxy.LogRecord.Level logLevel = throwable == null ? ApiProxy.LogRecord.Level.info : ApiProxy.LogRecord.Level.error;
            ApiProxy.log((ApiProxy.LogRecord)new ApiProxy.LogRecord(logLevel, System.currentTimeMillis() * 1000L, writer.toString()));
        }

        public void log(Exception exception, String msg) {
            this.log(msg, exception);
        }
    }

    private static class AppEngineContraintSecurityHandler
    extends ConstraintSecurityHandler {
        private AppEngineContraintSecurityHandler() {
        }

        protected RoleInfo prepareConstraintInfo(String pathInContext, Request request) {
            RoleInfo ri = super.prepareConstraintInfo(pathInContext, request);
            ri.setUserDataConstraint(UserDataConstraint.None);
            return ri;
        }
    }
}

