/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.util.HashMap;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.SecondaryDatastoreClass;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.TableMismatchException;

public class TableExprAsJoins
extends LogicSetExpression {
    protected final HashMap aliasesByTable = new HashMap();

    public TableExprAsJoins(QueryExpression qs, DatastoreContainerObject mainTable, DatastoreIdentifier alias) {
        super(qs, mainTable, alias);
        this.aliasesByTable.put(mainTable, alias);
    }

    public String referenceColumn(DatastoreField col) {
        String aliasString;
        this.assertNotFrozen();
        DatastoreContainerObject table = col.getDatastoreContainerObject();
        DatastoreIdentifier alias = (DatastoreIdentifier)this.aliasesByTable.get(table);
        if (alias == null) {
            JoinMetaData joinmd;
            if (!(this.mainTable instanceof DatastoreClass) || !(table instanceof DatastoreClass)) {
                throw new TableMismatchException(col, this.mainTable);
            }
            IdentifierFactory idFactory = this.qs.getStoreManager().getIdentifierFactory();
            alias = idFactory.newIdentifier(this.mainAlias, String.valueOf(this.aliasesByTable.size()));
            this.aliasesByTable.put(table, alias);
            DatastoreClass mt = (DatastoreClass)this.mainTable;
            DatastoreClass st = (DatastoreClass)table;
            boolean useInnerJoin = true;
            if (st instanceof SecondaryDatastoreClass && (joinmd = ((SecondaryDatastoreClass)st).getJoinMetaData()) != null && joinmd.isOuter()) {
                useInnerJoin = false;
            }
            LogicSetExpression stTblExpr = this.qs.newTableExpression(st, alias);
            ScalarExpression mtExpr = mt.getIDMapping().newScalarExpression(this.qs, this);
            ScalarExpression stExpr = st.getIDMapping().newScalarExpression(this.qs, stTblExpr);
            if (useInnerJoin) {
                this.qs.innerJoin(mtExpr, stExpr, stTblExpr, true, true);
            } else {
                this.qs.leftOuterJoin(mtExpr, stExpr, stTblExpr, true, true);
            }
        }
        if ((aliasString = alias.toString()).length() > 0) {
            return col.applySelectFunction(aliasString + "." + col.getIdentifier());
        }
        return col.applySelectFunction(col.getIdentifier().toString());
    }

    public String toString() {
        if (this.sqlText == null) {
            DatastoreIdentifier mainTableName = this.mainTable.getIdentifier();
            StringBuffer sb = new StringBuffer(this.mainTable.toString());
            if (!this.mainAlias.equals(mainTableName)) {
                sb.append(' ').append(this.mainAlias);
            }
            this.sqlText = sb.toString();
        }
        return this.sqlText;
    }
}

