/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.LoginReader;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;

public class LoginReaderFactory {
    public static LoginReader createLoginReader(AppAdminFactory.ConnectOptions options, boolean passin) {
        if (passin) {
            return new PassinReader(options);
        }
        ConsoleReader reader = new ConsoleReader(options);
        if (reader.hasConsole()) {
            return reader;
        }
        return new SimpleLoginReader(options);
    }

    public static class PassinReader
    extends SimpleLoginReader {
        public PassinReader(AppAdminFactory.ConnectOptions options) {
            super(options);
        }

        @Override
        public void doPrompt() {
            if (this.count == 0) {
                super.doPrompt();
            }
        }
    }

    public static class ConsoleReader
    extends SimpleLoginReader {
        private final Console console = System.console();

        public ConsoleReader(AppAdminFactory.ConnectOptions options) {
            super(options);
        }

        protected String promptForUsername(String prompt) {
            return this.console.readLine(prompt, new Object[0]);
        }

        @Override
        public String promptForPassword(String prompt) {
            return new String(this.console.readPassword(prompt, new Object[0]));
        }

        public boolean hasConsole() {
            return this.console != null;
        }
    }

    public static class SimpleLoginReader
    implements LoginReader {
        protected int count = 0;
        private String email;
        private String password;
        private final AppAdminFactory.ConnectOptions options;

        public SimpleLoginReader(AppAdminFactory.ConnectOptions options) {
            this.options = options;
        }

        @Override
        public void doPrompt() {
            this.email = this.options.getUserId();
            if (this.email == null || this.count > 0) {
                this.email = this.promptForEmail("Email: ");
            }
            String string = this.email;
            this.password = this.promptForPassword(new StringBuilder(15 + String.valueOf(string).length()).append("Password for ").append(string).append(": ").toString());
            ++this.count;
        }

        protected String promptForEmail(String prompt) {
            return this.prompt(prompt);
        }

        protected String promptForPassword(String prompt) {
            return this.prompt(prompt);
        }

        protected String prompt(String prompt) {
            System.out.print(prompt);
            System.out.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                return in.readLine();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        @Override
        public String getUsername() {
            return this.email;
        }

        @Override
        public String getPassword() {
            return this.password;
        }
    }
}

