/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.CronXml;
import com.google.apphosting.utils.config.RetryParametersXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import org.w3c.dom.Element;

public class CronXmlReader
extends AbstractConfigXmlReader<CronXml> {
    private static final String FILENAME = "WEB-INF/cron.xml";
    private static final String CRONENTRIES_TAG = "cronentries";
    private static final String CRON_TAG = "cron";
    private static final String DESCRIPTION_TAG = "description";
    private static final String SCHEDULE_TAG = "schedule";
    private static final String TARGET_TAG = "target";
    private static final String TIMEZONE_TAG = "timezone";
    private static final String URL_TAG = "url";
    private static final String RETRY_PARAMETERS_TAG = "retry-parameters";
    private static final String JOB_RETRY_LIMIT_TAG = "job-retry-limit";
    private static final String JOB_AGE_LIMIT_TAG = "job-age-limit";
    private static final String MIN_BACKOFF_SECONDS_TAG = "min-backoff-seconds";
    private static final String MAX_BACKOFF_SECONDS_TAG = "max-backoff-seconds";
    private static final String MAX_DOUBLINGS_TAG = "max-doublings";

    public CronXmlReader(String appDir) {
        super(appDir, false);
    }

    public CronXml readCronXml() {
        return (CronXml)this.readConfigXml();
    }

    @Override
    protected CronXml processXml(InputStream is) {
        CronXml cronXml = new CronXml();
        Element root = XmlUtils.parseXml(is).getDocumentElement();
        if (!root.getTagName().equals(CRONENTRIES_TAG)) {
            String string = this.getFilename();
            throw new AppEngineConfigException(new StringBuilder(31 + String.valueOf(string).length()).append(string).append(" does not contain <").append(CRONENTRIES_TAG).append(">").toString());
        }
        for (Element child : XmlUtils.getChildren(root)) {
            if (child.getTagName().equals(CRON_TAG)) {
                this.parseCron(child, cronXml.addNewEntry());
                continue;
            }
            String string = this.getFilename();
            String string2 = child.getTagName();
            throw new AppEngineConfigException(new StringBuilder(31 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" contains <").append(string2).append("> instead of <").append(CRON_TAG).append("/>").toString());
        }
        cronXml.validateLastEntry();
        return cronXml;
    }

    private void parseCron(Element cronElement, CronXml.Entry entry) {
        block16: for (Element child : XmlUtils.getChildren(cronElement)) {
            switch (child.getTagName()) {
                case "description": {
                    entry.setDescription(this.stringContents(child));
                    continue block16;
                }
                case "url": {
                    entry.setUrl(this.stringContents(child));
                    continue block16;
                }
                case "schedule": {
                    entry.setSchedule(this.stringContents(child));
                    continue block16;
                }
                case "timezone": {
                    entry.setTimezone(this.stringContents(child));
                    continue block16;
                }
                case "target": {
                    entry.setTarget(this.stringContents(child));
                    continue block16;
                }
                case "retry-parameters": {
                    entry.setRetryParameters(this.parseRetryParameters(child));
                    continue block16;
                }
            }
            String string = this.getFilename();
            String string2 = child.getTagName();
            throw new AppEngineConfigException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" contains unknown <").append(string2).append("> inside <").append(CRON_TAG).append("/>").toString());
        }
    }

    private RetryParametersXml parseRetryParameters(Element retryElement) {
        RetryParametersXml retryParameters = new RetryParametersXml();
        block14: for (Element child : XmlUtils.getChildren(retryElement)) {
            switch (child.getTagName()) {
                case "job-retry-limit": {
                    retryParameters.setRetryLimit(this.stringContents(child));
                    continue block14;
                }
                case "job-age-limit": {
                    retryParameters.setAgeLimitSec(this.stringContents(child));
                    continue block14;
                }
                case "min-backoff-seconds": {
                    retryParameters.setMinBackoffSec(this.stringContents(child));
                    continue block14;
                }
                case "max-backoff-seconds": {
                    retryParameters.setMaxBackoffSec(this.stringContents(child));
                    continue block14;
                }
                case "max-doublings": {
                    retryParameters.setMaxDoublings(this.stringContents(child));
                    continue block14;
                }
            }
            String string = this.getFilename();
            String string2 = child.getTagName();
            throw new AppEngineConfigException(new StringBuilder(47 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" contains unknown <").append(string2).append("> inside <").append(RETRY_PARAMETERS_TAG).append("/>").toString());
        }
        return retryParameters;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }
}

