/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.scostore.AbstractCollectionStore;
import org.datanucleus.store.mapped.scostore.AbstractSetStoreSpecialization;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractSetStore
extends AbstractCollectionStore
implements SetStore {
    protected AbstractSetStore(StoreManager storeMgr, ClassLoaderResolver clr, AbstractSetStoreSpecialization specialization) {
        super(storeMgr, clr, specialization);
    }

    private AbstractSetStoreSpecialization getSpecialization() {
        return (AbstractSetStoreSpecialization)this.specialization;
    }

    public abstract Iterator iterator(StateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element, int size) {
        this.validateElementForWriting(sm, element, null);
        boolean modified = false;
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                int[] num = this.getSpecialization().internalAdd(sm, mconn, false, element, true, this);
                if (num[0] > 0) {
                    modified = true;
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            NucleusLogger.DATASTORE.error(e);
            String msg = LOCALISER.msg("056009", (Object)e.getMessage());
            NucleusLogger.DATASTORE.error(msg);
            throw new NucleusDataStoreException(msg, e);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<MappedDatastoreException> exceptions = new ArrayList<MappedDatastoreException>();
        boolean batched = elements.size() > 1;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            this.validateElementForWriting(sm, iter.next(), null);
        }
        ObjectManager om = sm.getObjectManager();
        ManagedConnection mconn = this.storeMgr.getConnection(om);
        try {
            iter = elements.iterator();
            Object element = null;
            int[] returnCode = null;
            while (iter.hasNext()) {
                element = iter.next();
                try {
                    returnCode = this.getSpecialization().internalAdd(sm, mconn, batched, element, !batched || batched && !iter.hasNext(), this);
                }
                catch (MappedDatastoreException mde) {
                    exceptions.add(mde);
                    NucleusLogger.DATASTORE.error(mde);
                }
            }
            if (exceptions.size() == 0) {
                if (returnCode == null) {
                    modified = false;
                } else {
                    for (int i = 0; i < returnCode.length; ++i) {
                        if (returnCode[i] <= 0) continue;
                        modified = true;
                    }
                }
            }
        }
        finally {
            mconn.release();
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("056009", (Object)((Exception)exceptions.get(0)).getMessage());
            NucleusLogger.DATASTORE.error(msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), sm.getObject());
        }
        return modified;
    }

    public boolean remove(StateManager sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(sm, element)) {
            NucleusLogger.DATASTORE.debug("Attempt to remove element=" + StringUtils.toJVMIDString(element) + " but doesn't exist in this Set.");
            return false;
        }
        Object elementToRemove = element;
        ObjectManager om = sm.getObjectManager();
        if (om.getApiAdapter().isDetached(element)) {
            elementToRemove = om.findObject(om.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        boolean modified = this.getSpecialization().remove(sm, elementToRemove, size, this);
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (allowDependentField && collmd.isDependentElement() && !collmd.isEmbeddedElement()) {
            sm.getObjectManager().deleteObjectInternal(elementToRemove);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        ArrayList<MappedDatastoreException> exceptions = new ArrayList<MappedDatastoreException>();
        boolean batched = elements.size() > 1;
        for (Object element : elements) {
            if (this.validateElementForReading(sm, element)) continue;
            NucleusLogger.DATASTORE.debug("AbstractSetStore::removeAll element=" + element + " doesn't exist in this Set.");
            return false;
        }
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            try {
                Object element = null;
                Iterator iter = elements.iterator();
                this.getSpecialization().preInternalRemove(mconn);
                while (iter.hasNext()) {
                    element = iter.next();
                    try {
                        int[] rc = this.getSpecialization().internalRemove(sm, mconn, batched, element, !batched || batched && !iter.hasNext(), this);
                        if (rc == null) continue;
                        for (int i = 0; i < rc.length; ++i) {
                            if (rc[i] <= 0) continue;
                            modified = true;
                        }
                    }
                    catch (MappedDatastoreException mde) {
                        mde.printStackTrace();
                        exceptions.add(mde);
                        NucleusLogger.DATASTORE.error(mde);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            e.printStackTrace();
            exceptions.add(e);
            NucleusLogger.DATASTORE.error(e);
        }
        if (!exceptions.isEmpty()) {
            String msg = LOCALISER.msg("056012", (Object)((Exception)exceptions.get(0)).getMessage());
            NucleusLogger.DATASTORE.error(msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), sm.getObject());
        }
        return modified;
    }
}

