/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityProtoComparators;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.labs.datastore.overlay.LazyList;
import com.google.appengine.api.labs.datastore.overlay.OverlayAsyncDatastoreServiceImpl;
import com.google.appengine.api.labs.datastore.overlay.OverlayUtils;
import com.google.appengine.api.labs.datastore.overlay.QueryResultBatchIterator;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Queues;
import com.google.apphosting.api.DatastorePb;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;

final class OverlayPreparedQueryImpl
implements PreparedQuery {
    private static final int COUNT_ENTITIES_LEGACY_LIMIT = 1000;
    private final OverlayAsyncDatastoreServiceImpl overlay;
    private final PreparedQuery preparedOverlayQuery;
    private final PreparedQuery preparedParentQuery;
    private final EntityComparator entityComparator;
    private final Transaction txn;

    public OverlayPreparedQueryImpl(OverlayAsyncDatastoreServiceImpl overlay, Query query, PreparedQuery preparedOverlayQuery, PreparedQuery preparedParentQuery, Transaction txn) {
        Preconditions.checkNotNull(query);
        this.overlay = Preconditions.checkNotNull(overlay);
        this.preparedOverlayQuery = Preconditions.checkNotNull(preparedOverlayQuery);
        this.preparedParentQuery = Preconditions.checkNotNull(preparedParentQuery);
        this.entityComparator = new EntityComparator(query.getSortPredicates());
        this.txn = txn;
    }

    public List<Entity> asList(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return this.asQueryResultList(fetchOptions);
    }

    public QueryResultList<Entity> asQueryResultList(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return new LazyList(this.runQuery(fetchOptions));
    }

    public Iterable<Entity> asIterable(final FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return new Iterable<Entity>(){

            @Override
            public Iterator<Entity> iterator() {
                return OverlayPreparedQueryImpl.this.asIterator(fetchOptions);
            }
        };
    }

    public Iterable<Entity> asIterable() {
        return this.asIterable(FetchOptions.Builder.withDefaults());
    }

    public QueryResultIterable<Entity> asQueryResultIterable(final FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return new QueryResultIterable<Entity>(){

            public QueryResultIterator<Entity> iterator() {
                return OverlayPreparedQueryImpl.this.asQueryResultIterator(fetchOptions);
            }
        };
    }

    public QueryResultIterable<Entity> asQueryResultIterable() {
        return this.asQueryResultIterable(FetchOptions.Builder.withDefaults());
    }

    public Iterator<Entity> asIterator(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return this.asQueryResultIterator(fetchOptions);
    }

    public Iterator<Entity> asIterator() {
        return this.asIterator(FetchOptions.Builder.withDefaults());
    }

    public QueryResultIterator<Entity> asQueryResultIterator(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return this.runQuery(fetchOptions);
    }

    public QueryResultIterator<Entity> asQueryResultIterator() {
        return this.asQueryResultIterator(FetchOptions.Builder.withDefaults());
    }

    public Entity asSingleEntity() {
        List<Entity> entities = this.asList(FetchOptions.Builder.withLimit((int)2));
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() != 1) {
            throw new PreparedQuery.TooManyResultsException();
        }
        return entities.get(0);
    }

    public int countEntities(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        return Iterables.size(this.asIterable(fetchOptions));
    }

    public int countEntities() {
        return this.countEntities(FetchOptions.Builder.withDefaults().limit(1000));
    }

    static DatastorePb.Query.Order convertSortPredicateToPb(Query.SortPredicate predicate) {
        Preconditions.checkNotNull(predicate);
        DatastorePb.Query.Order order = new DatastorePb.Query.Order();
        order.setProperty(predicate.getPropertyName());
        order.setDirection(OverlayPreparedQueryImpl.getSortOp(predicate.getDirection()));
        return order;
    }

    private static DatastorePb.Query.Order.Direction getSortOp(Query.SortDirection direction) {
        switch (direction) {
            case ASCENDING: {
                return DatastorePb.Query.Order.Direction.ASCENDING;
            }
            case DESCENDING: {
                return DatastorePb.Query.Order.Direction.DESCENDING;
            }
        }
        String string = String.valueOf(direction);
        throw new IllegalArgumentException(new StringBuilder(11 + String.valueOf(string).length()).append("direction: ").append(string).toString());
    }

    private OverlayQueryResultIteratorImpl runQuery(FetchOptions fetchOptions) {
        Preconditions.checkNotNull(fetchOptions);
        FetchOptions overlayFetchOptions = this.cloneFetchOptionsPrefetchAndChunkSize(fetchOptions);
        FetchOptions parentFetchOptions = this.cloneFetchOptionsPrefetchAndChunkSize(fetchOptions);
        QueryResultIterator overlayIterator = this.preparedOverlayQuery.asQueryResultIterator(overlayFetchOptions);
        QueryResultIterator parentIterator = this.preparedParentQuery.asQueryResultIterator(parentFetchOptions);
        return new OverlayQueryResultIteratorImpl(overlayIterator, parentIterator, fetchOptions);
    }

    private FetchOptions cloneFetchOptionsPrefetchAndChunkSize(FetchOptions fetchOptions) {
        Integer chunkSize;
        Preconditions.checkNotNull(fetchOptions);
        FetchOptions clonedOptions = FetchOptions.Builder.withDefaults();
        Integer prefetchSize = fetchOptions.getPrefetchSize();
        if (prefetchSize != null) {
            clonedOptions.prefetchSize(prefetchSize.intValue());
        }
        if ((chunkSize = fetchOptions.getChunkSize()) != null) {
            clonedOptions.chunkSize(chunkSize.intValue());
        }
        return clonedOptions;
    }

    private final class OverlayQueryResultIteratorImpl
    implements QueryResultBatchIterator<Entity> {
        private final QueryResultIterator<Entity> overlayIterator;
        private final QueryResultIterator<Entity> parentIterator;
        private final FetchOptions fetchOptions;
        private final Queue<Entity> combinedEntityQueue;
        private final Queue<Entity> overlayEntityQueue;
        private final Queue<Entity> parentEntityQueue;
        private Integer remainingLimit;
        private int remainingOffset;

        private OverlayQueryResultIteratorImpl(QueryResultIterator<Entity> overlayIterator, QueryResultIterator<Entity> parentIterator, FetchOptions fetchOptions) {
            this.overlayIterator = Preconditions.checkNotNull(overlayIterator);
            this.parentIterator = Preconditions.checkNotNull(parentIterator);
            this.fetchOptions = Preconditions.checkNotNull(fetchOptions);
            this.combinedEntityQueue = Queues.newArrayDeque();
            this.overlayEntityQueue = Queues.newArrayDeque();
            this.parentEntityQueue = Queues.newArrayDeque();
            this.remainingLimit = fetchOptions.getLimit();
            Integer offset = fetchOptions.getOffset();
            if (offset != null) {
                this.remainingOffset = offset;
            }
            if (fetchOptions.getPrefetchSize() != null) {
                this.ensureLoaded(fetchOptions.getPrefetchSize());
            }
        }

        public boolean hasNext() {
            return this.ensureLoaded(1) >= 1;
        }

        public Entity next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Entity next = this.takeNext();
            return next;
        }

        @Override
        public List<Entity> nextList(int maximumElements) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < maximumElements && this.hasNext(); ++i) {
                builder.add(this.next());
            }
            return builder.build();
        }

        public List<Index> getIndexList() {
            return this.parentIterator.getIndexList();
        }

        public Cursor getCursor() {
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException("QueryResultIterator does not support remove");
        }

        private Entity takeNext() {
            return this.combinedEntityQueue.poll();
        }

        private boolean overlayQueryHasMore() {
            return !this.overlayEntityQueue.isEmpty() || this.overlayIterator.hasNext();
        }

        private boolean parentQueryHasMore() {
            return !this.parentEntityQueue.isEmpty() || this.parentIterator.hasNext();
        }

        private int getChunkSize() {
            Integer chunkSize = this.fetchOptions.getChunkSize();
            return chunkSize != null ? chunkSize : 1;
        }

        private void refillOverlayEntityQueue() {
            Preconditions.checkState(this.overlayEntityQueue.isEmpty());
            for (int i = 0; i < this.getChunkSize() && this.overlayIterator.hasNext(); ++i) {
                Entity e = (Entity)this.overlayIterator.next();
                if (OverlayUtils.isTombstone(e)) continue;
                this.overlayEntityQueue.add(e);
            }
        }

        private void refillParentEntityQueue() {
            Preconditions.checkState(this.parentEntityQueue.isEmpty());
            for (int i = 0; i < this.getChunkSize() && this.parentIterator.hasNext(); ++i) {
                this.parentEntityQueue.add((Entity)this.parentIterator.next());
            }
            Map<Key, Entity> overlayResults = OverlayPreparedQueryImpl.this.overlay.getFromOverlayOnly(OverlayPreparedQueryImpl.this.txn, OverlayUtils.getKeysAndTombstoneKeysForEntities(this.parentEntityQueue));
            Iterator iterator = this.parentEntityQueue.iterator();
            while (iterator.hasNext()) {
                Entity entity = (Entity)iterator.next();
                if (!overlayResults.containsKey(entity.getKey()) && !overlayResults.containsKey(OverlayUtils.getTombstoneKey(entity.getKey()))) continue;
                iterator.remove();
            }
        }

        private void mergeEntityQueues(int numEntities) {
            if (this.overlayEntityQueue.isEmpty()) {
                Preconditions.checkState(!this.overlayIterator.hasNext());
                if (this.parentEntityQueue.isEmpty()) {
                    Preconditions.checkState(!this.parentIterator.hasNext());
                } else {
                    while (!this.parentEntityQueue.isEmpty()) {
                        this.enqueueEntity(this.parentEntityQueue.poll());
                    }
                }
                return;
            }
            if (this.parentEntityQueue.isEmpty()) {
                Preconditions.checkState(!this.parentIterator.hasNext());
                while (!this.overlayEntityQueue.isEmpty()) {
                    this.enqueueEntity(this.overlayEntityQueue.poll());
                }
                return;
            }
            for (int i = this.combinedEntityQueue.size(); i < numEntities; ++i) {
                if (this.overlayEntityQueue.isEmpty() || this.parentEntityQueue.isEmpty()) {
                    return;
                }
                int result = OverlayPreparedQueryImpl.this.entityComparator.compare(this.overlayEntityQueue.peek(), this.parentEntityQueue.peek());
                if (result < 0) {
                    this.enqueueEntity(this.overlayEntityQueue.poll());
                    continue;
                }
                this.enqueueEntity(this.parentEntityQueue.poll());
            }
        }

        private void enqueueEntity(Entity e) {
            if (this.remainingOffset > 0) {
                --this.remainingOffset;
                return;
            }
            this.combinedEntityQueue.add(e);
            if (this.remainingLimit != null) {
                Integer n = this.remainingLimit;
                Integer n2 = this.remainingLimit = Integer.valueOf(this.remainingLimit - 1);
                if (this.remainingLimit == 0) {
                    this.overlayEntityQueue.clear();
                    this.parentEntityQueue.clear();
                }
            }
        }

        private int ensureLoaded(int numEntities) {
            if (this.remainingLimit == null || this.remainingLimit > 0) {
                while (this.combinedEntityQueue.size() < numEntities) {
                    if (!this.overlayQueryHasMore() && !this.parentQueryHasMore()) {
                        return this.combinedEntityQueue.size();
                    }
                    while (this.overlayEntityQueue.isEmpty() && this.overlayIterator.hasNext()) {
                        this.refillOverlayEntityQueue();
                    }
                    while (this.parentEntityQueue.isEmpty() && this.parentIterator.hasNext()) {
                        this.refillParentEntityQueue();
                    }
                    this.mergeEntityQueues(numEntities);
                }
            }
            return this.combinedEntityQueue.size();
        }
    }

    private static final class EntityComparator
    implements Comparator<Entity> {
        private final EntityProtoComparators.EntityProtoComparator delegate;

        EntityComparator(List<Query.SortPredicate> sortPreds) {
            Preconditions.checkNotNull(sortPreds);
            this.delegate = new EntityProtoComparators.EntityProtoComparator(EntityComparator.sortPredicatesToOrders(sortPreds));
        }

        private static List<DatastorePb.Query.Order> sortPredicatesToOrders(List<Query.SortPredicate> sortPreds) {
            Preconditions.checkNotNull(sortPreds);
            ImmutableList.Builder orders = ImmutableList.builder();
            for (Query.SortPredicate sp : sortPreds) {
                orders.add(OverlayPreparedQueryImpl.convertSortPredicateToPb(sp));
            }
            return orders.build();
        }

        @Override
        public int compare(Entity e1, Entity e2) {
            return this.delegate.compare((Object)EntityTranslator.convertToPb((Entity)e1), (Object)EntityTranslator.convertToPb((Entity)e2));
        }
    }
}

