/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient.util;

public final class TimeoutController {
    private TimeoutController() {
    }

    public static void execute(Thread thread, long l) throws TimeoutException {
        thread.start();
        try {
            thread.join(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (thread.isAlive()) {
            thread.interrupt();
            throw new TimeoutException();
        }
    }

    public static void execute(Runnable runnable, long l) throws TimeoutException {
        Thread thread = new Thread(runnable, "Timeout guard");
        thread.setDaemon(true);
        TimeoutController.execute(thread, l);
    }

    public static class TimeoutException
    extends Exception {
    }
}

