/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.el;

import com.google.appengine.repackaged.org.apache.commons.el.Literal;

public class StringLiteral
extends Literal {
    StringLiteral(Object pValue) {
        super(pValue);
    }

    public static StringLiteral fromToken(String pToken) {
        return new StringLiteral(StringLiteral.getValueFromToken(pToken));
    }

    public static StringLiteral fromLiteralValue(String pValue) {
        return new StringLiteral(pValue);
    }

    public static String getValueFromToken(String pToken) {
        StringBuffer buf = new StringBuffer();
        int len = pToken.length() - 1;
        boolean escaping = false;
        int i = 1;
        while (i < len) {
            char ch = pToken.charAt(i);
            if (escaping) {
                buf.append(ch);
                escaping = false;
            } else if (ch == '\\') {
                escaping = true;
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toStringToken(String pValue) {
        if (pValue.indexOf(34) < 0 && pValue.indexOf(92) < 0) {
            return "\"" + pValue + "\"";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        int len = pValue.length();
        int i = 0;
        while (i < len) {
            char ch = pValue.charAt(i);
            if (ch == '\\') {
                buf.append('\\');
                buf.append('\\');
            } else if (ch == '\"') {
                buf.append('\\');
                buf.append('\"');
            } else {
                buf.append(ch);
            }
            ++i;
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String toIdentifierToken(String pValue) {
        if (StringLiteral.isJavaIdentifier(pValue)) {
            return pValue;
        }
        return StringLiteral.toStringToken(pValue);
    }

    static boolean isJavaIdentifier(String pValue) {
        int len = pValue.length();
        if (len == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(pValue.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < len) {
            if (!Character.isJavaIdentifierPart(pValue.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getExpressionString() {
        return StringLiteral.toStringToken((String)this.getValue());
    }
}

