/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.printers;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.cloud.sql.tool.printers.Printer;
import com.google.cloud.sql.tool.printers.PrinterUtils;
import java.io.PrintWriter;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

class TabularTerminalPrinter
extends Printer {
    private boolean headerDisplayed;

    protected TabularTerminalPrinter(ResultSetMetaData md, float elapsedSeconds, PrintWriter out) {
        super(md, elapsedSeconds, out);
    }

    @Override
    protected void displayHeader() throws SQLException {
        if (this.headerDisplayed) {
            return;
        }
        String headerLine = this.createHeaderLine();
        this.out.println(headerLine);
        this.out.println(this.createNormalHeaderLabelLine());
        this.out.println(headerLine);
        this.headerDisplayed = true;
    }

    private String createNormalHeaderLabelLine() throws SQLException {
        int cols = this.md.getColumnCount();
        StringBuilder sb = new StringBuilder(256);
        for (int col = 1; col <= cols; ++col) {
            sb.append('|').append(' ');
            sb.append(PrinterUtils.getDisplayLabel(this.md, col, (Integer)this.columnWidths.get(col))).append(' ');
        }
        sb.append('|');
        return sb.toString();
    }

    private String createHeaderLine() throws SQLException {
        int cols = this.md.getColumnCount();
        StringBuilder sb = new StringBuilder(256);
        for (int col = 1; col <= cols; ++col) {
            sb.append('+');
            sb.append(Strings.repeat("-", (Integer)this.columnWidths.get(col) + 2));
        }
        sb.append('+');
        return sb.toString();
    }

    private static String createCell(String text, int width, int type) {
        String cellText = PrinterUtils.nullOrText(text);
        if (PrinterUtils.isString(type) || PrinterUtils.isLobOrBinary(type)) {
            return PrinterUtils.fixedSizeStringPadEnd(cellText, width, ' ');
        }
        return TabularTerminalPrinter.fixedSizeStringPadStart(cellText, width, ' ');
    }

    @Override
    public void displayFooter(int rowCount) throws SQLException {
        this.out.println(this.createHeaderLine());
        if (rowCount == 0) {
            this.out.println(String.format("Empty set (%.2f sec)", Float.valueOf(this.elapsedSeconds)));
        } else if (rowCount == 1) {
            this.out.println(String.format("%d row in set (%.2f sec)", rowCount, Float.valueOf(this.elapsedSeconds)));
        } else {
            this.out.println(String.format("%d rows in set (%.2f sec)", rowCount, Float.valueOf(this.elapsedSeconds)));
        }
        this.out.println();
    }

    @Override
    protected void displayLine(List<String> line) throws SQLException {
        StringBuilder sb = new StringBuilder(256);
        for (int col = 1; col <= this.columnWidths.size(); ++col) {
            sb.append("| ").append(TabularTerminalPrinter.createCell(line.get(col - 1), (Integer)this.columnWidths.get(col), this.md.getColumnType(col))).append(' ');
        }
        sb.append('|');
        this.out.println(sb);
    }

    private static String fixedSizeStringPadStart(String s, int size, char pad) {
        if (s.length() > size) {
            s = s.substring(0, size);
        }
        return Strings.padStart(s, size, pad);
    }
}

