/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.printers;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class PrinterUtils {
    private static final String NULL = "NULL";

    static String getDisplayLabel(ResultSetMetaData md, int col, int max) throws SQLException {
        return PrinterUtils.fixedSizeStringPadEnd(PrinterUtils.getDisplayLabel(md, col), max, ' ');
    }

    static String getDisplayLabel(ResultSetMetaData md, int col) throws SQLException {
        String label = md.getColumnLabel(col);
        if (Strings.isNullOrEmpty(label)) {
            label = md.getColumnName(col);
        }
        if (Strings.isNullOrEmpty(label)) {
            label = Integer.toString(col);
        }
        return label;
    }

    static String fixedSizeStringPadEnd(String s, int size, char pad) {
        if (s.length() > size) {
            s = s.substring(0, size);
        }
        return Strings.padEnd(s, size, pad);
    }

    static boolean isLobOrBinary(int type) {
        return type == 2004 || type == 2005 || type == 2011 || type == -2 || type == -16 || type == -4 || type == -1 || type == -3;
    }

    static boolean isString(int type) {
        return type == 12 || type == 1 || type == -15 || type == -9;
    }

    static String nullOrText(String text) {
        return text == null ? NULL : text;
    }
}

