/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache.dev;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;

class LRU<C extends Chainable<C>> {
    private C newest;
    private C oldest;

    public LRU() {
        this.clear();
    }

    public void clear() {
        this.newest = null;
        this.oldest = null;
    }

    public boolean isEmpty() {
        return this.getNewest() == null && this.getOldest() == null;
    }

    public C getNewest() {
        return this.newest;
    }

    public C getOldest() {
        return this.oldest;
    }

    public void update(C element) {
        Preconditions.checkNotNull(element);
        this.remove(element);
        if (this.newest != null) {
            this.newest.setNewer(element);
        }
        element.setNewer(null);
        element.setOlder(this.newest);
        this.newest = element;
        if (this.oldest == null) {
            this.oldest = element;
        }
    }

    public void remove(C element) {
        Preconditions.checkNotNull(element);
        Chainable newer = (Chainable)element.getNewer();
        Chainable older = (Chainable)element.getOlder();
        if (newer != null) {
            newer.setOlder(older);
        }
        if (older != null) {
            older.setNewer(newer);
        }
        if (element == this.newest) {
            this.newest = older;
        }
        if (element == this.oldest) {
            this.oldest = newer;
        }
        element.setNewer(null);
        element.setOlder(null);
    }

    public C removeOldest() {
        C oldest = this.getOldest();
        this.remove(oldest);
        return oldest;
    }

    public static abstract class AbstractChainable<E>
    implements Chainable<E> {
        private E newer = null;
        private E older = null;

        @Override
        public E getNewer() {
            return this.newer;
        }

        @Override
        public E getOlder() {
            return this.older;
        }

        @Override
        public void setNewer(E newer) {
            this.newer = newer;
        }

        @Override
        public void setOlder(E older) {
            this.older = older;
        }
    }

    static interface Chainable<E> {
        public E getNewer();

        public E getOlder();

        public void setNewer(E var1);

        public void setOlder(E var1);
    }
}

