/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.ConversionServicePb;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import java.util.logging.Logger;

public enum ConversionErrorCode {
    TIMEOUT,
    TRANSIENT_ERROR,
    INTERNAL_ERROR,
    UNSUPPORTED_CONVERSION,
    CONVERSION_TOO_LARGE,
    TOO_MANY_CONVERSIONS,
    INVALID_REQUEST;

    static final ImmutableMap<Integer, ConversionErrorCode> INT_ENUM_MAP;
    static final ImmutableMap<ConversionErrorCode, ConversionServicePb.ConversionServiceError.ErrorCode> ENUM_PROTO_MAP;
    private static final Logger logger;

    static ConversionErrorCode intToEnum(int number) {
        ConversionErrorCode code = INT_ENUM_MAP.get(number);
        if (code == null) {
            logger.warning(String.format("Error code %d is undefined.", number));
            return INTERNAL_ERROR;
        }
        return code;
    }

    static ConversionServicePb.ConversionServiceError.ErrorCode enumToProto(ConversionErrorCode errorCode) {
        return ENUM_PROTO_MAP.get((Object)errorCode);
    }

    static {
        INT_ENUM_MAP = new ImmutableMap.Builder<Integer, ConversionErrorCode>().put(1, TIMEOUT).put(2, TRANSIENT_ERROR).put(3, INTERNAL_ERROR).put(4, UNSUPPORTED_CONVERSION).put(5, CONVERSION_TOO_LARGE).put(6, TOO_MANY_CONVERSIONS).put(7, INVALID_REQUEST).build();
        ENUM_PROTO_MAP = new ImmutableMap.Builder<ConversionErrorCode, ConversionServicePb.ConversionServiceError.ErrorCode>().put(TIMEOUT, ConversionServicePb.ConversionServiceError.ErrorCode.TIMEOUT).put(TRANSIENT_ERROR, ConversionServicePb.ConversionServiceError.ErrorCode.TRANSIENT_ERROR).put(INTERNAL_ERROR, ConversionServicePb.ConversionServiceError.ErrorCode.INTERNAL_ERROR).put(UNSUPPORTED_CONVERSION, ConversionServicePb.ConversionServiceError.ErrorCode.UNSUPPORTED_CONVERSION).put(CONVERSION_TOO_LARGE, ConversionServicePb.ConversionServiceError.ErrorCode.CONVERSION_TOO_LARGE).put(TOO_MANY_CONVERSIONS, ConversionServicePb.ConversionServiceError.ErrorCode.TOO_MANY_CONVERSIONS).put(INVALID_REQUEST, ConversionServicePb.ConversionServiceError.ErrorCode.INVALID_REQUEST).build();
        logger = Logger.getLogger(ConversionErrorCode.class.getName());
    }
}

