/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;

public class CreateSchemaParser {
    public static void parse(PgDatabase database, String statement) {
        Parser parser = new Parser(statement);
        parser.expect("CREATE", "SCHEMA");
        if (parser.expectOptional("AUTHORIZATION")) {
            PgSchema schema = new PgSchema(ParserUtils.getObjectName(parser.parseIdentifier()));
            database.addSchema(schema);
            schema.setAuthorization(schema.getName());
            String definition = parser.getRest();
            if (definition != null && !definition.isEmpty()) {
                schema.setDefinition(definition);
            }
        } else {
            String definition;
            PgSchema schema = new PgSchema(ParserUtils.getObjectName(parser.parseIdentifier()));
            database.addSchema(schema);
            if (parser.expectOptional("AUTHORIZATION")) {
                schema.setAuthorization(ParserUtils.getObjectName(parser.parseIdentifier()));
            }
            if ((definition = parser.getRest()) != null && !definition.isEmpty()) {
                schema.setDefinition(definition);
            }
        }
    }

    private CreateSchemaParser() {
    }
}

