/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.base.Splitter;
import java.io.File;

public class PropertyFileDetector
extends Detector {
    public static final Issue ISSUE = Issue.create("PropertyEscape", "Incorrect property escapes", "Looks for property files with incorrect paths", "All backslashes and colons in .property files must be escaped with a backslash (\\). This means that when writing a Windows path, you must escape the file separators, so the path \\My\\Files should be written as `key=\\\\My\\\\Files.`", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(PropertyFileDetector.class, Scope.PROPERTY_SCOPE));

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return file.getPath().endsWith(".properties");
    }

    @Override
    public void run(@NonNull Context context) {
        String contents = context.getContents();
        if (contents == null) {
            return;
        }
        int offset = 0;
        for (String line : Splitter.on((char)'\n').split((CharSequence)contents)) {
            int valueStart;
            if (!line.startsWith("#") && !line.startsWith(" ") && line.indexOf(92) != -1 && (valueStart = line.indexOf(61) + 1) != 0 && line.indexOf(92) != -1) {
                PropertyFileDetector.checkLine(context, contents, line, offset, valueStart);
            }
            offset += line.length() + 1;
        }
    }

    private static void checkLine(@NonNull Context context, @NonNull String contents, @NonNull String line, int offset, int valueStart) {
        boolean escaped = false;
        int hadUnescapedColon = -1;
        boolean hadNonPathEscape = false;
        StringBuilder path = new StringBuilder();
        for (int i = valueStart; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                boolean bl = escaped = !escaped;
                if (!escaped) continue;
                path.append(c);
                continue;
            }
            if (escaped) {
                if (c != ':') {
                    hadNonPathEscape = true;
                }
            } else if (c == ':' && hadUnescapedColon == -1) {
                hadUnescapedColon = i;
            }
            escaped = false;
            path.append(c);
        }
        String pathString = path.toString();
        String key = line.substring(0, valueStart);
        if ((hadNonPathEscape || hadUnescapedColon != -1) && key.endsWith(".dir=") || new File(pathString).exists()) {
            if (hadNonPathEscape) {
                String escapedPath = pathString.replace("\\", "\\\\");
                String message = "Windows file separators (\\) must be escaped (\\\\); use " + escapedPath;
                int startOffset = offset + valueStart;
                int endOffset = offset + line.length();
                Location location = Location.create(context.file, contents, startOffset, endOffset);
                context.report(ISSUE, location, message, null);
            }
            if (hadUnescapedColon != -1) {
                String message = "Colon (:) must be escaped in .property files";
                int startOffset = offset + hadUnescapedColon;
                Location location = Location.create(context.file, contents, startOffset, startOffset + 1);
                context.report(ISSUE, location, message, null);
            }
        }
    }
}

