/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.TestResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TestRunResult {
    private static final String LOG_TAG = TestRunResult.class.getSimpleName();
    private final String mTestRunName;
    private Map<TestIdentifier, TestResult> mTestResults = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, String> mRunMetrics = new HashMap<String, String>();
    private boolean mIsRunComplete = false;
    private long mElapsedTime = 0L;
    private int mNumFailedTests = 0;
    private int mNumErrorTests = 0;
    private int mNumPassedTests = 0;
    private int mNumInCompleteTests = 0;
    private String mRunFailureError = null;

    public TestRunResult(String runName) {
        this.mTestRunName = runName;
    }

    public TestRunResult() {
        this("not started");
    }

    public String getName() {
        return this.mTestRunName;
    }

    public Map<TestIdentifier, TestResult> getTestResults() {
        return this.mTestResults;
    }

    public void addMetrics(Map<String, String> runMetrics, boolean aggregateMetrics) {
        if (aggregateMetrics) {
            for (Map.Entry<String, String> entry : runMetrics.entrySet()) {
                String existingValue = this.mRunMetrics.get(entry.getKey());
                String combinedValue = this.combineValues(existingValue, entry.getValue());
                this.mRunMetrics.put(entry.getKey(), combinedValue);
            }
        } else {
            this.mRunMetrics.putAll(runMetrics);
        }
    }

    private String combineValues(String existingValue, String newValue) {
        if (existingValue != null) {
            try {
                Long existingLong = Long.parseLong(existingValue);
                Long newLong = Long.parseLong(newValue);
                return Long.toString(existingLong + newLong);
            }
            catch (NumberFormatException e) {
                try {
                    Double existingDouble = Double.parseDouble(existingValue);
                    Double newDouble = Double.parseDouble(newValue);
                    return Double.toString(existingDouble + newDouble);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return newValue;
    }

    public Map<String, String> getRunMetrics() {
        return this.mRunMetrics;
    }

    public Set<TestIdentifier> getCompletedTests() {
        LinkedHashSet<TestIdentifier> completedTests = new LinkedHashSet<TestIdentifier>();
        for (Map.Entry<TestIdentifier, TestResult> testEntry : this.getTestResults().entrySet()) {
            if (testEntry.getValue().getStatus().equals((Object)TestResult.TestStatus.INCOMPLETE)) continue;
            completedTests.add(testEntry.getKey());
        }
        return completedTests;
    }

    public boolean isRunFailure() {
        return this.mRunFailureError != null;
    }

    public boolean isRunComplete() {
        return this.mIsRunComplete;
    }

    void setRunComplete(boolean runComplete) {
        this.mIsRunComplete = runComplete;
    }

    void addElapsedTime(long elapsedTime) {
        this.mElapsedTime += elapsedTime;
    }

    void setRunFailureError(String errorMessage) {
        this.mRunFailureError = errorMessage;
    }

    public int getNumPassedTests() {
        return this.mNumPassedTests;
    }

    public int getNumTests() {
        return this.mTestResults.size();
    }

    public int getNumCompleteTests() {
        return this.getNumTests() - this.getNumIncompleteTests();
    }

    public int getNumFailedTests() {
        return this.mNumFailedTests;
    }

    public int getNumErrorTests() {
        return this.mNumErrorTests;
    }

    public int getNumIncompleteTests() {
        return this.mNumInCompleteTests;
    }

    public boolean hasFailedTests() {
        return this.getNumErrorTests() > 0 || this.getNumFailedTests() > 0;
    }

    public long getElapsedTime() {
        return this.mElapsedTime;
    }

    public String getRunFailureMessage() {
        return this.mRunFailureError;
    }

    void reportTestStarted(TestIdentifier test) {
        TestResult result = this.mTestResults.get(test);
        if (result != null) {
            Log.d(LOG_TAG, String.format("Replacing result for %s", test));
            switch (result.getStatus()) {
                case ERROR: {
                    --this.mNumErrorTests;
                    break;
                }
                case FAILURE: {
                    --this.mNumFailedTests;
                    break;
                }
                case PASSED: {
                    --this.mNumPassedTests;
                    break;
                }
            }
        } else {
            ++this.mNumInCompleteTests;
        }
        this.mTestResults.put(test, new TestResult());
    }

    void reportTestFailure(TestIdentifier test, TestResult.TestStatus status, String trace) {
        TestResult result = this.mTestResults.get(test);
        if (result == null) {
            Log.d(LOG_TAG, String.format("Received test failure for %s without testStarted", test));
            result = new TestResult();
            this.mTestResults.put(test, result);
        } else if (result.getStatus().equals((Object)TestResult.TestStatus.PASSED)) {
            Log.d(LOG_TAG, String.format("Replacing passed result for %s", test));
            --this.mNumPassedTests;
        }
        result.setStackTrace(trace);
        switch (status) {
            case ERROR: {
                ++this.mNumErrorTests;
                result.setStatus(TestResult.TestStatus.ERROR);
                break;
            }
            case FAILURE: {
                result.setStatus(TestResult.TestStatus.FAILURE);
                ++this.mNumFailedTests;
            }
        }
    }

    boolean reportTestEnded(TestIdentifier test, Map<String, String> testMetrics) {
        TestResult result = this.mTestResults.get(test);
        if (result == null) {
            Log.d(LOG_TAG, String.format("Received test ended for %s without testStarted", test));
            result = new TestResult();
            this.mTestResults.put(test, result);
        } else {
            --this.mNumInCompleteTests;
        }
        result.setEndTime(System.currentTimeMillis());
        result.setMetrics(testMetrics);
        if (result.getStatus().equals((Object)TestResult.TestStatus.INCOMPLETE)) {
            result.setStatus(TestResult.TestStatus.PASSED);
            ++this.mNumPassedTests;
            return true;
        }
        return false;
    }
}

