/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

final class LittleEndian {
    private LittleEndian() {
    }

    public static int getUInt8(byte[] src, int offset) {
        return src[offset] & 0xFF;
    }

    public static int getUInt16(byte[] src, int offset) {
        int v0 = src[offset + 0] & 0xFF;
        int v1 = src[offset + 1] & 0xFF;
        return v1 << 8 | v0;
    }

    public static long getUInt32(byte[] src, int offset) {
        long v0 = src[offset + 0] & 0xFF;
        long v1 = src[offset + 1] & 0xFF;
        long v2 = src[offset + 2] & 0xFF;
        long v3 = src[offset + 3] & 0xFF;
        return v3 << 24 | v2 << 16 | v1 << 8 | v0;
    }

    public static void setInt8(byte[] dst, int offset, int value) {
        dst[offset] = (byte)value;
    }

    public static void setInt16(byte[] dst, int offset, int value) {
        dst[offset + 0] = (byte)(value & 0xFF);
        dst[offset + 1] = (byte)(value >>> 8 & 0xFF);
    }

    public static void setInt32(byte[] dst, int offset, long value) throws IllegalArgumentException {
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(value + " can not be represented in a 32bit dword");
        }
        dst[offset + 0] = (byte)(value & 0xFFL);
        dst[offset + 1] = (byte)(value >>> 8 & 0xFFL);
        dst[offset + 2] = (byte)(value >>> 16 & 0xFFL);
        dst[offset + 3] = (byte)(value >>> 24 & 0xFFL);
    }
}

