/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.core;

import com.android.chimpchat.ChimpManager;
import com.android.chimpchat.core.ChimpView;
import com.android.chimpchat.core.IChimpView;
import com.android.chimpchat.core.IMultiSelector;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiSelectorText
implements IMultiSelector {
    private static final Logger LOG = Logger.getLogger(ChimpView.class.getName());
    private String text;

    public MultiSelectorText(String text) {
        this.text = text;
    }

    @Override
    public Collection<IChimpView> getViews(ChimpManager manager) {
        List<String> ids;
        String response;
        try {
            response = manager.getViewsWithText(this.text);
            ids = Arrays.asList(response.split(" "));
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error communicating with device: " + e.getMessage());
            return new ArrayList<IChimpView>();
        }
        if (ids.size() % 2 == 0) {
            ArrayList<IChimpView> views = new ArrayList<IChimpView>();
            for (int i = 0; i < ids.size() / 2; ++i) {
                ArrayList accessibilityIds = Lists.newArrayList((Object[])new String[]{ids.get(2 * i), ids.get(2 * i + 1)});
                ChimpView view = new ChimpView("accessibilityids", accessibilityIds);
                view.setManager(manager);
                views.add(view);
            }
            return views;
        }
        LOG.log(Level.SEVERE, "Error retrieving views: " + response);
        return Collections.emptyList();
    }
}

