/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.views;

import com.android.ddmlib.Log;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.SelectionDependentPanel;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.logcat.LogColors;
import com.android.ddmuilib.logcat.LogFilter;
import com.android.ddmuilib.logcat.LogPanel;
import com.android.ide.eclipse.ddms.CommonAction;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.i18n.Messages;
import com.android.ide.eclipse.ddms.views.SelectionDependentViewPart;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;

public final class OldLogCatView
extends SelectionDependentViewPart
implements LogPanel.LogCatViewInterface {
    public static final String ID = "com.android.ide.eclipse.ddms.views.OldLogCatView";
    private static final String PREFS_COL_TIME = "com.android.ide.eclipse.ddms.logcat.time";
    private static final String PREFS_COL_LEVEL = "com.android.ide.eclipse.ddms.logcat.level";
    private static final String PREFS_COL_PID = "com.android.ide.eclipse.ddms.logcat.pid";
    private static final String PREFS_COL_TAG = "com.android.ide.eclipse.ddms.logcat.tag";
    private static final String PREFS_COL_MESSAGE = "com.android.ide.eclipse.ddms.logcat.message";
    private static final String PREFS_FILTERS = "com.android.ide.eclipse.ddms.logcat.filters";
    public static final String CHOICE_METHOD_DECLARATION = "com.android.ide.eclipse.ddms.logcat.MethodDeclaration";
    public static final String CHOICE_ERROR_LINE = "com.android.ide.eclipse.ddms.logcat.ErrorLine";
    public static final boolean DEFAULT_SWITCH_PERSPECTIVE = true;
    public static final String DEFAULT_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";
    private static OldLogCatView sThis;
    private LogPanel mLogPanel;
    private CommonAction mCreateFilterAction;
    private CommonAction mDeleteFilterAction;
    private CommonAction mEditFilterAction;
    private CommonAction mExportAction;
    private CommonAction[] mLogLevelActions;
    private String[] mLogLevelIcons = new String[]{"v.png", "d.png", "i.png", "w.png", "e.png"};
    private Action mClearAction;
    private Clipboard mClipboard;

    public OldLogCatView() {
        sThis = this;
        LogPanel.PREFS_TIME = PREFS_COL_TIME;
        LogPanel.PREFS_LEVEL = PREFS_COL_LEVEL;
        LogPanel.PREFS_PID = PREFS_COL_PID;
        LogPanel.PREFS_TAG = PREFS_COL_TAG;
        LogPanel.PREFS_MESSAGE = PREFS_COL_MESSAGE;
    }

    public static OldLogCatView getInstance() {
        return sThis;
    }

    public static void setFont(Font font) {
        if (sThis != null && OldLogCatView.sThis.mLogPanel != null) {
            OldLogCatView.sThis.mLogPanel.setFont(font);
        }
    }

    public void createPartControl(Composite composite) {
        String string;
        Display display = composite.getDisplay();
        LogColors logColors = new LogColors();
        ImageLoader imageLoader = ImageLoader.getDdmUiLibLoader();
        logColors.infoColor = new Color((Device)display, 0, 127, 0);
        logColors.debugColor = new Color((Device)display, 0, 0, 127);
        logColors.errorColor = new Color((Device)display, 255, 0, 0);
        logColors.warningColor = new Color((Device)display, 255, 127, 0);
        logColors.verboseColor = new Color((Device)display, 0, 0, 0);
        this.mCreateFilterAction = new CommonAction(Messages.LogCatView_Create_Filter){

            @Override
            public void run() {
                OldLogCatView.this.mLogPanel.addFilter();
            }
        };
        this.mCreateFilterAction.setToolTipText(Messages.LogCatView_Create_Filter_Tooltip);
        this.mCreateFilterAction.setImageDescriptor(imageLoader.loadDescriptor("add.png"));
        this.mEditFilterAction = new CommonAction(Messages.LogCatView_Edit_Filter){

            @Override
            public void run() {
                OldLogCatView.this.mLogPanel.editFilter();
            }
        };
        this.mEditFilterAction.setToolTipText(Messages.LogCatView_Edit_Filter_Tooltip);
        this.mEditFilterAction.setImageDescriptor(imageLoader.loadDescriptor("edit.png"));
        this.mDeleteFilterAction = new CommonAction(Messages.LogCatView_Delete_Filter){

            @Override
            public void run() {
                OldLogCatView.this.mLogPanel.deleteFilter();
            }
        };
        this.mDeleteFilterAction.setToolTipText(Messages.LogCatView_Delete_Filter_Tooltip);
        this.mDeleteFilterAction.setImageDescriptor(imageLoader.loadDescriptor("delete.png"));
        this.mExportAction = new CommonAction(Messages.LogCatView_Export_Selection_As_Text){

            @Override
            public void run() {
                OldLogCatView.this.mLogPanel.save();
            }
        };
        this.mExportAction.setToolTipText(Messages.LogCatView_Export_Selection_As_Text_Tooltip);
        this.mExportAction.setImageDescriptor(imageLoader.loadDescriptor("save.png"));
        Log.LogLevel[] logLevelArray = Log.LogLevel.values();
        this.mLogLevelActions = new CommonAction[this.mLogLevelIcons.length];
        int n = 0;
        while (n < this.mLogLevelActions.length) {
            string = logLevelArray[n].getStringValue();
            this.mLogLevelActions[n] = new CommonAction(string, 2){

                @Override
                public void run() {
                    int n = 0;
                    while (n < OldLogCatView.this.mLogLevelActions.length) {
                        CommonAction commonAction = OldLogCatView.this.mLogLevelActions[n];
                        if (commonAction == this) {
                            commonAction.setChecked(true);
                            OldLogCatView.this.mLogPanel.setCurrentFilterLogLevel(n + 2);
                        } else {
                            commonAction.setChecked(false);
                        }
                        ++n;
                    }
                }
            };
            this.mLogLevelActions[n].setToolTipText(string);
            this.mLogLevelActions[n].setImageDescriptor(imageLoader.loadDescriptor(this.mLogLevelIcons[n]));
            ++n;
        }
        this.mClearAction = new Action(Messages.LogCatView_Clear_Log){

            public void run() {
                OldLogCatView.this.mLogPanel.clear();
            }
        };
        this.mClearAction.setImageDescriptor(imageLoader.loadDescriptor("clear.png"));
        this.mLogPanel = new LogPanel(logColors, (LogPanel.ILogFilterStorageManager)new FilterStorage(), 1);
        this.mLogPanel.setLogCatViewInterface((LogPanel.LogCatViewInterface)this);
        this.mLogPanel.setActions((ICommonAction)this.mDeleteFilterAction, (ICommonAction)this.mEditFilterAction, (ICommonAction[])this.mLogLevelActions);
        String string2 = DdmsPlugin.getDefault().getPreferenceStore().getString("com.android.ide.eclipse.ddms.logcatFont");
        if (string2 != null) {
            string = new FontData(string2);
            this.mLogPanel.setFont(new Font((Device)composite.getDisplay(), (FontData)string));
        }
        this.mLogPanel.createPanel(composite);
        this.setSelectionDependentPanel((SelectionDependentPanel)this.mLogPanel);
        this.placeActions();
        this.mClipboard = new Clipboard(display);
        string = this.getViewSite().getActionBars();
        string.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(Messages.LogCatView_Copy){

            public void run() {
                OldLogCatView.this.mLogPanel.copy(OldLogCatView.this.mClipboard);
            }
        });
        string.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action(Messages.LogCatView_Select_All){

            public void run() {
                OldLogCatView.this.mLogPanel.selectAll();
            }
        });
    }

    @Override
    public void dispose() {
        this.mLogPanel.stopLogCat(true);
        this.mClipboard.dispose();
    }

    public void setFocus() {
        this.mLogPanel.setFocus();
    }

    private void placeActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IAction)this.mCreateFilterAction);
        iMenuManager.add((IAction)this.mEditFilterAction);
        iMenuManager.add((IAction)this.mDeleteFilterAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mClearAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mExportAction);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        CommonAction[] commonActionArray = this.mLogLevelActions;
        int n = this.mLogLevelActions.length;
        int n2 = 0;
        while (n2 < n) {
            CommonAction commonAction = commonActionArray[n2];
            iToolBarManager.add((IAction)commonAction);
            ++n2;
        }
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mCreateFilterAction);
        iToolBarManager.add((IAction)this.mEditFilterAction);
        iToolBarManager.add((IAction)this.mDeleteFilterAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mClearAction);
    }

    void openFile(IFile iFile, IMarker iMarker) {
        try {
            IWorkbenchPage iWorkbenchPage = this.getViewSite().getWorkbenchWindow().getActivePage();
            if (iWorkbenchPage != null) {
                IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IMarker)iMarker);
                iMarker.delete();
            }
        }
        catch (CoreException coreException) {
            Status status = new Status(4, "com.android.ide.eclipse.ddms", coreException.getMessage(), (Throwable)coreException);
            DdmsPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    void switchPerspective() {
        IPreferenceStore iPreferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore.getBoolean("com.android.ide.eclipse.ddms.switchPerspective")) {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
            IPerspectiveRegistry iPerspectiveRegistry = iWorkbench.getPerspectiveRegistry();
            String string = iPreferenceStore.getString("com.android.ide.eclipse.ddms.perspectiveId");
            if (string != null && string.length() > 0 && iPerspectiveRegistry.findPerspectiveWithId(string) != null) {
                try {
                    iWorkbench.showPerspective(string, iWorkbenchWindow);
                }
                catch (WorkbenchException workbenchException) {
                    workbenchException.printStackTrace();
                }
            }
        }
    }

    public void onDoubleClick() {
    }

    private final class FilterStorage
    implements LogPanel.ILogFilterStorageManager {
        private FilterStorage() {
        }

        public LogFilter[] getFilterFromStore() {
            String string = DdmsPlugin.getDefault().getPreferenceStore().getString(OldLogCatView.PREFS_FILTERS);
            String[] stringArray = string.split("\\|");
            ArrayList<LogFilter> arrayList = new ArrayList<LogFilter>(stringArray.length);
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogFilter logFilter;
                String string2 = stringArray2[n2];
                if (string2.length() > 0 && (logFilter = new LogFilter()).loadFromString(string2)) {
                    arrayList.add(logFilter);
                }
                ++n2;
            }
            return arrayList.toArray(new LogFilter[arrayList.size()]);
        }

        public void saveFilters(LogFilter[] logFilterArray) {
            StringBuilder stringBuilder = new StringBuilder();
            LogFilter[] logFilterArray2 = logFilterArray;
            int n = logFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogFilter logFilter = logFilterArray2[n2];
                String string = logFilter.toString();
                stringBuilder.append(string);
                stringBuilder.append('|');
                ++n2;
            }
            DdmsPlugin.getDefault().getPreferenceStore().setValue(OldLogCatView.PREFS_FILTERS, stringBuilder.toString());
        }

        public boolean requiresDefaultFilter() {
            return true;
        }
    }
}

