/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class OverrideDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create("DalvikOverride", "Method considered overridden by Dalvik", "Looks for methods treated as overrides by Dalvik", "The Android virtual machine will treat a package private method in one class as overriding a package private method in its super class, even if they are in separate packages. This may be surprising, but for compatibility reasons the behavior has not been changed (yet).\n\nIf you really did intend for this method to override the other, make the method `protected` instead.\n\nIf you did *not* intend the override, consider making the method private, or changing its name or signature.", Category.CORRECTNESS, 7, Severity.ERROR, new Implementation(OverrideDetector.class, EnumSet.of(Scope.ALL_CLASS_FILES)));
    private final Map<String, Set<String>> mPackagePrivateMethods = Maps.newHashMap();
    private Map<String, Map<String, String>> mErrors;
    private Map<String, Map<String, Location>> mLocations;

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (context.getPhase() == 1) {
            Set<String> classes = this.mPackagePrivateMethods.keySet();
            LintDriver driver = context.getDriver();
            for (String owner : classes) {
                Set<String> methods = this.mPackagePrivateMethods.get(owner);
                String superClass = driver.getSuperClass(owner);
                int packageIndex = owner.lastIndexOf(47);
                while (superClass != null) {
                    Sets.SetView intersection;
                    Set<String> superMethods;
                    int superPackageIndex = superClass.lastIndexOf(47);
                    if (!(packageIndex != -1 && superPackageIndex == packageIndex && owner.regionMatches(0, superClass, 0, packageIndex) || (superMethods = this.mPackagePrivateMethods.get(superClass)) == null || (intersection = Sets.intersection(methods, superMethods)).isEmpty())) {
                        if (this.mLocations == null) {
                            this.mLocations = Maps.newHashMap();
                        }
                        if (this.mErrors == null) {
                            this.mErrors = Maps.newHashMap();
                        }
                        for (String signature : intersection) {
                            Map<Object, Object> locations = this.mLocations.get(owner);
                            if (locations == null) {
                                locations = Maps.newHashMap();
                                this.mLocations.put(owner, (Map<String, Location>)locations);
                            }
                            locations.put(signature, null);
                            locations = this.mLocations.get(superClass);
                            if (locations == null) {
                                locations = Maps.newHashMap();
                                this.mLocations.put(superClass, locations);
                            }
                            locations.put(signature, null);
                            HashMap errors = this.mErrors.get(owner);
                            if (errors == null) {
                                errors = Maps.newHashMap();
                                this.mErrors.put(owner, errors);
                            }
                            errors.put(signature, superClass);
                        }
                    }
                    superClass = driver.getSuperClass(superClass);
                }
            }
            if (this.mErrors != null) {
                context.requestRepeat(this, ISSUE.getImplementation().getScope());
            }
        } else {
            assert (context.getPhase() == 2);
            for (Map.Entry<String, Map<String, String>> ownerEntry : this.mErrors.entrySet()) {
                String owner = ownerEntry.getKey();
                Map<String, String> methodToSuper = ownerEntry.getValue();
                for (Map.Entry<String, String> entry : methodToSuper.entrySet()) {
                    String methodName;
                    int index;
                    Location superLocation;
                    Location location;
                    String signature = entry.getKey();
                    String superClass = entry.getValue();
                    Map<String, Location> ownerLocations = this.mLocations.get(owner);
                    if (ownerLocations == null || (location = ownerLocations.get(signature)) == null) continue;
                    Map<String, Location> superLocations = this.mLocations.get(superClass);
                    if (superLocations != null && (superLocation = superLocations.get(signature)) != null) {
                        location.setSecondary(superLocation);
                        superLocation.setMessage("This method is treated as overridden");
                    }
                    if ((index = (methodName = signature).indexOf(40)) != -1) {
                        methodName = methodName.substring(0, index);
                    }
                    String message = String.format("This package private method may be unintentionally overriding %1$s in %2$s", methodName, ClassContext.getFqcn(superClass));
                    context.report(ISSUE, location, message, null);
                }
            }
        }
    }

    @Override
    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        List methodList = classNode.methods;
        if (context.getPhase() == 1) {
            for (Object m : methodList) {
                MethodNode method = (MethodNode)m;
                int access = method.access;
                if ((access & 0xF) != 0 || "<init>".equals(method.name)) continue;
                String owner = classNode.name;
                HashSet methods = this.mPackagePrivateMethods.get(owner);
                if (methods == null) {
                    methods = Sets.newHashSetWithExpectedSize((int)methodList.size());
                    this.mPackagePrivateMethods.put(owner, methods);
                }
                methods.add(method.name + method.desc);
            }
        } else {
            assert (context.getPhase() == 2);
            Map<String, Location> methods = this.mLocations.get(classNode.name);
            if (methods == null) {
                return;
            }
            for (Object m : methodList) {
                MethodNode method = (MethodNode)m;
                String signature = method.name + method.desc;
                if (!methods.containsKey(signature)) continue;
                if (context.getDriver().isSuppressed(ISSUE, classNode, method, null)) {
                    Map<String, String> errors = this.mErrors.get(classNode.name);
                    if (errors == null) continue;
                    errors.remove(signature);
                    continue;
                }
                Location location = context.getLocation(method, classNode);
                methods.put(signature, location);
                String description = ClassContext.createSignature(classNode.name, method.name, method.desc);
                location.setClientData(description);
            }
        }
    }
}

