/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ide.eclipse.gltrace.TraceOptions;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class GLTraceOptionsDialog
extends TitleAreaDialog {
    private static final String TITLE = "OpenGL ES Trace Options";
    private static final String DEFAULT_MESSAGE = "Provide the application and activity to be traced.";
    private static final String PREF_APP_PACKAGE = "gl.trace.apppackage";
    private static final String PREF_ACTIVITY = "gl.trace.activity";
    private static final String PREF_TRACEFILE = "gl.trace.destfile";
    private static final String PREF_DEVICE = "gl.trace.device";
    private String mLastUsedDevice;
    private static String sSaveToFolder = System.getProperty("user.home");
    private Button mOkButton;
    private Combo mDeviceCombo;
    private Text mAppPackageToTraceText;
    private Text mActivityToTraceText;
    private Button mIsActivityFullyQualifiedButton;
    private Text mTraceFilePathText;
    private String mSelectedDevice = "";
    private String mAppPackageToTrace = "";
    private String mActivityToTrace = "";
    private String mTraceFilePath = "";
    private boolean mAllowAppSelection;
    private static boolean sCollectFbOnEglSwap = true;
    private static boolean sCollectFbOnGlDraw = false;
    private static boolean sCollectTextureData = false;
    private static boolean sIsActivityFullyQualified = false;
    private IDevice[] mDevices;

    public GLTraceOptionsDialog(Shell shell) {
        this(shell, true, null);
    }

    public GLTraceOptionsDialog(Shell shell, boolean bl, String string) {
        super(shell);
        this.loadPreferences();
        this.mAllowAppSelection = bl;
        if (string != null) {
            this.mAppPackageToTrace = string;
        }
    }

    protected Control createDialogArea(Composite composite) {
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 2048);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(1808));
        this.createLabel(composite3, "Device:");
        this.mDevices = AndroidDebugBridge.getBridge().getDevices();
        this.createDeviceDropdown(composite3, this.mDevices);
        this.createSeparator(composite3);
        this.createLabel(composite3, "Application Package:");
        this.createAppToTraceText(composite3, "e.g. com.example.package");
        this.createLabel(composite3, "Activity to launch:");
        this.createActivityToTraceText(composite3, "Leave blank to launch default activity");
        this.createLabel(composite3, "");
        this.createIsFullyQualifedActivityButton(composite3, "Activity name is fully qualified, do not prefix with package name");
        if (!this.mAllowAppSelection) {
            this.mAppPackageToTraceText.setEnabled(false);
            this.mActivityToTraceText.setEnabled(false);
            this.mIsActivityFullyQualifiedButton.setEnabled(false);
        }
        this.createSeparator(composite3);
        this.createLabel(composite3, "Data Collection Options:");
        this.createCaptureImageOptions(composite3);
        this.createSeparator(composite3);
        this.createLabel(composite3, "Destination File: ");
        this.createSaveToField(composite3);
        return composite3;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.mOkButton = this.getButton(0);
        this.mOkButton.setText("Trace");
        DialogStatus dialogStatus = this.validateDialog();
        this.mOkButton.setEnabled(dialogStatus.valid);
    }

    private void createSeparator(Composite composite) {
        Label label = new Label(composite, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createSaveToField(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.mTraceFilePathText = new Text(composite2, 2048);
        this.mTraceFilePathText.setLayoutData((Object)new GridData(768));
        this.mTraceFilePathText.setText(this.mTraceFilePath);
        this.mTraceFilePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GLTraceOptionsDialog.this.validateAndSetMessage();
            }
        });
        Button button = new Button(composite2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = GLTraceOptionsDialog.this.openBrowseDialog();
                if (string == null) {
                    return;
                }
                GLTraceOptionsDialog.this.mTraceFilePathText.setText(string);
                GLTraceOptionsDialog.this.validateAndSetMessage();
            }
        });
    }

    private String openBrowseDialog() {
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        fileDialog.setText("Save To");
        fileDialog.setFileName("trace1.gltrace");
        fileDialog.setFilterPath(sSaveToFolder);
        fileDialog.setFilterExtensions(new String[]{"*.gltrace"});
        String string = fileDialog.open();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        sSaveToFolder = fileDialog.getFilterPath();
        return string;
    }

    private void createCaptureImageOptions(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        final Button button = new Button(composite2, 32);
        button.setText("Read back framebuffer 0 on eglSwapBuffers()");
        button.setSelection(sCollectFbOnEglSwap);
        final Button button2 = new Button(composite2, 32);
        button2.setText("Read back currently bound framebuffer On glDraw*()");
        button2.setSelection(sCollectFbOnGlDraw);
        final Button button3 = new Button(composite2, 32);
        button3.setText("Collect texture data submitted using glTexImage*()");
        button3.setSelection(sCollectTextureData);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                sCollectFbOnEglSwap = button.getSelection();
                sCollectFbOnGlDraw = button2.getSelection();
                sCollectTextureData = button3.getSelection();
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        button2.addSelectionListener((SelectionListener)selectionAdapter);
        button3.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private Text createAppToTraceText(Composite composite, String string) {
        this.mAppPackageToTraceText = new Text(composite, 2048);
        this.mAppPackageToTraceText.setMessage(string);
        this.mAppPackageToTraceText.setText(this.mAppPackageToTrace);
        this.mAppPackageToTraceText.setLayoutData((Object)new GridData(768));
        this.mAppPackageToTraceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GLTraceOptionsDialog.this.validateAndSetMessage();
            }
        });
        return this.mActivityToTraceText;
    }

    private Text createActivityToTraceText(Composite composite, String string) {
        this.mActivityToTraceText = new Text(composite, 2048);
        this.mActivityToTraceText.setMessage(string);
        this.mActivityToTraceText.setText(this.mActivityToTrace);
        this.mActivityToTraceText.setLayoutData((Object)new GridData(768));
        this.mActivityToTraceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                GLTraceOptionsDialog.this.validateAndSetMessage();
            }
        });
        return this.mActivityToTraceText;
    }

    private Button createIsFullyQualifedActivityButton(Composite composite, String string) {
        this.mIsActivityFullyQualifiedButton = new Button(composite, 32);
        this.mIsActivityFullyQualifiedButton.setText(string);
        this.mIsActivityFullyQualifiedButton.setLayoutData((Object)new GridData(768));
        this.mIsActivityFullyQualifiedButton.setSelection(sIsActivityFullyQualified);
        return this.mIsActivityFullyQualifiedButton;
    }

    private void validateAndSetMessage() {
        DialogStatus dialogStatus = this.validateDialog();
        this.mOkButton.setEnabled(dialogStatus.valid);
        this.setErrorMessage(dialogStatus.message);
    }

    private Combo createDeviceDropdown(Composite composite, IDevice[] iDeviceArray) {
        this.mDeviceCombo = new Combo(composite, 2056);
        ArrayList<String> arrayList = new ArrayList<String>(iDeviceArray.length);
        IDevice[] iDeviceArray2 = iDeviceArray;
        int n = iDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice iDevice = iDeviceArray2[n2];
            arrayList.add(iDevice.getName());
            ++n2;
        }
        this.mDeviceCombo.setItems(arrayList.toArray(new String[arrayList.size()]));
        int n3 = 0;
        if (arrayList.contains(this.mLastUsedDevice)) {
            n3 = arrayList.indexOf(this.mLastUsedDevice);
        }
        if (n3 >= 0 && n3 < arrayList.size()) {
            this.mDeviceCombo.select(n3);
        }
        return this.mDeviceCombo;
    }

    private void createLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)gridData);
    }

    private DialogStatus validateDialog() {
        if (this.mDevices.length == 0) {
            return new DialogStatus(false, "No connected devices.");
        }
        if (this.mAppPackageToTraceText.getText().trim().isEmpty()) {
            return new DialogStatus(false, "Provide an application name");
        }
        String string = this.mTraceFilePathText.getText().trim();
        if (string.isEmpty()) {
            return new DialogStatus(false, "Specify the location where the trace will be saved.");
        }
        File file = new File(string).getParentFile();
        if (file != null && !file.exists()) {
            return new DialogStatus(false, String.format("Folder %s does not exist", file.getAbsolutePath()));
        }
        return new DialogStatus(true, null);
    }

    protected void okPressed() {
        this.mAppPackageToTrace = this.mAppPackageToTraceText.getText().trim();
        this.mActivityToTrace = this.mActivityToTraceText.getText().trim();
        if (this.mActivityToTrace.startsWith(".")) {
            this.mActivityToTrace = this.mActivityToTrace.substring(1);
        }
        sIsActivityFullyQualified = this.mIsActivityFullyQualifiedButton.getSelection();
        this.mTraceFilePath = this.mTraceFilePathText.getText().trim();
        this.mSelectedDevice = this.mDeviceCombo.getText();
        this.savePreferences();
        super.okPressed();
    }

    private void savePreferences() {
        IEclipsePreferences iEclipsePreferences = new InstanceScope().getNode("com.android.ide.eclipse.gldebugger");
        iEclipsePreferences.put(PREF_APP_PACKAGE, this.mAppPackageToTrace);
        iEclipsePreferences.put(PREF_ACTIVITY, this.mActivityToTrace);
        iEclipsePreferences.put(PREF_TRACEFILE, this.mTraceFilePath);
        iEclipsePreferences.put(PREF_DEVICE, this.mSelectedDevice);
        try {
            iEclipsePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private void loadPreferences() {
        IEclipsePreferences iEclipsePreferences = new InstanceScope().getNode("com.android.ide.eclipse.gldebugger");
        this.mAppPackageToTrace = iEclipsePreferences.get(PREF_APP_PACKAGE, "");
        this.mActivityToTrace = iEclipsePreferences.get(PREF_ACTIVITY, "");
        this.mTraceFilePath = iEclipsePreferences.get(PREF_TRACEFILE, "");
        this.mLastUsedDevice = iEclipsePreferences.get(PREF_DEVICE, "");
    }

    public TraceOptions getTraceOptions() {
        return new TraceOptions(this.mSelectedDevice, this.mAppPackageToTrace, this.mActivityToTrace, sIsActivityFullyQualified, this.mTraceFilePath, sCollectFbOnEglSwap, sCollectFbOnGlDraw, sCollectTextureData);
    }

    private final class DialogStatus {
        final boolean valid;
        final String message;

        private DialogStatus(boolean bl, String string) {
            this.valid = bl;
            this.message = string;
        }
    }
}

