/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeButtonDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ComboDrawData
extends DrawData {
    public ComboDrawData() {
        this.state = new int[2];
    }

    HIThemeButtonDrawInfo getInfo() {
        int n = this.state[0];
        HIThemeButtonDrawInfo hIThemeButtonDrawInfo = new HIThemeButtonDrawInfo();
        hIThemeButtonDrawInfo.version = 0;
        hIThemeButtonDrawInfo.kind = 16;
        if ((this.style & 8) != 0) {
            hIThemeButtonDrawInfo.kind = 5;
        }
        if ((n & 0x20) != 0) {
            hIThemeButtonDrawInfo.state = (n & 0x10) != 0 ? 7 : 8;
        } else if ((this.style & 8) != 0 && (n & 8) != 0 || (this.style & 8) == 0 && (this.state[1] & 8) != 0) {
            hIThemeButtonDrawInfo.state = 2;
        } else {
            int n2 = hIThemeButtonDrawInfo.state = (n & 0x10) != 0 ? 1 : 0;
        }
        if ((n & 4) != 0) {
            hIThemeButtonDrawInfo.adornment |= 4;
        }
        return hIThemeButtonDrawInfo;
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        Object object;
        HIThemeButtonDrawInfo hIThemeButtonDrawInfo = this.getInfo();
        CGRect cGRect = new CGRect();
        cGRect.x = rectangle.x;
        cGRect.y = rectangle.y;
        cGRect.width = rectangle.width;
        cGRect.height = rectangle.height;
        int n = 0;
        int n2 = 0;
        if ((this.style & 8) == 0) {
            object = new int[1];
            OS.GetThemeMetric(7, object);
            n = object[0];
            OS.GetThemeMetric(74, object);
            n2 = object[0];
            cGRect.x += (float)n;
            cGRect.y += (float)n;
            cGRect.width -= (float)(2 * n);
            cGRect.height -= (float)(2 * n);
        } else {
            object = new CGRect();
            OS.HIThemeGetButtonBackgroundBounds(cGRect, hIThemeButtonDrawInfo, (CGRect)object);
            cGRect.x += cGRect.x - object.x;
            cGRect.y += cGRect.y - object.y;
            cGRect.width -= object.width - cGRect.width;
            cGRect.height -= object.height - cGRect.height;
        }
        object = this.clientArea != null && (this.style & 8) != 0 ? new CGRect() : null;
        OS.HIThemeDrawButton(cGRect, hIThemeButtonDrawInfo, gC.handle, 0, (CGRect)object);
        if (this.clientArea != null) {
            if ((this.style & 8) != 0) {
                this.clientArea.x = (int)object.x;
                this.clientArea.y = (int)object.y;
                this.clientArea.width = (int)object.width;
                this.clientArea.height = (int)object.height;
            } else {
                this.clientArea.x = rectangle.x + n;
                this.clientArea.y = rectangle.y + n;
                this.clientArea.width = rectangle.width - 2 * n - n2;
                this.clientArea.height = rectangle.height - 2 * n;
            }
        }
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        if ((this.style & 8) == 0) {
            int[] nArray = new int[1];
            OS.GetThemeMetric(7, nArray);
            int n = nArray[0];
            OS.GetThemeMetric(74, nArray);
            int n2 = nArray[0];
            Rectangle rectangle2 = new Rectangle(rectangle.x + rectangle.width - n - n2, rectangle.y - n, n2, rectangle.height - n * 2);
            if (rectangle2.contains(point)) {
                return 1;
            }
        }
        return 0;
    }
}

