/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.ResourceLoader;
import com.vladium.util.XProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public abstract class Property {
    private static String s_systemFingerprint;
    private static Properties s_systemProperties;
    private static Properties s_systemRedirects;

    public static boolean toBoolean(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("t") || string.startsWith("y");
    }

    public static Properties combine(Properties properties, Properties properties2) {
        if (properties2 == null) {
            if (properties == null) {
                return new XProperties();
            }
            return properties;
        }
        if (properties == null) {
            return properties2;
        }
        XProperties xProperties = new XProperties(properties2);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            xProperties.setProperty(string, string2);
        }
        return xProperties;
    }

    public static Properties getAppProperties(String string, ClassLoader classLoader) {
        if (string == null) {
            throw new IllegalArgumentException("null properties: appNameLC");
        }
        Properties properties = Property.getProperties(string + "_default.properties", classLoader);
        Object object = Property.getSystemProperty(string + ".properties");
        Serializable serializable = object != null ? new File((String)object) : null;
        Properties properties2 = Property.getLazyPropertiesFromFile(serializable);
        object = Property.getSystemProperties(string);
        serializable = Property.getProperties(string + ".properties", classLoader);
        return Property.combine((Properties)serializable, Property.combine((Properties)object, Property.combine(properties2, properties)));
    }

    public static Properties getSystemProperties(String string) {
        Properties properties = s_systemProperties;
        if (properties == null) {
            s_systemProperties = properties = new SystemPropertyLookup(string);
            return properties;
        }
        return properties;
    }

    public static Properties getSystemPropertyRedirects(Map map) {
        Properties properties = s_systemRedirects;
        if (properties == null) {
            s_systemRedirects = properties = new SystemRedirectsLookup(map);
            return properties;
        }
        return properties;
    }

    public static String getSystemFingerprint() {
        if (s_systemFingerprint != null) {
            return s_systemFingerprint;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Property.getSystemProperty("java.vm.name", ""));
        stringBuffer.append(':');
        stringBuffer.append(Property.getSystemProperty("java.vm.version", ""));
        stringBuffer.append(':');
        stringBuffer.append(Property.getSystemProperty("java.vm.vendor", ""));
        stringBuffer.append(':');
        stringBuffer.append(Property.getSystemProperty("os.name", ""));
        stringBuffer.append(':');
        stringBuffer.append(Property.getSystemProperty("os.version", ""));
        stringBuffer.append(':');
        stringBuffer.append(Property.getSystemProperty("os.arch", ""));
        s_systemFingerprint = stringBuffer.toString();
        return s_systemFingerprint;
    }

    public static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String string) {
        XProperties xProperties = null;
        InputStream inputStream = null;
        try {
            inputStream = ResourceLoader.getResourceAsStream(string);
            if (inputStream != null) {
                xProperties = new XProperties();
                xProperties.load(inputStream);
            }
        }
        catch (Throwable throwable) {
            xProperties = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
            inputStream = null;
        }
        return xProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String string, ClassLoader classLoader) {
        XProperties xProperties = null;
        InputStream inputStream = null;
        try {
            inputStream = ResourceLoader.getResourceAsStream(string, classLoader);
            if (inputStream != null) {
                xProperties = new XProperties();
                xProperties.load(inputStream);
            }
        }
        catch (Throwable throwable) {
            xProperties = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
            inputStream = null;
        }
        return xProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromFile(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        XProperties xProperties = null;
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file), 8192);
            xProperties = new XProperties();
            xProperties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
            inputStream = null;
        }
        return xProperties;
    }

    public static Properties getLazyPropertiesFromFile(File file) {
        return new FilePropertyLookup(file);
    }

    private static final class SystemRedirectsLookup
    extends XProperties {
        private final Map m_systemRedirects;

        public String getProperty(String string) {
            return (String)this.get(string);
        }

        public Object get(Object object) {
            String string;
            if (!(object instanceof String)) {
                return null;
            }
            String string2 = (String)super.get(object);
            if (string2 != null) {
                return string2;
            }
            if (this.m_systemRedirects != null && (string = (String)this.m_systemRedirects.get(object)) != null && (string2 = Property.getSystemProperty(string, null)) != null) {
                return string2;
            }
            return string2;
        }

        public synchronized Enumeration keys() {
            Hashtable hashtable = new Hashtable();
            if (this.m_systemRedirects != null) {
                for (Object k : this.m_systemRedirects.keySet()) {
                    if (k == null) continue;
                    hashtable.put(k, k);
                }
            }
            return hashtable.keys();
        }

        SystemRedirectsLookup(Map map) {
            this.m_systemRedirects = map;
        }
    }

    private static final class SystemPropertyLookup
    extends XProperties {
        private final String m_systemPrefix;

        public String getProperty(String string) {
            return (String)this.get(string);
        }

        public Object get(Object object) {
            if (!(object instanceof String)) {
                return null;
            }
            String string = (String)super.get(object);
            if (string != null) {
                return string;
            }
            if (this.m_systemPrefix != null && (string = Property.getSystemProperty(this.m_systemPrefix.concat((String)object), null)) != null) {
                return string;
            }
            return string;
        }

        public synchronized Enumeration keys() {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.m_systemPrefix != null) {
                try {
                    int n = this.m_systemPrefix.length();
                    Enumeration<?> enumeration = System.getProperties().propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (!string.startsWith(this.m_systemPrefix)) continue;
                        String string2 = string.substring(n);
                        hashtable.put(string2, string2);
                    }
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace(System.out);
                }
            }
            return hashtable.keys();
        }

        SystemPropertyLookup(String string) {
            if (string != null && !string.endsWith(".")) {
                string = string.concat(".");
            }
            this.m_systemPrefix = string;
        }
    }

    private static final class FilePropertyLookup
    extends XProperties {
        private final File m_src;
        private Properties m_contents;

        public String getProperty(String string) {
            this.faultContents();
            return this.m_contents.getProperty(string);
        }

        public Object get(Object object) {
            this.faultContents();
            return this.m_contents.get(object);
        }

        public Enumeration keys() {
            this.faultContents();
            return this.m_contents.keys();
        }

        FilePropertyLookup(File file) {
            this.m_src = file;
        }

        private synchronized void faultContents() {
            Properties properties = this.m_contents;
            if (properties == null && this.m_src != null) {
                try {
                    properties = Property.getPropertiesFromFile(this.m_src);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new RuntimeException("exception while processing properties file [" + this.m_src.getAbsolutePath() + "]: " + exception);
                }
            }
            if (properties == null) {
                properties = new XProperties();
            }
            this.m_contents = properties;
        }
    }
}

