/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.AppLoggers;
import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppConstants;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.Processor;
import com.vladium.emma.data.CoverageOptionsFactory;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.SessionData;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.IReportGenerator;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.rt.ClassPathProcessorST;
import com.vladium.emma.rt.InstrClassLoadHook;
import com.vladium.emma.rt.InstrClassLoader;
import com.vladium.emma.rt.RT;
import com.vladium.emma.rt.RTSettings;
import com.vladium.logging.Logger;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import com.vladium.util.SoftValueMap;
import com.vladium.util.Strings;
import com.vladium.util.exception.Exceptions;
import com.vladium.util.exit.ExitHookManager;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class AppRunner
extends Processor
implements IAppErrorCodes {
    private final ClassLoader m_delegate;
    private String m_appClassName;
    private String[] m_appArgs;
    private File[] m_coveragePath;
    private boolean m_canonical;
    private boolean m_scanCoveragePath;
    private IInclExclFilter m_coverageFilter;
    private boolean m_dumpSessionData;
    private File m_sdataOutFile;
    private Boolean m_sdataOutMerge;
    private IReportGenerator[] m_reportGenerators;
    private File[] m_sourcePath;
    private static final boolean INIT_AT_LOAD_TIME = false;
    private static final boolean SET_CURRENT_CONTEXT_LOADER = false;
    private static final boolean USE_SOFT_CACHE = true;
    private static final int INIT_CACHE_CAPACITY = 2003;
    private static final int SOFT_CACHE_READ_CHK_FREQUENCY = 100;
    private static final int SOFT_CACHE_WRITE_CHK_FREQUENCY = 100;
    private static final String[] FORCED_DELEGATION_FILTER_SPECS;
    private static final Class[] MAIN_TYPE;
    private static final Class[] EXPECTED_FAILURES;
    protected static final String COMMA_DELIMITERS = ", \t\r\n";
    protected static final String PATH_DELIMITERS;

    public static AppRunner create(ClassLoader classLoader) {
        return new AppRunner(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        IProperties iProperties;
        Logger logger;
        this.validateState();
        RTSettings.setStandaloneMode(false);
        RT.reset(true, false);
        Object object = RT.getAppProperties();
        if (object == null) {
            object = EMMAProperties.getAppProperties();
        }
        if ((logger = AppLoggers.create(this.m_appName, iProperties = IProperties.Factory.combine(this.m_propertyOverrides, (IProperties)object), (Logger)(object = Logger.getLogger()))).atTRACE1()) {
            logger.trace1("run", "complete tool properties:");
            iProperties.list(logger.getWriter());
        }
        try {
            Logger.push(logger);
            this.m_log = logger;
            this._run(iProperties);
        }
        finally {
            if (this.m_log != null) {
                Logger.pop(this.m_log);
                this.m_log = null;
            }
        }
    }

    public synchronized void setCoveragePath(String[] stringArray, boolean bl) {
        this.m_coveragePath = stringArray == null || stringArray.length == 0 ? IConstants.EMPTY_FILE_ARRAY : Files.pathToFiles(stringArray, bl);
        this.m_canonical = bl;
    }

    public synchronized void setScanCoveragePath(boolean bl) {
        this.m_scanCoveragePath = bl;
    }

    public synchronized void setSourcePath(String[] stringArray) {
        this.m_sourcePath = stringArray == null ? null : Files.pathToFiles(stringArray, true);
    }

    public final synchronized void setInclExclFilter(String[] stringArray) {
        this.m_coverageFilter = stringArray == null ? null : IInclExclFilter.Factory.create(stringArray);
    }

    public synchronized void setAppClass(String string, String[] stringArray) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null/empty input: className");
        }
        if (stringArray != null) {
            String[] stringArray2 = (String[])stringArray.clone();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i] != null) continue;
                throw new IllegalArgumentException("null input: args[" + i + "]");
            }
            this.m_appArgs = stringArray2;
        } else {
            this.m_appArgs = IConstants.EMPTY_STRING_ARRAY;
        }
        this.m_appClassName = string;
    }

    public synchronized void setDumpSessionData(boolean bl) {
        this.m_dumpSessionData = bl;
    }

    public final synchronized void setSessionOutFile(String string) {
        if (string == null) {
            this.m_sdataOutFile = null;
        } else {
            File file = new File(string);
            if (file.exists() && !file.isFile()) {
                throw new IllegalArgumentException("not a file: [" + file.getAbsolutePath() + "]");
            }
            this.m_sdataOutFile = file;
        }
    }

    public final synchronized void setSessionOutMerge(Boolean bl) {
        this.m_sdataOutMerge = bl;
    }

    public synchronized void setReportTypes(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("null input: types");
        }
        String[] stringArray2 = Strings.removeDuplicates(stringArray, true);
        if (stringArray2.length == 0) {
            throw new IllegalArgumentException("empty input: types");
        }
        IReportGenerator[] iReportGeneratorArray = new IReportGenerator[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            iReportGeneratorArray[i] = AbstractReportGenerator.create(stringArray2[i]);
        }
        this.m_reportGenerators = iReportGeneratorArray;
    }

    protected void validateState() {
        super.validateState();
        if (this.m_appClassName == null || this.m_appClassName.length() == 0) {
            throw new IllegalStateException("application class name not set");
        }
        if (this.m_appArgs == null) {
            throw new IllegalStateException("application arguments not set");
        }
        if (this.m_coveragePath == null) {
            throw new IllegalStateException("coverage path not set");
        }
        if (this.m_reportGenerators == null || this.m_reportGenerators.length == 0) {
            throw new IllegalStateException("report types not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _run(IProperties iProperties) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        Object object5;
        Comparable<Boolean> comparable;
        Logger logger = this.m_log;
        boolean bl = logger.atVERBOSE();
        if (bl) {
            int n;
            logger.verbose("[EMMA v0.0, build 0 (unsupported private build) (unknown)]");
            logger.verbose("coverage path:");
            logger.verbose("{");
            for (n = 0; n < this.m_coveragePath.length; ++n) {
                comparable = this.m_coveragePath[n];
                object5 = ((File)comparable).exists() ? "" : "{nonexistent} ";
                logger.verbose("  " + (String)object5 + ((File)comparable).getAbsolutePath());
            }
            logger.verbose("}");
            if (this.m_sourcePath == null || this.m_sourcePath.length == 0) {
                logger.verbose("source path not set");
            } else {
                logger.verbose("source path:");
                logger.verbose("{");
                for (n = 0; n < this.m_sourcePath.length; ++n) {
                    comparable = this.m_sourcePath[n];
                    object5 = ((File)comparable).exists() ? "" : "{nonexistent} ";
                    logger.verbose("  " + (String)object5 + ((File)comparable).getAbsolutePath());
                }
                logger.verbose("}");
            }
        }
        File file = this.m_sdataOutFile;
        comparable = this.m_sdataOutMerge;
        if (file == null) {
            file = new File(iProperties.getProperty("session.out.file", "coverage.es"));
        }
        if (comparable == null) {
            object5 = iProperties.getProperty("session.out.merge", EMMAProperties.DEFAULT_SESSION_DATA_OUT_MERGE.toString());
            Comparable<Boolean> comparable2 = comparable = Property.toBoolean((String)object5) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (bl && this.m_dumpSessionData) {
            logger.verbose("session data output file: " + file.getAbsolutePath());
            logger.verbose("session data output merge mode: " + comparable);
        }
        object5 = IInclExclFilter.Factory.create(iProperties.getProperty("clsload.forced_delegation_filter"), COMMA_DELIMITERS, FORCED_DELEGATION_FILTER_SPECS);
        IInclExclFilter iInclExclFilter = IInclExclFilter.Factory.create(iProperties.getProperty("clsload.through_delegation_filter"), COMMA_DELIMITERS, null);
        ExitHookManager exitHookManager = null;
        try {
            exitHookManager = ExitHookManager.getSingleton();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        AppRunnerExitHook appRunnerExitHook = null;
        RuntimeException runtimeException = null;
        try {
            object4 = null;
            if (this.m_sourcePath != null) {
                object4 = new SourcePathCache(this.m_sourcePath, true);
            }
            object3 = RT.getCoverageData();
            serializable = DataFactory.newMetaData(CoverageOptionsFactory.create(iProperties));
            appRunnerExitHook = new AppRunnerExitHook(logger, this.m_dumpSessionData, file, (Boolean)comparable, (IMetaData)serializable, (ICoverageData)object3, this.m_reportGenerators, (SourcePathCache)object4, iProperties);
            if (exitHookManager != null) {
                exitHookManager.addExitHook(appRunnerExitHook);
            }
            object2 = null;
            if (this.m_scanCoveragePath) {
                object2 = new SoftValueMap(2003, 0.75f, 100, 100);
                object = new ClassPathProcessorST(this.m_coveragePath, this.m_canonical, (IMetaData)serializable, this.m_coverageFilter, (Map)object2);
                ((ClassPathProcessorST)object).run();
                if (logger.atTRACE1()) {
                    logger.trace1("run", "class cache size after cp scan: " + object2.size());
                    logger.trace1("run", "metadata size after cp scan: " + serializable.size());
                }
            }
            object4 = null;
            object3 = null;
            InstrClassLoadHook instrClassLoadHook = new InstrClassLoadHook(this.m_coverageFilter, (IMetaData)serializable);
            try {
                object = new InstrClassLoader(this.m_delegate, this.m_coveragePath, (IInclExclFilter)object5, iInclExclFilter, instrClassLoadHook, (Map)object2);
            }
            catch (SecurityException securityException) {
                throw new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, securityException);
            }
            catch (MalformedURLException malformedURLException) {
                throw new EMMARuntimeException(malformedURLException);
            }
            serializable = null;
            object2 = null;
            boolean bl2 = false;
            ThreadGroup threadGroup = null;
            try {
                Class<?> clazz;
                try {
                    clazz = Class.forName(this.m_appClassName, false, (ClassLoader)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new EMMARuntimeException("MAIN_CLASS_NOT_FOUND", new String[]{this.m_appClassName}, classNotFoundException);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    Throwable throwable = exceptionInInitializerError.getException();
                    throw new EMMARuntimeException("MAIN_CLASS_LOAD_FAILURE", new String[]{this.m_appClassName, throwable.toString()}, throwable);
                }
                catch (Throwable throwable) {
                    throw new EMMARuntimeException("MAIN_CLASS_NOT_FOUND", new String[]{this.m_appClassName}, throwable);
                }
                Object object6 = clazz.getClassLoader();
                if (object6 != object) {
                    String string = object6 != null ? object6.getClass().getName() : "<PRIMORDIAL>";
                    throw new EMMARuntimeException("MAIN_CLASS_BAD_DELEGATION", new String[]{"EMMA", this.m_appClassName, string});
                }
                try {
                    object6 = clazz.getMethod("main", MAIN_TYPE);
                }
                catch (Throwable throwable) {
                    throw new EMMARuntimeException("MAIN_METHOD_NOT_FOUND", new String[]{this.m_appClassName}, throwable);
                }
                Invoker invoker = new Invoker((Method)object6, null, new Object[]{this.m_appArgs});
                threadGroup = new ThreadGroup("EMMA thread group [" + this.m_appClassName + "]");
                threadGroup.setDaemon(true);
                Thread thread = new Thread(threadGroup, invoker, "EMMA main() thread");
                thread.setContextClassLoader((ClassLoader)object);
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                thread = null;
                AppRunner.joinNonDeamonThreads(threadGroup);
                if (logger.atTRACE1() && object instanceof InstrClassLoader) {
                    ((InstrClassLoader)object).debugDump(logger.getWriter());
                }
                Throwable throwable = invoker.getFailure();
                invoker = null;
                if (throwable != null) {
                    if (throwable instanceof InvocationTargetException) {
                        Throwable throwable2 = ((InvocationTargetException)throwable).getTargetException();
                        throw new EMMARuntimeException("MAIN_METHOD_FAILURE", new String[]{this.m_appClassName, throwable2.toString()}, throwable2);
                    }
                    if (throwable instanceof ExceptionInInitializerError) {
                        Throwable throwable3 = ((ExceptionInInitializerError)throwable).getException();
                        throw new EMMARuntimeException("MAIN_METHOD_FAILURE", new String[]{this.m_appClassName, throwable3.toString()}, throwable3);
                    }
                    if (throwable instanceof IllegalAccessException || throwable instanceof IllegalArgumentException || throwable instanceof NullPointerException) {
                        throw new EMMARuntimeException("MAIN_METHOD_NOT_FOUND", new String[]{this.m_appClassName}, throwable);
                    }
                    throw new EMMARuntimeException("MAIN_METHOD_FAILURE", new String[]{this.m_appClassName, throwable.toString()}, throwable);
                }
            }
            catch (SecurityException securityException) {
                throw new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, securityException);
            }
            finally {
                if (threadGroup != null && !threadGroup.isDestroyed()) {
                    try {
                        threadGroup.destroy();
                        threadGroup = null;
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
        }
        finally {
            RT.reset(false, false);
        }
        appRunnerExitHook.run();
        if (exitHookManager != null) {
            exitHookManager.removeExitHook(appRunnerExitHook);
            exitHookManager = null;
        }
        object4 = appRunnerExitHook.getDataDumpFailure();
        object3 = appRunnerExitHook.getReportFailures();
        appRunnerExitHook = null;
        if (runtimeException != null) {
            throw AppRunner.wrapFailure(runtimeException);
        }
        if (object4 != null || object3 != null) {
            if (object4 != null) {
                logger.log(0, "exception while persisting raw session data:", (Throwable)object4);
            }
            serializable = null;
            if (object3 != null) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Throwable)object2.next();
                    if (serializable == null) {
                        serializable = object;
                    }
                    logger.log(0, "exception while creating a report:", (Throwable)object);
                }
            }
            if (object4 != null) {
                throw AppRunner.wrapFailure((Throwable)object4);
            }
            if (serializable != null) {
                throw AppRunner.wrapFailure((Throwable)serializable);
            }
        }
    }

    private AppRunner(ClassLoader classLoader) {
        this.m_delegate = classLoader;
        this.m_coveragePath = IConstants.EMPTY_FILE_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void joinNonDeamonThreads(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new IllegalArgumentException("null input: group");
        }
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        block5: while (true) {
            int n;
            Thread[] threadArray;
            arrayList.clear();
            Object object = threadGroup;
            synchronized (object) {
                threadArray = new Thread[threadGroup.activeCount() << 1];
                n = threadGroup.enumerate(threadArray, true);
            }
            for (int i = 0; i < n; ++i) {
                if (threadArray[i].isDaemon()) continue;
                arrayList.add(threadArray[i]);
            }
            threadArray = null;
            if (arrayList.isEmpty()) break;
            object = arrayList.iterator();
            while (true) {
                if (!object.hasNext()) continue block5;
                try {
                    ((Thread)object.next()).join();
                }
                catch (InterruptedException interruptedException) {}
            }
            break;
        }
    }

    private static RuntimeException wrapFailure(Throwable throwable) {
        if (Exceptions.unexpectedFailure(throwable, EXPECTED_FAILURES)) {
            return new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{throwable.toString(), "this private build is unsupported"}, throwable);
        }
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new EMMARuntimeException(throwable);
    }

    static {
        MAIN_TYPE = new Class[]{String[].class};
        PATH_DELIMITERS = ",".concat(File.pathSeparator);
        EXPECTED_FAILURES = new Class[]{EMMARuntimeException.class, IllegalArgumentException.class, IllegalStateException.class};
        FORCED_DELEGATION_FILTER_SPECS = new String[]{"+" + IAppConstants.APP_PACKAGE + ".*"};
    }

    private static final class AppRunnerExitHook
    implements Runnable {
        private final Logger m_log;
        private final boolean m_dumpRawData;
        private final File m_sdataOutFile;
        private final boolean m_sdataOutMerge;
        private IReportGenerator[] m_generators;
        private IMetaData m_mdata;
        private ICoverageData m_cdata;
        private SourcePathCache m_cache;
        private IProperties m_properties;
        private boolean m_done;
        private Throwable m_dataDumpFailure;
        private List m_reportFailures;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            block23: {
                try {
                    int n;
                    if (this.m_done) break block23;
                    IMetaData iMetaData = this.m_mdata.shallowCopy();
                    this.m_mdata = null;
                    ICoverageData iCoverageData = this.m_cdata.shallowCopy();
                    this.m_cdata = null;
                    if (iMetaData.isEmpty()) {
                        this.m_log.warning("no metadata collected at runtime [no reports generated]");
                        return;
                    }
                    if (iCoverageData.isEmpty()) {
                        this.m_log.warning("no coverage data collected at runtime [all reports will be empty]");
                    }
                    SessionData sessionData = new SessionData(iMetaData, iCoverageData);
                    if (this.m_dumpRawData && this.m_sdataOutFile != null) {
                        try {
                            n = this.m_log.atINFO() ? 1 : 0;
                            long l = n != 0 ? System.currentTimeMillis() : 0L;
                            DataFactory.persist(sessionData, this.m_sdataOutFile, this.m_sdataOutMerge);
                            if (n != 0) {
                                long l2 = System.currentTimeMillis();
                                this.m_log.info("raw session data " + (this.m_sdataOutMerge ? "merged into" : "written to") + " [" + this.m_sdataOutFile.getAbsolutePath() + "] {in " + (l2 - l) + " ms}");
                            }
                        }
                        catch (Throwable throwable) {
                            this.m_dataDumpFailure = throwable;
                        }
                    }
                    for (n = 0; n < this.m_generators.length; ++n) {
                        IReportGenerator iReportGenerator = this.m_generators[n];
                        if (iReportGenerator == null) continue;
                        try {
                            iReportGenerator.process(iMetaData, iCoverageData, this.m_cache, this.m_properties);
                            continue;
                        }
                        catch (Throwable throwable) {
                            if (this.m_reportFailures == null) {
                                this.m_reportFailures = new ArrayList();
                            }
                            this.m_reportFailures.add(throwable);
                            continue;
                        }
                        finally {
                            try {
                                iReportGenerator.cleanup();
                            }
                            catch (Throwable throwable) {}
                            this.m_generators[n] = null;
                        }
                    }
                }
                finally {
                    this.m_generators = null;
                    this.m_mdata = null;
                    this.m_cdata = null;
                    this.m_properties = null;
                    this.m_cache = null;
                    this.m_done = true;
                }
            }
        }

        AppRunnerExitHook(Logger logger, boolean bl, File file, boolean bl2, IMetaData iMetaData, ICoverageData iCoverageData, IReportGenerator[] iReportGeneratorArray, SourcePathCache sourcePathCache, IProperties iProperties) {
            if (logger == null) {
                throw new IllegalArgumentException("null input: log");
            }
            if (iReportGeneratorArray == null || iReportGeneratorArray.length == 0) {
                throw new IllegalArgumentException("null/empty input: generators");
            }
            if (iMetaData == null) {
                throw new IllegalArgumentException("null input: mdata");
            }
            if (iCoverageData == null) {
                throw new IllegalArgumentException("null input: cdata");
            }
            if (iProperties == null) {
                throw new IllegalArgumentException("null input: properties");
            }
            this.m_log = logger;
            this.m_dumpRawData = bl;
            this.m_sdataOutFile = file;
            this.m_sdataOutMerge = bl2;
            this.m_generators = (IReportGenerator[])iReportGeneratorArray.clone();
            this.m_mdata = iMetaData;
            this.m_cdata = iCoverageData;
            this.m_cache = sourcePathCache;
            this.m_properties = iProperties;
        }

        synchronized Throwable getDataDumpFailure() {
            return this.m_dataDumpFailure;
        }

        synchronized List getReportFailures() {
            return this.m_reportFailures;
        }
    }

    private static final class Invoker
    implements Runnable {
        private final Method m_method;
        private final Object m_target;
        private final Object[] m_args;
        private Throwable m_failure;

        Invoker(Method method, Object object, Object[] objectArray) {
            if (method == null) {
                throw new IllegalArgumentException("null input: method");
            }
            if (objectArray == null) {
                throw new IllegalArgumentException("null input: args");
            }
            this.m_method = method;
            this.m_target = object;
            this.m_args = objectArray;
        }

        public void run() {
            try {
                this.m_method.invoke(this.m_target, this.m_args);
            }
            catch (Throwable throwable) {
                this.m_failure = throwable;
            }
        }

        Throwable getFailure() {
            return this.m_failure;
        }
    }
}

