/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.txt;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.report.AbstractReportGenerator;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemAttribute;
import com.vladium.emma.report.ItemComparator;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SourcePathCache;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.util.Files;
import com.vladium.util.IProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;

public final class ReportGenerator
extends AbstractReportGenerator
implements IAppErrorCodes {
    private char m_separator = (char)9;
    private LinkedList m_queue;
    private BufferedWriter m_out;
    private static final String TYPE = "txt";
    private static final String LINE = "-------------------------------------------------------------------------------";
    private static final int IO_BUF_SIZE = 32768;

    public String getType() {
        return TYPE;
    }

    public void process(IMetaData iMetaData, ICoverageData iCoverageData, SourcePathCache sourcePathCache, IProperties iProperties) throws EMMARuntimeException {
        this.initialize(iMetaData, iCoverageData, sourcePathCache, iProperties);
        long l = 0L;
        boolean bl = this.m_log.atTRACE1();
        if (bl) {
            l = System.currentTimeMillis();
        }
        this.m_queue = new LinkedList();
        this.m_queue.add(this.m_view.getRoot());
        while (!this.m_queue.isEmpty()) {
            IItem iItem = (IItem)this.m_queue.removeFirst();
            iItem.accept(this, null);
        }
        this.line();
        this.close();
        if (bl) {
            long l2 = System.currentTimeMillis();
            this.m_log.trace1("process", "[" + this.getType() + "] report generated in " + (l2 - l) + " ms");
        }
    }

    public void cleanup() {
        this.m_queue = null;
        this.close();
        super.cleanup();
    }

    public Object visit(AllItem allItem, Object object) {
        Object object2;
        File file = this.m_settings.getOutFile();
        if (file == null) {
            file = new File("coverage.txt");
            this.m_settings.setOutFile(file);
        }
        File file2 = Files.newFile(this.m_settings.getOutDir(), file);
        this.m_log.info("writing [" + this.getType() + "] report to [" + file2.getAbsolutePath() + "] ...");
        this.openOutFile(file2, this.m_settings.getOutEncoding(), true);
        try {
            object2 = new StringBuffer(101);
            ((StringBuffer)object2).append("[");
            ((StringBuffer)object2).append("EMMA");
            ((StringBuffer)object2).append(" v");
            ((StringBuffer)object2).append("0.0.0 (unsupported private build)");
            ((StringBuffer)object2).append(" report, generated ");
            ((StringBuffer)object2).append(new Date(EMMAProperties.getTimeStamp()));
            ((StringBuffer)object2).append("]");
            this.m_out.write(((StringBuffer)object2).toString());
            this.m_out.newLine();
            this.m_out.flush();
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
        object2 = this.m_settings.getColumnOrder();
        this.line();
        this.addTitleRow("OVERALL COVERAGE SUMMARY", 0, 1);
        this.addHeaderRow(allItem, (int[])object2);
        this.addItemRow(allItem, (int[])object2);
        this.addTitleRow("OVERALL STATS SUMMARY", 1, 1);
        this.row("total packages:" + this.m_separator + allItem.getChildCount());
        this.row("total classes:" + this.m_separator + allItem.getAggregate(11));
        this.row("total methods:" + this.m_separator + allItem.getAggregate(10));
        if (this.m_srcView && this.m_hasSrcFileInfo) {
            this.row("total executable files:" + this.m_separator + allItem.getAggregate(12));
            if (this.m_hasLineNumberInfo) {
                this.row("total executable lines:" + this.m_separator + allItem.getAggregate(7));
            }
        }
        boolean bl = this.m_settings.getDepth() > allItem.getMetadata().getTypeID();
        this.addTitleRow("COVERAGE BREAKDOWN BY PACKAGE", 1, 1);
        boolean bl2 = false;
        ItemComparator itemComparator = this.m_typeSortComparators[PackageItem.getTypeMetadata().getTypeID()];
        Iterator iterator = allItem.getChildren(itemComparator);
        while (iterator.hasNext()) {
            IItem iItem = (IItem)iterator.next();
            if (!bl2) {
                this.addHeaderRow(iItem, (int[])object2);
                bl2 = true;
            }
            this.addItemRow(iItem, (int[])object2);
            if (!bl) continue;
            this.m_queue.addLast(iItem);
        }
        return object;
    }

    public Object visit(PackageItem packageItem, Object object) {
        if (this.m_verbose) {
            this.m_log.verbose("  report: processing package [" + packageItem.getName() + "] ...");
        }
        int[] nArray = this.m_settings.getColumnOrder();
        this.line();
        this.addTitleRow("COVERAGE SUMMARY FOR PACKAGE [".concat(packageItem.getName()).concat("]"), 0, 1);
        this.addHeaderRow(packageItem, nArray);
        this.addItemRow(packageItem, nArray);
        boolean bl = this.m_settings.getDepth() > packageItem.getMetadata().getTypeID();
        String string = this.m_srcView ? "COVERAGE BREAKDOWN BY SOURCE FILE" : "COVERAGE BREAKDOWN BY CLASS";
        this.addTitleRow(string, 1, 1);
        boolean bl2 = false;
        ItemComparator itemComparator = this.m_typeSortComparators[this.m_srcView ? SrcFileItem.getTypeMetadata().getTypeID() : ClassItem.getTypeMetadata().getTypeID()];
        Iterator iterator = packageItem.getChildren(itemComparator);
        while (iterator.hasNext()) {
            IItem iItem = (IItem)iterator.next();
            if (!bl2) {
                this.addHeaderRow(iItem, nArray);
                bl2 = true;
            }
            this.addItemRow(iItem, nArray);
            if (!bl) continue;
            this.m_queue.addLast(iItem);
        }
        return object;
    }

    public Object visit(SrcFileItem srcFileItem, Object object) {
        int[] nArray = this.m_settings.getColumnOrder();
        this.line();
        this.addTitleRow("COVERAGE SUMMARY FOR SOURCE FILE [".concat(srcFileItem.getName()).concat("]"), 0, 1);
        this.addHeaderRow(srcFileItem, nArray);
        this.addItemRow(srcFileItem, nArray);
        this.addTitleRow("COVERAGE BREAKDOWN BY CLASS AND METHOD", 1, 1);
        boolean bl = false;
        ItemComparator itemComparator = this.m_typeSortComparators[ClassItem.getTypeMetadata().getTypeID()];
        Iterator iterator = srcFileItem.getChildren(itemComparator);
        while (iterator.hasNext()) {
            IItem iItem = (IItem)iterator.next();
            if (!bl) {
                this.addHeaderRow(iItem, nArray);
                bl = true;
            }
            this.addTitleRow("class [" + iItem.getName() + "] methods", 0, 0);
            ItemComparator itemComparator2 = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
            Iterator iterator2 = iItem.getChildren(itemComparator2);
            while (iterator2.hasNext()) {
                MethodItem methodItem = (MethodItem)iterator2.next();
                this.addItemRow(methodItem, nArray);
            }
        }
        return object;
    }

    public Object visit(ClassItem classItem, Object object) {
        int[] nArray = this.m_settings.getColumnOrder();
        this.line();
        this.addTitleRow("COVERAGE SUMMARY FOR CLASS [".concat(classItem.getName()).concat("]"), 0, 1);
        this.addHeaderRow(classItem, nArray);
        this.addItemRow(classItem, nArray);
        this.addTitleRow("COVERAGE BREAKDOWN BY METHOD", 1, 1);
        ItemComparator itemComparator = this.m_typeSortComparators[MethodItem.getTypeMetadata().getTypeID()];
        Iterator iterator = classItem.getChildren(itemComparator);
        while (iterator.hasNext()) {
            IItem iItem = (IItem)iterator.next();
            this.addItemRow(iItem, nArray);
        }
        return object;
    }

    private void addTitleRow(String string, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n; ++n3) {
            this.eol();
        }
        this.row(new StringBuffer(string).append(":"));
        for (n3 = 0; n3 < n2; ++n3) {
            this.eol();
        }
    }

    private void addHeaderRow(IItem iItem, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            IItemAttribute iItemAttribute = iItem.getAttribute(n2, this.m_settings.getUnitsType());
            if (iItemAttribute != null) {
                stringBuffer.append('[');
                stringBuffer.append(iItemAttribute.getName());
                stringBuffer.append(']');
            }
            if (i == n - 1) continue;
            stringBuffer.append(this.m_separator);
        }
        this.row(stringBuffer);
    }

    private void addItemRow(IItem iItem, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(11);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            IItemAttribute iItemAttribute = iItem.getAttribute(n2, this.m_settings.getUnitsType());
            if (iItemAttribute != null) {
                boolean bl;
                boolean bl2 = bl = this.m_metrics[n2] > 0 && !iItemAttribute.passes(iItem, this.m_metrics[n2]);
                if (bl) {
                    iItemAttribute.format(iItem, stringBuffer);
                    stringBuffer.append('!');
                } else {
                    iItemAttribute.format(iItem, stringBuffer);
                }
            }
            if (i == n - 1) continue;
            stringBuffer.append(this.m_separator);
        }
        this.row(stringBuffer);
    }

    private void row(StringBuffer stringBuffer) {
        try {
            this.m_out.write(stringBuffer.toString());
            this.m_out.newLine();
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
    }

    private void row(String string) {
        try {
            this.m_out.write(string);
            this.m_out.newLine();
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
    }

    private void line() {
        try {
            this.m_out.write(LINE);
            this.m_out.newLine();
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
    }

    private void eol() {
        try {
            this.m_out.newLine();
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
        }
    }

    private void close() {
        if (this.m_out != null) {
            try {
                this.m_out.flush();
                this.m_out.close();
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", iOException);
            }
            finally {
                this.m_out = null;
            }
        }
    }

    private void openOutFile(File file, String string, boolean bl) {
        try {
            File file2;
            if (bl && (file2 = file.getParentFile()) != null) {
                file2.mkdirs();
            }
            this.m_out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string), 32768);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EMMARuntimeException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new EMMARuntimeException(iOException);
        }
    }
}

