/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.IMetadataConstants;
import com.vladium.util.IConstants;
import com.vladium.util.IntObjectMap;
import com.vladium.util.IntSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class MethodDescriptor
implements IConstants,
IMetadataConstants,
Serializable {
    private final String m_name;
    private final String m_descriptor;
    private final int m_status;
    private final int[] m_blockSizes;
    private final int[][] m_blockMap;
    private final int m_firstLine;
    private IntObjectMap m_lineMap;

    public MethodDescriptor(String string, String string2, int n, int[] nArray, int[][] nArray2, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("null input: name");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("null input: descriptor");
        }
        if ((n & 0xE) == 0) {
            int n3 = nArray.length;
            this.m_blockSizes = nArray;
            if ((n & 0xF) == 0) {
                if (nArray2 == null || nArray2.length == 0) {
                    throw new IllegalArgumentException("null or empty input: blockMap");
                }
                this.m_blockMap = nArray2;
                this.m_firstLine = n2;
            } else {
                this.m_blockMap = null;
                this.m_firstLine = 0;
            }
        } else {
            this.m_blockSizes = null;
            this.m_blockMap = null;
            this.m_firstLine = 0;
        }
        this.m_name = string;
        this.m_descriptor = string2;
        this.m_status = n;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescriptor() {
        return this.m_descriptor;
    }

    public int getStatus() {
        return this.m_status;
    }

    public int getBlockCount() {
        return this.m_blockSizes.length;
    }

    public int[] getBlockSizes() {
        return this.m_blockSizes;
    }

    public int[][] getBlockMap() {
        return this.m_blockMap;
    }

    public IntObjectMap getLineMap() {
        IntObjectMap intObjectMap = this.m_lineMap;
        if (intObjectMap != null) {
            return intObjectMap;
        }
        if ((this.m_status & 0xF) == 0) {
            intObjectMap = new IntObjectMap();
            int[][] nArray = this.m_blockMap;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] nArray2 = nArray[i];
                if (nArray2 == null) continue;
                for (int n2 : nArray2) {
                    IntSet intSet = (IntSet)intObjectMap.get(n2);
                    if (intSet == null) {
                        intSet = new IntSet();
                        intObjectMap.put(n2, intSet);
                    }
                    intSet.add(i);
                }
            }
            for (int n3 : intObjectMap.keys()) {
                int[] nArray3 = ((IntSet)intObjectMap.get(n3)).values();
                intObjectMap.put(n3, nArray3);
            }
            this.m_lineMap = intObjectMap;
            return intObjectMap;
        }
        return null;
    }

    public int getFirstLine() {
        return this.m_firstLine;
    }

    public boolean hasLineNumberInfo() {
        return (this.m_status & 0xF) == 0;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string + "method [" + this.m_name + "] descriptor:");
        if ((this.m_status & 0xF) == 0) {
            for (int i = 0; i < this.m_blockMap.length; ++i) {
                stringBuffer.append(EOL);
                stringBuffer.append(string + "  " + "block " + i + " (" + this.m_blockSizes[i] + " instrs) : ");
                int[] nArray = this.m_blockMap[i];
                for (int j = 0; j < nArray.length; ++j) {
                    if (j != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(nArray[j]);
                }
            }
            stringBuffer.append(EOL);
            stringBuffer.append(string + "  " + "---");
            int[] nArray = this.m_lineMap.keys();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(EOL);
                stringBuffer.append(string + "  " + "line " + nArray[i] + ": ");
                int[] nArray2 = (int[])this.m_lineMap.get(nArray[i]);
                for (int j = 0; j < nArray2.length; ++j) {
                    if (j != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(nArray2[j]);
                }
            }
        } else {
            stringBuffer.append(" <no line info>");
        }
        return stringBuffer.toString();
    }

    static MethodDescriptor readExternal(DataInput dataInput) throws IOException {
        String string = dataInput.readUTF();
        String string2 = dataInput.readUTF();
        int n = dataInput.readInt();
        int[] nArray = null;
        Object object = null;
        int n2 = 0;
        if ((n & 0xE) == 0) {
            nArray = DataFactory.readIntArray(dataInput);
            if ((n & 0xF) == 0) {
                int n3 = dataInput.readInt();
                object = new int[n3][];
                for (int i = 0; i < n3; ++i) {
                    object[i] = DataFactory.readIntArray(dataInput);
                }
                n2 = dataInput.readInt();
            }
        }
        return new MethodDescriptor(string, string2, n, nArray, (int[][])object, n2);
    }

    static void writeExternal(MethodDescriptor methodDescriptor, DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(methodDescriptor.m_name);
        dataOutput.writeUTF(methodDescriptor.m_descriptor);
        int n = methodDescriptor.m_status;
        dataOutput.writeInt(n);
        if ((n & 0xE) == 0) {
            DataFactory.writeIntArray(methodDescriptor.m_blockSizes, dataOutput);
            if ((n & 0xF) == 0) {
                int[][] nArray = methodDescriptor.m_blockMap;
                int n2 = nArray.length;
                dataOutput.writeInt(n2);
                for (int i = 0; i < n2; ++i) {
                    DataFactory.writeIntArray(nArray[i], dataOutput);
                }
                dataOutput.writeInt(methodDescriptor.m_firstLine);
            }
        }
    }
}

