/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.support;

import java.util.LinkedList;
import lombok.ast.libs.org.parboiled.common.Factory;
import lombok.ast.libs.org.parboiled.common.Reference;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Var<T>
extends Reference<T> {
    private Factory<T> initialValueFactory;
    private LinkedList<T> stack;
    private int level;
    private String name;

    public Var() {
        this((Object)null);
    }

    public Var(final T value) {
        super(value);
        this.initialValueFactory = new Factory<T>(){

            @Override
            public T create() {
                return value;
            }
        };
    }

    public Var(@NotNull Factory<T> initialValueFactory) {
        if (initialValueFactory == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.support.Var.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this.initialValueFactory = initialValueFactory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean enterFrame() {
        if (this.level++ > 0) {
            if (this.stack == null) {
                this.stack = new LinkedList();
            }
            this.stack.add(this.getAndClear());
        }
        return this.set(this.initialValueFactory.create());
    }

    public boolean exitFrame() {
        if (--this.level > 0) {
            this.set(this.stack.removeLast());
        }
        return true;
    }

    public String toString() {
        return this.name != null ? this.name : super.toString();
    }
}

